/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorBladeState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorComponentType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.zerocore.base.multiblock.part.GenericDeviceBlock;
import it.zerono.mods.zerocore.base.multiblock.part.INeverCauseRenderingSkip;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class TurbineRotorComponentBlock
extends GenericDeviceBlock<MultiblockTurbine, ITurbinePartType>
implements INeighborChangeListener.Notifier,
INeverCauseRenderingSkip {
    public static final EnumProperty<RotorShaftState> ROTOR_SHAFT_STATE = EnumProperty.m_61587_((String)"state", RotorShaftState.class);
    public static final EnumProperty<RotorBladeState> ROTOR_BLADE_STATE = EnumProperty.m_61587_((String)"state", RotorBladeState.class);
    private Component _bladeTooltipInfo;

    public static TurbineRotorComponentBlock shaft(MultiblockPartBlock.MultiblockPartProperties<ITurbinePartType> properties) {
        return new TurbineRotorComponentBlock((MultiblockPartBlock.MultiblockPartProperties)properties){

            @Override
            public boolean isShaft() {
                return true;
            }

            @Override
            public boolean isBlade() {
                return false;
            }

            @Override
            public RotorComponentType getComponentType() {
                return RotorComponentType.Shaft;
            }

            protected void buildBlockState(StateDefinition.Builder<Block, BlockState> builder) {
                super.buildBlockState(builder);
                builder.m_61104_(new Property[]{ROTOR_SHAFT_STATE});
            }

            protected BlockState buildDefaultState(BlockState state) {
                return (BlockState)super.buildDefaultState(state).m_61124_((Property)ROTOR_SHAFT_STATE, (Comparable)((Object)RotorShaftState.getDefault()));
            }
        };
    }

    public static TurbineRotorComponentBlock blade(MultiblockPartBlock.MultiblockPartProperties<ITurbinePartType> properties) {
        return new TurbineRotorComponentBlock((MultiblockPartBlock.MultiblockPartProperties)properties){

            @Override
            public boolean isShaft() {
                return false;
            }

            @Override
            public boolean isBlade() {
                return true;
            }

            @Override
            public RotorComponentType getComponentType() {
                return RotorComponentType.Blade;
            }

            protected void buildBlockState(StateDefinition.Builder<Block, BlockState> builder) {
                super.buildBlockState(builder);
                builder.m_61104_(new Property[]{ROTOR_BLADE_STATE});
            }

            protected BlockState buildDefaultState(BlockState state) {
                return (BlockState)super.buildDefaultState(state).m_61124_((Property)ROTOR_BLADE_STATE, (Comparable)((Object)RotorBladeState.getDefault()));
            }
        };
    }

    public abstract boolean isShaft();

    public abstract boolean isBlade();

    public abstract RotorComponentType getComponentType();

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return this == adjacentBlockState.m_60734_();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        if (this.isBlade()) {
            if (null == this._bladeTooltipInfo) {
                this._bladeTooltipInfo = this.getMultiblockVariant().filter(v -> v instanceof IMultiblockTurbineVariant).map(v -> (IMultiblockTurbineVariant)v).map(variant -> Component.m_237110_((String)"gui.bigreactors.turbine.controller.rotorstatus.tooltip.value2", (Object[])new Object[]{String.format(ChatFormatting.DARK_AQUA + ChatFormatting.BOLD + "%d", variant.getBaseFluidPerBlade())}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true)))).orElse(CodeHelper.TEXT_EMPTY_LINE);
            }
            tooltip.add(this._bladeTooltipInfo);
        }
    }

    protected TurbineRotorComponentBlock(MultiblockPartBlock.MultiblockPartProperties<ITurbinePartType> properties) {
        super(properties);
    }
}

