/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.util.TranslationKey;

public class PotionFilterCard
extends Item {
    public PotionFilterCard() {
        super(new Item.Properties().m_41487_(1).setNoRepair());
    }

    public static int getMinimumDuration() {
        return (Integer)ConfigManager.SERVER.infusionMinimumDuration.get() * 20;
    }

    public static int getRequiredDuration() {
        return (Integer)ConfigManager.SERVER.infusionRequiredDuration.get() * 20;
    }

    public static int getAppliedDuration() {
        return (Integer)ConfigManager.SERVER.infusionAppliedDuration.get() * 20;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof PotionFilterCard) {
            if (!level.f_46443_) {
                Optional<MobEffectInstance> active;
                ItemStack offhand;
                MobEffect effect = PotionFilterCard.getEffect(stack);
                int amplifier = PotionFilterCard.getAmplifier(stack);
                int duration = PotionFilterCard.getDuration(stack);
                if (duration >= PotionFilterCard.getRequiredDuration()) {
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                if (hand == InteractionHand.MAIN_HAND && (offhand = player.m_21120_(InteractionHand.OFF_HAND)).m_41720_() instanceof PotionFilterCard) {
                    MobEffect offhandEffect = PotionFilterCard.getEffect(offhand);
                    int offhandAmplifier = PotionFilterCard.getAmplifier(offhand);
                    int offhandDuration = PotionFilterCard.getDuration(offhand);
                    if (offhandEffect != null) {
                        if (effect == null) {
                            ItemStack copy = PotionFilterCard.withEffect(stack, offhandEffect, offhandAmplifier, offhandDuration);
                            player.m_21008_(InteractionHand.OFF_HAND, PotionFilterCard.clearEffect(offhand));
                            return InteractionResultHolder.m_19090_((Object)copy);
                        }
                        if (Objects.equals(effect, offhandEffect) && Objects.equals(amplifier, offhandAmplifier)) {
                            ItemStack copy = PotionFilterCard.addDuration(stack, offhandDuration);
                            player.m_21008_(InteractionHand.OFF_HAND, PotionFilterCard.clearEffect(offhand));
                            return InteractionResultHolder.m_19090_((Object)copy);
                        }
                    }
                }
                if ((active = effect == null ? player.m_21220_().stream().filter(effectInstance -> effectInstance.m_19557_() >= PotionFilterCard.getMinimumDuration()).findFirst() : player.m_21220_().stream().filter(effectInstance -> effectInstance.m_19557_() >= PotionFilterCard.getMinimumDuration()).filter(effectInstance -> Objects.equals(effectInstance.m_19544_(), effect)).filter(effectInstance -> Objects.equals(effectInstance.m_19564_(), amplifier)).findFirst()).isPresent()) {
                    MobEffect activeEffect = active.get().m_19544_();
                    int activeAmplifier = active.get().m_19564_();
                    int activeDuration = active.get().m_19557_();
                    ItemStack copy = effect == null ? PotionFilterCard.withEffect(stack, activeEffect, activeAmplifier, activeDuration) : PotionFilterCard.addDuration(stack, activeDuration);
                    player.m_21195_(activeEffect);
                    return InteractionResultHolder.m_19090_((Object)copy);
                }
            } else {
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("pylons");
        return tag != null && tag.m_128441_("effect");
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        int display;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        MobEffect effect = PotionFilterCard.getEffect(stack);
        int duration = PotionFilterCard.getDuration(stack);
        int amplifier = PotionFilterCard.getAmplifier(stack);
        int n = display = duration < 20 ? 0 : duration / 20;
        if (effect != null) {
            MutableComponent component = effect.m_19482_().m_6881_();
            if (amplifier > 0) {
                component = this.withAmplifier(component, amplifier);
            }
            if (effect.m_19486_()) {
                tooltip.add((Component)component.m_130940_(ChatFormatting.BLUE));
            } else {
                tooltip.add((Component)component.m_130940_(ChatFormatting.RED));
            }
            if (!PotionFilterCard.isAllowed(stack)) {
                tooltip.add((Component)this.translate("effect_denied").m_130940_(ChatFormatting.RED));
            }
            tooltip.add((Component)Component.m_237119_());
            if (duration >= PotionFilterCard.getRequiredDuration()) {
                tooltip.add((Component)this.translate("insert1"));
                tooltip.add((Component)this.translate("insert2"));
                tooltip.add((Component)this.translate("activated").m_130940_(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)this.translate("increase1"));
                tooltip.add((Component)this.translate("increase2"));
                tooltip.add((Component)this.translate("progress", display, PotionFilterCard.getRequiredDuration() / 20).m_130940_(ChatFormatting.RED));
            }
        } else {
            tooltip.add((Component)this.translate("no_effect1"));
            tooltip.add((Component)this.translate("no_effect2"));
            tooltip.add((Component)this.translate("minimum_duration", PotionFilterCard.getMinimumDuration() / 20));
        }
    }

    public static ItemStack withEffect(ItemStack stack, MobEffect effect, int amplifier, int duration) {
        ResourceLocation registryName = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
        if (registryName == null) {
            return stack;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("effect", registryName.toString());
        tag.m_128405_("amplifier", amplifier);
        tag.m_128405_("duration", Math.min(PotionFilterCard.getRequiredDuration(), duration));
        ItemStack copy = stack.m_41777_();
        copy.m_41700_("pylons", (Tag)tag);
        return copy;
    }

    public static ItemStack addDuration(ItemStack stack, int duration) {
        ItemStack copy = stack.m_41777_();
        CompoundTag tag = copy.m_41698_("pylons");
        int current = tag.m_128451_("duration");
        if (current >= PotionFilterCard.getRequiredDuration()) {
            return stack;
        }
        int total = Math.min(PotionFilterCard.getRequiredDuration(), current + duration);
        tag.m_128405_("duration", total);
        return copy;
    }

    public static ItemStack clearEffect(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41749_("pylons");
        return copy;
    }

    @Nullable
    public static MobEffect getEffect(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("pylons");
        if (tag != null && tag.m_128441_("effect")) {
            String effectName = tag.m_128461_("effect");
            return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectName));
        }
        return null;
    }

    public static int getDuration(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("pylons");
        if (tag != null && tag.m_128441_("duration")) {
            return tag.m_128451_("duration");
        }
        return 0;
    }

    public static int getAmplifier(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("pylons");
        if (tag != null && tag.m_128441_("amplifier")) {
            return tag.m_128451_("amplifier");
        }
        return 0;
    }

    public static boolean isAllowed(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("pylons");
        if (tag != null && tag.m_128441_("effect")) {
            String effectName = tag.m_128461_("effect");
            ResourceLocation location = new ResourceLocation(effectName);
            return PotionFilterCard.isAllowedEffect(location) && !PotionFilterCard.isDeniedEffect(location);
        }
        return false;
    }

    protected static boolean isAllowedEffect(ResourceLocation location) {
        List allowed = (List)ConfigManager.SERVER.infusionAllowedEffects.get();
        return allowed.isEmpty() || allowed.contains(location.m_135827_()) || allowed.contains(location.toString());
    }

    protected static boolean isDeniedEffect(ResourceLocation location) {
        List denied = (List)ConfigManager.SERVER.infusionDeniedEffects.get();
        return denied.contains(location.m_135827_()) || denied.contains(location.toString());
    }

    protected MutableComponent translate(String key) {
        return Component.m_237115_((String)TranslationKey.tooltip(key)).m_130940_(ChatFormatting.GRAY);
    }

    protected MutableComponent translate(String key, Object ... values) {
        return Component.m_237110_((String)TranslationKey.tooltip(key), (Object[])values);
    }

    protected MutableComponent withAmplifier(MutableComponent component, int amplifier) {
        return Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.m_237115_((String)("potion.potency." + amplifier))});
    }
}

