/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class BrewberryBushBlock
extends BushBlock
implements BonemealableBlock {
    private static final VoxelShape BUSH_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final BooleanProperty MATURE = BooleanProperty.m_61465_((String)"mature");
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);

    public BrewberryBushBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_280170_().m_278183_().m_278166_(PushReaction.DESTROY).m_60977_().m_60978_(0.2f).m_60910_().m_60918_(SoundType.f_56740_));
        this.m_49959_((BlockState)((BlockState)super.m_49966_().m_61124_((Property)MATURE, (Comparable)Boolean.valueOf(false))).m_61124_(TYPE, (Comparable)((Object)Type.RED)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BUSH_SHAPE;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && entityIn.m_6095_() != EntityType.f_20452_) {
            entityIn.m_7601_(state, new Vec3(0.9, 0.85, 0.9));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MATURE}).m_61104_(new Property[]{TYPE});
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!level.f_46443_ && !((Boolean)state.m_61143_((Property)MATURE)).booleanValue() && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (rand.m_188503_(60) == 0 ? 1 : 0) != 0)) {
            level.m_46597_(pos, this.getGrownState((Level)level, pos, rand));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private ItemStack getBerry(Level level, BlockState state, BlockPos pos) {
        Block soil = level.m_8055_(pos.m_7495_()).m_60734_();
        int count = level.f_46441_.m_188503_(2) + 1;
        if (soil instanceof FarmBlock || soil == Blocks.f_50599_) {
            count += level.f_46441_.m_188503_(3);
        }
        return new ItemStack((ItemLike)((Type)((Object)state.m_61143_(TYPE))).getBerry(), count);
    }

    private BlockState getGrownState(Level level, BlockPos pos, RandomSource rand) {
        Type type = Type.RED;
        if (rand.m_188499_()) {
            Block soil = level.m_8055_(pos.m_7495_()).m_60734_();
            if (soil == Blocks.f_50195_) {
                type = Type.BLACK;
            } else if (soil == SkiesBlocks.turquoise_comet_grass_block || soil == SkiesBlocks.lunar_comet_grass_block) {
                type = Type.PINK;
            }
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)MATURE, (Comparable)Boolean.valueOf(true))).m_61124_(TYPE, (Comparable)((Object)type));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)MATURE)).booleanValue()) {
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, this.getBerry(level, state, pos)));
            level.m_5594_(null, pos, SoundEvents.f_11990_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)MATURE, (Comparable)Boolean.valueOf(false))).m_61124_(TYPE, (Comparable)((Object)Type.RED)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        Block block = state.m_60734_();
        return super.m_6266_(state, level, pos) || block instanceof FarmBlock || block == Blocks.f_50195_;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.m_61143_((Property)MATURE) == false;
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)MATURE) == false;
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        if (rand.m_188499_()) {
            level.m_7731_(pos, this.getGrownState((Level)level, pos, rand), 3);
        }
    }

    public static enum Type implements StringRepresentable
    {
        RED("red", () -> SkiesItems.brewberry),
        PINK("pink", () -> SkiesItems.pink_brewberry),
        BLACK("black", () -> SkiesItems.black_brewberry);

        private final String name;
        private final Supplier<Item> berry;

        private Type(String name, Supplier<Item> berry) {
            this.name = name;
            this.berry = berry;
        }

        public Item getBerry() {
            return this.berry.get();
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

