/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class CrystalizedTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.crystallized_log.m_49966_();
    private static final BlockState LEAF = SkiesBlocks.crystallized_leaves.m_49966_();

    public CrystalizedTreeFeature(Codec<TreeConfiguration> config, boolean natural) {
        super(config, natural);
    }

    @Override
    public boolean place(WorldGenLevel world, RandomSource rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves) {
        int height = rand.m_188503_(3) + 6;
        if (!this.isAreaOk(world, pos, height, 1, 3, 7)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            this.setBlockIfOk(changedLogs, world, pos.m_6630_(y), LOG);
        }
        Direction noBranch = DirectionUtil.randHorizontal(rand);
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            if (dir == noBranch) continue;
            BlockPos branchPos = pos.m_6630_(3 + rand.m_188503_(3));
            int maxBranchLength = rand.m_188503_(2) + 4;
            for (int branchLength = 0; branchLength < maxBranchLength; ++branchLength) {
                branchPos = branchPos.m_7494_();
                if (branchLength < maxBranchLength / 2) {
                    branchPos = branchPos.m_121945_(dir);
                }
                this.setBlockIfOk(changedLogs, world, branchPos, LOG);
                if (branchLength != maxBranchLength - 1) continue;
                this.setBlockIfOk(changedLeaves, world, branchPos.m_7494_(), LEAF);
            }
        }
        int xzSize = 4;
        for (int x = -xzSize; x <= xzSize; ++x) {
            for (int z = -xzSize; z <= xzSize; ++z) {
                for (int y = 5; y < height + 6; ++y) {
                    BlockPos logPos = pos.m_7918_(x, y, z);
                    if (world.m_8055_(logPos).m_60734_() != LOG.m_60734_()) continue;
                    for (Direction dir : Direction.values()) {
                        if (!rand.m_188499_()) continue;
                        BlockPos leafPos = logPos.m_121945_(dir);
                        this.setBlockIfOk(changedLeaves, world, leafPos, LEAF);
                        for (Direction leafDir : Direction.values()) {
                            this.setBlockIfOk(changedLeaves, world, leafPos.m_121945_(leafDir), LEAF);
                            if (!rand.m_188499_()) continue;
                            this.setBlockIfOk(changedLeaves, world, leafPos.m_121945_(leafDir).m_121945_(leafDir), LEAF);
                        }
                    }
                }
            }
        }
        if (this.natural) {
            for (int attempts = 0; attempts < 8; ++attempts) {
                BlockPos flowerPos = pos.m_7918_(rand.m_188503_(4) - rand.m_188503_(4), rand.m_188503_(2) - rand.m_188503_(2), rand.m_188503_(4) - rand.m_188503_(4));
                this.setBlockIfOk(null, world, flowerPos, SkiesBlocks.crystal_flower.m_49966_());
            }
        }
        return true;
    }

    @Override
    public boolean isValidGround(WorldGenLevel world, BlockState groundState, BlockPos pos) {
        return groundState.m_204336_(BlockTags.f_13029_);
    }
}

