/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.google.common.base.Suppliers;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum AllArmorMaterials implements ArmorMaterial
{
    COPPER(Create.asResource("copper").toString(), 7, new int[]{2, 4, 3, 1}, 25, () -> AllSoundEvents.COPPER_ARMOR_EQUIP.getMainEvent(), 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151052_})),
    CARDBOARD(Create.asResource("cardboard").toString(), 4, new int[]{1, 1, 1, 1}, 25, () -> SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{AllItems.CARDBOARD}));

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final int maxDamageFactor;
    private final int[] damageReductionAmountArray;
    private final int enchantability;
    private final Supplier<SoundEvent> soundEvent;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairMaterial;

    private AllArmorMaterials(String name, int maxDamageFactor, int[] damageReductionAmountArray, int enchantability, Supplier<SoundEvent> soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairMaterial) {
        this.name = name;
        this.maxDamageFactor = maxDamageFactor;
        this.damageReductionAmountArray = damageReductionAmountArray;
        this.enchantability = enchantability;
        this.soundEvent = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairMaterial = Suppliers.memoize(repairMaterial::get);
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent.get();
    }

    public Ingredient m_6230_() {
        return this.repairMaterial.get();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public int m_266425_(ArmorItem.Type pType) {
        return MAX_DAMAGE_ARRAY[pType.ordinal()] * this.maxDamageFactor;
    }

    public int m_7366_(ArmorItem.Type pType) {
        return this.damageReductionAmountArray[pType.ordinal()];
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{11, 16, 15, 13};
    }
}

