/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.worldgen;

import com.simibubi.create.infrastructure.worldgen.LayerPattern;
import com.simibubi.create.infrastructure.worldgen.LayeredOreConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class LayeredOreFeature
extends Feature<LayeredOreConfiguration> {
    private static final float MAX_LAYER_DISPLACEMENT = 1.75f;
    private static final float LAYER_NOISE_FREQUENCY = 0.125f;
    private static final float MAX_RADIAL_THRESHOLD_REDUCTION = 0.25f;
    private static final float RADIAL_NOISE_FREQUENCY = 0.125f;

    public LayeredOreFeature() {
        super(LayeredOreConfiguration.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<LayeredOreConfiguration> pContext) {
        float layerSizeTotal;
        float layerSize;
        RandomSource random = pContext.m_225041_();
        BlockPos origin = pContext.m_159777_();
        WorldGenLevel worldGenLevel = pContext.m_159774_();
        LayeredOreConfiguration config = (LayeredOreConfiguration)pContext.m_159778_();
        List<LayerPattern> patternPool = config.layerPatterns;
        if (patternPool.isEmpty()) {
            return false;
        }
        LayerPattern layerPattern = patternPool.get(random.m_188503_(patternPool.size()));
        int placedAmount = 0;
        int size = config.size + 1;
        float radius = (float)config.size * 0.5f;
        int radiusBound = Mth.m_14167_((float)radius) - 1;
        int x0 = origin.m_123341_();
        int y0 = origin.m_123342_();
        int z0 = origin.m_123343_();
        if (origin.m_123342_() >= worldGenLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, origin.m_123341_(), origin.m_123343_())) {
            return false;
        }
        ArrayList<TemporaryLayerEntry> tempLayers = new ArrayList<TemporaryLayerEntry>();
        LayerPattern.Layer current = null;
        for (layerSizeTotal = 0.0f; layerSizeTotal < (float)size; layerSizeTotal += layerSize) {
            LayerPattern.Layer next = layerPattern.rollNext(current, random);
            layerSize = Mth.m_216283_((RandomSource)random, (float)next.minSize, (float)next.maxSize);
            tempLayers.add(new TemporaryLayerEntry(next, layerSize));
            current = next;
        }
        ArrayList<ResolvedLayerEntry> resolvedLayers = new ArrayList<ResolvedLayerEntry>(tempLayers.size());
        float cumulativeLayerSize = -(layerSizeTotal - (float)size) * random.m_188501_();
        for (TemporaryLayerEntry tempLayerEntry : tempLayers) {
            float rampStartValue = resolvedLayers.size() == 0 ? Float.NEGATIVE_INFINITY : cumulativeLayerSize * (2.0f / (float)size) - 1.0f;
            if ((cumulativeLayerSize += tempLayerEntry.size()) < 0.0f) continue;
            float radialThresholdMultiplier = Mth.m_216283_((RandomSource)random, (float)0.5f, (float)1.0f);
            resolvedLayers.add(new ResolvedLayerEntry(tempLayerEntry.layer, radialThresholdMultiplier, rampStartValue));
        }
        float gy = Mth.m_216283_((RandomSource)random, (float)-1.0f, (float)1.0f);
        gy = (float)Math.cbrt(gy);
        float xzRescale = Mth.m_14116_((float)(1.0f - gy * gy));
        float theta = random.m_188501_() * ((float)Math.PI * 2);
        float gx = Mth.m_14089_((float)theta) * xzRescale;
        float gz = Mth.m_14031_((float)theta) * xzRescale;
        SimplexNoise layerDisplacementNoise = new SimplexNoise(random);
        SimplexNoise radiusNoise = new SimplexNoise(random);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        try (BulkSectionAccess bulkSectionAccess = new BulkSectionAccess((LevelAccessor)worldGenLevel);){
            for (int dzBlock = -radiusBound; dzBlock <= radiusBound; ++dzBlock) {
                float dz = (float)dzBlock * (1.0f / radius);
                if (dz * dz > 1.0f) continue;
                for (int dxBlock = -radiusBound; dxBlock <= radiusBound; ++dxBlock) {
                    float dx = (float)dxBlock * (1.0f / radius);
                    if (dz * dz + dx * dx > 1.0f) continue;
                    block9: for (int dyBlock = -radiusBound; dyBlock <= radiusBound; ++dyBlock) {
                        LevelChunkSection levelChunkSection;
                        float thresholdNoiseValue;
                        float dy = (float)dyBlock * (1.0f / radius);
                        float distanceSquared = dz * dz + dx * dx + dy * dy;
                        if (distanceSquared > 1.0f || worldGenLevel.m_151562_(y0 + dyBlock)) continue;
                        int currentX = x0 + dxBlock;
                        int currentY = y0 + dyBlock;
                        int currentZ = z0 + dzBlock;
                        float rampValue = gx * dx + gy * dy + gz * dz;
                        int layerIndex = Collections.binarySearch(resolvedLayers, new ResolvedLayerEntry(null, 0.0f, rampValue = (float)((double)rampValue + layerDisplacementNoise.m_75467_((double)((float)currentX * 0.125f), (double)((float)currentY * 0.125f), (double)((float)currentZ * 0.125f)) * (double)(1.75f / (float)size))));
                        if (layerIndex < 0) {
                            layerIndex = -2 - layerIndex;
                        }
                        ResolvedLayerEntry layerEntry = (ResolvedLayerEntry)resolvedLayers.get(layerIndex);
                        if (distanceSquared > layerEntry.radialThresholdMultiplier || distanceSquared > layerEntry.radialThresholdMultiplier * (thresholdNoiseValue = Mth.m_184637_((float)((float)radiusNoise.m_75467_((double)((float)currentX * 0.125f), (double)((float)currentY * 0.125f), (double)((float)currentZ * 0.125f))), (float)-1.0f, (float)1.0f, (float)0.75f, (float)1.0f))) continue;
                        LayerPattern.Layer layer = layerEntry.layer;
                        List<OreConfiguration.TargetBlockState> targetBlockStates = layer.rollBlock(random);
                        mutablePos.m_122178_(currentX, currentY, currentZ);
                        if (!worldGenLevel.m_180807_((BlockPos)mutablePos) || (levelChunkSection = bulkSectionAccess.m_156104_((BlockPos)mutablePos)) == null) continue;
                        int localX = SectionPos.m_123207_((int)currentX);
                        int localY = SectionPos.m_123207_((int)currentY);
                        int localZ = SectionPos.m_123207_((int)currentZ);
                        BlockState blockState = levelChunkSection.m_62982_(localX, localY, localZ);
                        for (OreConfiguration.TargetBlockState targetBlockState : targetBlockStates) {
                            if (!this.canPlaceOre(blockState, arg_0 -> ((BulkSectionAccess)bulkSectionAccess).m_156110_(arg_0), random, config, targetBlockState, mutablePos) || targetBlockState.f_161033_.m_60795_()) continue;
                            levelChunkSection.m_62991_(localX, localY, localZ, targetBlockState.f_161033_, false);
                            ++placedAmount;
                            continue block9;
                        }
                    }
                }
            }
        }
        return placedAmount > 0;
    }

    public boolean canPlaceOre(BlockState pState, Function<BlockPos, BlockState> pAdjacentStateAccessor, RandomSource pRandom, LayeredOreConfiguration pConfig, OreConfiguration.TargetBlockState pTargetState, BlockPos.MutableBlockPos pMatablePos) {
        if (!pTargetState.f_161032_.m_213865_(pState, pRandom)) {
            return false;
        }
        if (this.shouldSkipAirCheck(pRandom, pConfig.discardChanceOnAirExposure)) {
            return true;
        }
        return !LayeredOreFeature.m_159750_(pAdjacentStateAccessor, (BlockPos)pMatablePos);
    }

    protected boolean shouldSkipAirCheck(RandomSource pRandom, float pChance) {
        return pChance <= 0.0f ? true : (pChance >= 1.0f ? false : pRandom.m_188501_() >= pChance);
    }

    private record TemporaryLayerEntry(LayerPattern.Layer layer, float size) {
    }

    private record ResolvedLayerEntry(LayerPattern.Layer layer, float radialThresholdMultiplier, float rampStartValue) implements Comparable<ResolvedLayerEntry>
    {
        @Override
        public int compareTo(ResolvedLayerEntry b) {
            return Float.compare(this.rampStartValue, b.rampStartValue);
        }
    }
}

