/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.epherolib.networking;

import com.epherical.epherolib.networking.AbstractNetworking;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgeNetworking
extends AbstractNetworking<NetworkEvent.Context, NetworkEvent.Context> {
    private static int id = 0;
    public final SimpleChannel INSTANCE;
    private final ResourceLocation modChannel;
    private final String version;

    public ForgeNetworking(ResourceLocation location, String version, Predicate<String> clientAcceptedVersion, Predicate<String> serverAcceptedVersion) {
        this.modChannel = location;
        this.version = version;
        this.INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)location, () -> version, clientAcceptedVersion, serverAcceptedVersion);
    }

    @Override
    public <MSG> void registerServerToClient(int id, Class<MSG> type, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, AbstractNetworking.Context<NetworkEvent.Context>> consumer) {
        this.INSTANCE.registerMessage(id, type, encoder, decoder, (msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            AbstractNetworking.Side side = context.getDirection().getReceptionSide().isServer() ? AbstractNetworking.Side.SERVER : AbstractNetworking.Side.CLIENT;
            consumer.accept(msg, new AbstractNetworking.Context(side, context.getSender()));
        });
    }

    @Override
    public <T> void registerClientToServer(int id, Class<T> type, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, AbstractNetworking.Context<NetworkEvent.Context>> consumer) {
        this.INSTANCE.registerMessage(id, type, encoder, decoder, (msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            AbstractNetworking.Side side = context.getDirection().getReceptionSide().isServer() ? AbstractNetworking.Side.SERVER : AbstractNetworking.Side.CLIENT;
            consumer.accept(msg, new AbstractNetworking.Context(side, context.getSender()));
        });
    }

    @Override
    public <T> void sendToClient(T type, ServerPlayer serverPlayer) {
        this.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), type);
    }

    @Override
    public <T> void sendToServer(T type) {
        this.INSTANCE.sendToServer(type);
    }
}

