/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.block_entity;

import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.handlers.DataHandler;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block.DataHandlerBlock;
import com.legacy.structure_gel.core.block_entity.SGBlockEntity;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DataHandlerBlockEntity
extends SGBlockEntity {
    public static final String HANDLERS_KEY = "handlers";
    public static final String USE_GRAVITY_KEY = "use_gravity";
    public static final String MARK_POST_PROCESSING_KEY = "mark_post_processing";
    public static final String OFFSET_KEY = "offset";
    public static final String CUSTOM_NAME_KEY = "CustomName";
    private WeightedRandomList<RawHandler> handlers = WeightedRandomList.m_146332_();
    private Component name = null;
    private boolean useGravity = false;
    private boolean markPostProcessing = false;
    private Vec3 offset = Vec3.f_82478_;

    public DataHandlerBlockEntity(BlockPos pos, BlockState state) {
        super(SGRegistry.BlockEntities.DATA_HANDLER.get(), pos, state);
    }

    public WeightedRandomList<RawHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(WeightedRandomList<RawHandler> handlers) {
        this.handlers = handlers;
        this.m_6596_();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public void setCustomName(@Nullable Component name) {
        this.name = name;
    }

    public boolean useGravity() {
        return this.useGravity;
    }

    public void setUseGravity(boolean useGravity) {
        this.useGravity = useGravity;
    }

    public boolean shouldMarkPostProcessing() {
        return this.markPostProcessing;
    }

    public void setMarkPostProcessing(boolean markPostProcessing) {
        this.markPostProcessing = markPostProcessing;
    }

    public Vec3 getOffset() {
        return this.offset;
    }

    public void setOffset(Vec3 offset) {
        this.offset = offset;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag listTag = new ListTag();
        for (RawHandler handler : this.handlers.m_146338_()) {
            CompoundTag handlerTag = new CompoundTag();
            handler.trySave(handlerTag);
            listTag.add((Object)handlerTag);
        }
        tag.m_128365_(HANDLERS_KEY, (Tag)listTag);
        if (this.name != null) {
            tag.m_128359_(CUSTOM_NAME_KEY, Component.Serializer.m_130703_((Component)this.name));
        }
        tag.m_128379_(USE_GRAVITY_KEY, this.useGravity);
        tag.m_128379_(MARK_POST_PROCESSING_KEY, this.markPostProcessing);
        CompoundTag offsetTag = new CompoundTag();
        offsetTag.m_128359_("facing", ((Direction)this.m_58900_().m_61143_((Property)DataHandlerBlock.FACING)).m_7912_());
        offsetTag.m_128347_("x", this.offset.f_82479_);
        offsetTag.m_128347_("y", this.offset.f_82480_);
        offsetTag.m_128347_("z", this.offset.f_82481_);
        tag.m_128365_(OFFSET_KEY, (Tag)offsetTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.handlers = DataHandlerBlockEntity.loadAllHandlers(tag);
        this.name = tag.m_128425_(CUSTOM_NAME_KEY, 8) ? Component.Serializer.m_130701_((String)tag.m_128461_(CUSTOM_NAME_KEY)) : null;
        this.useGravity = tag.m_128471_(USE_GRAVITY_KEY);
        this.markPostProcessing = tag.m_128471_(MARK_POST_PROCESSING_KEY);
        this.offset = DataHandlerBlockEntity.loadOffset(tag);
    }

    public static WeightedRandomList<RawHandler> loadAllHandlers(CompoundTag tag) {
        ArrayList<RawHandler> handlers = new ArrayList<RawHandler>();
        Optional<RawHandler> legacyHandler = RawHandler.tryLoad(tag);
        if (legacyHandler.isPresent()) {
            handlers.add(legacyHandler.get());
        }
        handlers.addAll(DataHandlerBlockEntity.readHandlerList(tag));
        return WeightedRandomList.m_146328_(handlers);
    }

    public static boolean loadUseGravity(CompoundTag tag) {
        return tag.m_128471_(USE_GRAVITY_KEY);
    }

    public static boolean loadMarkPostProcessing(CompoundTag tag) {
        return tag.m_128471_(MARK_POST_PROCESSING_KEY);
    }

    public static Vec3 loadOffset(CompoundTag tag) {
        CompoundTag offsetTag = tag.m_128469_(OFFSET_KEY);
        return new Vec3(offsetTag.m_128459_("x"), offsetTag.m_128459_("y"), offsetTag.m_128459_("z"));
    }

    private static List<RawHandler> readHandlerList(CompoundTag tag) {
        ArrayList<RawHandler> handlerList = new ArrayList<RawHandler>();
        if (tag.m_128425_(HANDLERS_KEY, 9)) {
            ListTag listTag = tag.m_128437_(HANDLERS_KEY, 10);
            for (Tag t : listTag) {
                CompoundTag handlerTag;
                Optional<RawHandler> handler;
                if (!(t instanceof CompoundTag) || !(handler = RawHandler.tryLoad(handlerTag = (CompoundTag)t)).isPresent()) continue;
                handlerList.add(handler.get());
            }
        }
        return handlerList;
    }

    public AABB getRenderBoundingBox() {
        if (Vec3.f_82478_.equals((Object)this.offset)) {
            return super.getRenderBoundingBox();
        }
        double size = Math.max(Math.max(Math.abs(this.offset.m_7096_()), Math.abs(this.offset.m_7098_())), Math.abs(this.offset.m_7094_())) + 3.0;
        return AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)this.f_58858_), (double)size, (double)size, (double)size);
    }

    public record RawHandler(Weight weight, ResourceLocation typeName, LinkedHashMap<String, String> dataEntries) implements WeightedEntry
    {
        public static final RawHandler EMPTY = new RawHandler(Weight.m_146282_((int)1), new ResourceLocation(""), new LinkedHashMap<String, String>());
        public static final String WEIGHT_KEY = "weight";
        public static final String TYPE_KEY = "type";
        public static final String ENTRIES_KEY = "entries";

        public static Optional<RawHandler> tryLoad(CompoundTag tag) {
            ResourceLocation type = RawHandler.readType(tag);
            if (type == null) {
                return Optional.empty();
            }
            int weight = tag.m_128425_(WEIGHT_KEY, 3) ? tag.m_128451_(WEIGHT_KEY) : 1;
            LinkedHashMap<String, String> data = RawHandler.readDataEntries(tag);
            return Optional.of(new RawHandler(Weight.m_146282_((int)weight), type, data));
        }

        @Nullable
        private static ResourceLocation readType(CompoundTag tag) {
            String str;
            if (tag.m_128425_(TYPE_KEY, 8) && ResourceLocation.m_135830_((String)(str = tag.m_128461_(TYPE_KEY)))) {
                return new ResourceLocation(str);
            }
            return null;
        }

        private static LinkedHashMap<String, String> readDataEntries(CompoundTag tag) {
            LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
            CompoundTag dataTag = tag.m_128469_(ENTRIES_KEY);
            for (String key : dataTag.m_128431_()) {
                entries.put(key, dataTag.m_128461_(key));
            }
            return entries;
        }

        public void trySave(CompoundTag tag) {
            if (this.typeName.m_135815_().isEmpty()) {
                return;
            }
            if (this.weight.m_146281_() != 1) {
                tag.m_128405_(WEIGHT_KEY, this.weight.m_146281_());
            }
            if (this.typeName != null) {
                tag.m_128359_(TYPE_KEY, this.typeName.toString());
            }
            CompoundTag dataTag = new CompoundTag();
            for (Map.Entry<String, String> entry : this.dataEntries.entrySet()) {
                String value = entry.getValue();
                if (value.isEmpty()) continue;
                dataTag.m_128359_(entry.getKey(), entry.getValue());
            }
            tag.m_128365_(ENTRIES_KEY, (Tag)dataTag);
        }

        @Nullable
        public DataHandler<?> tryBake(BlockPos pos) {
            try {
                if (this.typeName != null) {
                    DataHandlerType<?> type = DataHandlerType.REGISTRY.get(this.typeName);
                    if (type != null) {
                        return type.create(type.getDataParser().parse(this.dataEntries));
                    }
                    StructureGelMod.LOGGER.error("{} is not a registered DataHandlerType", this.typeName);
                } else {
                    StructureGelMod.LOGGER.error("\type\" was null for the DataHandlerBlockEntity at {}", pos);
                }
            }
            catch (Exception e) {
                StructureGelMod.LOGGER.error("Couldn't deserialize DataHandler from {}", pos);
                StructureGelMod.LOGGER.error(e, new Object[0]);
            }
            return null;
        }

        public Weight m_142631_() {
            return this.weight;
        }
    }
}

