/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Orientation;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractGaugeBar;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.EnumIndexedArray;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public class MultiValueGaugeBar<Index extends Enum<Index>>
extends AbstractGaugeBar {
    private final EnumIndexedArray<Index, Double> _values;
    private final EnumIndexedArray<Index, ISprite> _sprites;
    private final EnumIndexedArray<Index, Colour> _tints;

    @SafeVarargs
    public MultiValueGaugeBar(ModContainerScreen<? extends ModContainer> gui, String name, double maxValue, Index firstValidIndex, Index secondValidIndex, Index ... otherValidIndices) {
        super(gui, name, maxValue);
        this._values = new EnumIndexedArray(Double[]::new, firstValidIndex, secondValidIndex, otherValidIndices);
        this._sprites = new EnumIndexedArray(ISprite[]::new, firstValidIndex, secondValidIndex, otherValidIndices);
        this._tints = new EnumIndexedArray(Colour[]::new, firstValidIndex, secondValidIndex, otherValidIndices);
        this._values.setAll(0.0);
    }

    public double getValue(Index index) {
        return this._values.getElement(index).orElse(0.0);
    }

    public void setValue(Index index, double value) {
        this._values.setElement(index, Mth.m_14008_((double)value, (double)0.0, (double)this.getMaxValueFor(index)));
    }

    public void bindValue(Index index, IBindableData<Integer> bindableValue) {
        bindableValue.bind(value -> this.setValue(index, value.intValue()));
    }

    public void setBarSprite(Index index, ISprite sprite) {
        this._sprites.setElement(index, (ISprite)Preconditions.checkNotNull((Object)sprite));
    }

    public void setBarSprite(Index index, Supplier<ISprite> sprite) {
        this.setBarSprite(index, sprite.get());
    }

    public void setBarSpriteTint(Index index, Colour tint) {
        this._tints.setElement(index, tint);
    }

    public double getFillRatio() {
        return this._values.stream().mapToDouble(Double::doubleValue).sum() / this.getMaxValue();
    }

    public double getFillRatio(Index index) {
        return this.getValue(index) / this.getMaxValue();
    }

    @Override
    public void onPaint(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        super.onPaint(gfx, partialTicks, mouseX, mouseY);
        Rectangle area = this.getPaddingRect();
        int skip = 0;
        for (Enum index : this._values.getValidIndices()) {
            skip += this.paintValueRect(gfx, index, area, skip);
        }
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" indices:").append(this._values.getValidIndices());
    }

    protected double getMaxValueFor(Index index) {
        return this.getMaxValue();
    }

    protected Optional<ISprite> getSprite(Index index) {
        return this._sprites.getElement(index);
    }

    protected Optional<Colour> getTint(Index index) {
        return this._tints.getElement(index);
    }

    protected Colour getTintOrDefault(Index index) {
        return this._tints.getElement(index, Colour.WHITE);
    }

    protected int paintValueRect(GuiGraphics gfx, Index index, Rectangle rect, int skip) {
        double progress = this.getFillRatio(index);
        if (progress < 0.01) {
            return 0;
        }
        return this.getSprite(index).map(sprite -> this.paintValueRect(gfx, (ISprite)sprite, this.getTintOrDefault(index), rect, skip, progress)).orElse(0);
    }

    private int paintValueRect(GuiGraphics gfx, ISprite sprite, Colour tint, Rectangle rect, int skip, double progress) {
        int areaHeight;
        int areaWidth;
        int y;
        int x;
        Orientation orientation = this.getOrientation();
        Point origin = this.controlToScreen(rect.Origin.X, rect.Origin.Y);
        int filled = switch (orientation) {
            default -> {
                x = origin.X;
                y = origin.Y - skip;
                areaWidth = rect.Width;
                areaHeight = rect.Height;
                yield (int)((double)areaHeight * progress);
            }
            case Orientation.TopToBottom -> {
                x = origin.X;
                y = origin.Y + skip;
                areaWidth = rect.Width;
                areaHeight = rect.Height;
                yield (int)((double)areaHeight * progress);
            }
            case Orientation.LeftToRight -> {
                x = origin.X + skip;
                y = origin.Y;
                areaWidth = rect.Width;
                areaHeight = rect.Height;
                yield (int)((double)areaWidth * progress);
            }
            case Orientation.RightToLeft -> {
                x = origin.X - skip;
                y = origin.Y;
                areaWidth = rect.Width;
                areaHeight = rect.Height;
                yield (int)((double)areaWidth * progress);
            }
        };
        ModRenderHelper.paintOrientedProgressBarSprite(gfx, orientation, sprite, x, y, (int)this.getZLevel(), areaWidth, areaHeight, progress, tint);
        return filled;
    }
}

