/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class BlockPosData
extends AbstractData<BlockPos>
implements IContainerData {
    private int _lastHash;

    public static BlockPosData immutable(ModContainer container, boolean isClientSide, BlockPos value) {
        return BlockPosData.of(container, isClientSide, (NonNullSupplier<Supplier<BlockPos>>)((NonNullSupplier)() -> () -> value));
    }

    public static BlockPosData sampled(int frequency, ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<BlockPos>> serverSideGetter) {
        return BlockPosData.of(container, isClientSide, (NonNullSupplier<Supplier<BlockPos>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static BlockPosData of(ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<BlockPos>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        BlockPosData data = isClientSide ? new BlockPosData() : new BlockPosData(serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        BlockPos current = (BlockPos)this._getter.get();
        int currentHash = current.hashCode();
        if (this._lastHash != currentHash) {
            this._lastHash = currentHash;
            return buffer -> buffer.m_130064_(current);
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        this.notify(dataSource.m_130135_());
    }

    @Override
    @Nullable
    public BlockPos defaultValue() {
        return BlockPos.f_121853_;
    }

    private BlockPosData() {
    }

    private BlockPosData(NonNullSupplier<Supplier<BlockPos>> serverSideGetter) {
        super(serverSideGetter);
        this._lastHash = 0;
    }
}

