/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.network;

import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.network.AbstractModMessage;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public abstract class AbstractModTileMessage
extends AbstractModMessage {
    private final BlockPos _tilePosition;
    private final ResourceKey<Level> _dimension;

    protected AbstractModTileMessage(FriendlyByteBuf buffer) {
        this._dimension = buffer.readBoolean() ? ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buffer.m_130136_(4096))) : null;
        this._tilePosition = buffer.m_130135_();
    }

    public BlockPos getTileEntityPosition() {
        return this._tilePosition;
    }

    public Optional<ResourceKey<Level>> getDimension() {
        return Optional.ofNullable(this._dimension);
    }

    protected abstract void processTileEntityMessage(LogicalSide var1, BlockEntity var2);

    @Override
    public void encodeTo(FriendlyByteBuf buffer) {
        if (null != this._dimension) {
            buffer.writeBoolean(true);
            buffer.m_130085_(this._dimension.m_135782_());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130064_(this._tilePosition);
    }

    @Override
    public void processMessage(NetworkEvent.Context messageContext) {
        BlockPos position = this.getTileEntityPosition();
        CodeHelper.optionalIfPresentOrElse(this.getWorld(messageContext), w -> CodeHelper.optionalIfPresentOrElse(WorldHelper.getTile(w, position), tile -> this.processTileEntityMessage(messageContext.getDirection().getOriginationSide(), (BlockEntity)tile), () -> Log.LOGGER.error(Log.NETWORK, "No tile entity found at {}, {}, {} while processing a ModTileEntityMessage: skipping message", (Object)position.m_123341_(), (Object)position.m_123342_(), (Object)position.m_123343_())), () -> Log.LOGGER.error(Log.NETWORK, "Invalid world instance found while processing a ModTileEntityMessage: skipping message"));
    }

    protected AbstractModTileMessage(BlockPos tileEntityPosition) {
        this._tilePosition = tileEntityPosition;
        this._dimension = null;
    }

    protected AbstractModTileMessage(BlockPos tileEntityPosition, ResourceKey<Level> dimension) {
        this._tilePosition = tileEntityPosition;
        this._dimension = dimension;
    }

    private Optional<Level> getWorld(NetworkEvent.Context messageContext) {
        switch (messageContext.getDirection()) {
            case PLAY_TO_CLIENT: {
                return WorldHelper.getClientWorld();
            }
            case PLAY_TO_SERVER: {
                ServerPlayer player = messageContext.getSender();
                if (null == player) break;
                if (null != this._dimension) {
                    return WorldHelper.getServerWorld(this._dimension).map(sw -> sw);
                }
                return Optional.of(player.m_20193_());
            }
        }
        return Optional.empty();
    }
}

