/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils.forge;

import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.forge.SoftFluidStackImpl;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Contract;

public class FluidsUtilImpl {
    public static boolean extractFluidFromTank(BlockEntity tileBack, Direction dir, int amount) {
        IFluidHandler handlerBack = (IFluidHandler)tileBack.getCapability(ForgeCapabilities.FLUID_HANDLER, dir).orElse(null);
        if (handlerBack != null) {
            if (handlerBack.drain(250 * amount, IFluidHandler.FluidAction.SIMULATE).getAmount() != 250 * amount) {
                return false;
            }
            handlerBack.drain(250 * amount, IFluidHandler.FluidAction.EXECUTE);
            tileBack.m_6596_();
            return true;
        }
        return false;
    }

    public static Integer fillFluidTank(BlockEntity tileBelow, FluidOffer offer) {
        SoftFluidStackImpl impl;
        FluidStack stack;
        SoftFluidStack softFluidStack;
        IFluidHandler handlerDown = (IFluidHandler)tileBelow.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).orElse(null);
        if (handlerDown != null && (softFluidStack = offer.fluid()) instanceof SoftFluidStackImpl && !(stack = (impl = (SoftFluidStackImpl)softFluidStack).toForgeFluid()).isEmpty()) {
            stack.setAmount(250 * offer.minAmount());
            if (stack.isEmpty()) {
                return null;
            }
            int filled = handlerDown.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            tileBelow.m_6596_();
            return Mth.m_14167_((float)((float)filled / 250.0f));
        }
        return null;
    }

    public static boolean hasFluidHandler(Level level, BlockPos pos, Direction dir) {
        return FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)dir).isPresent();
    }

    @Contract
    public static SoftFluidStack getFluidInTank(Level level, BlockPos pos, Direction dir, BlockEntity source) {
        FluidStack fluidInTank;
        LazyOptional opt = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)dir);
        if (opt.isPresent() && !(fluidInTank = ((IFluidHandler)opt.resolve().get()).drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && !Utils.getID((Block)source.m_58900_().m_60734_()).m_135815_().equals("fluid_interface")) {
            return SoftFluidStackImpl.fromForgeFluid((FluidStack)fluidInTank);
        }
        return SoftFluidStack.empty();
    }
}

