/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.renderer.LaserIOItemRenderer;
import com.direwolf20.laserio.client.renderer.LaserIOItemRendererFluid;
import com.direwolf20.laserio.client.screens.LaserGuiGraphics;
import com.direwolf20.laserio.client.screens.widgets.IconButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.FilterTagContainer;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketGhostSlot;
import com.direwolf20.laserio.common.network.packets.PacketUpdateFilterTag;
import com.direwolf20.laserio.util.MagicHelpers;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FilterTagScreen
extends AbstractContainerScreen<FilterTagContainer> {
    private final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/filtertag.png");
    protected final FilterTagContainer container;
    private ItemStack filter;
    private boolean isAllowList;
    private EditBox tagField;
    private int page = 0;
    private int maxPages = 0;
    private int overSlot = -1;
    private int selectedSlot = -1;
    List<String> displayTags;
    List<String> tags = new ArrayList<String>();
    List<String> stackInSlotTags = new ArrayList<String>();
    int cycleRenders = 0;
    LaserIOItemRenderer tagItemRenderer;
    LaserIOItemRendererFluid tagFluidRenderer;

    public FilterTagScreen(FilterTagContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.filter = container.filterItem;
        this.f_97726_ = 200;
        this.f_97727_ = 254;
        this.tags = FilterTag.getTags(this.filter);
        Minecraft minecraft = Minecraft.m_91087_();
        BlockEntityWithoutLevelRenderer blockentitywithoutlevelrenderer = new BlockEntityWithoutLevelRenderer(minecraft.m_167982_(), minecraft.m_167973_());
        this.tagItemRenderer = new LaserIOItemRenderer(Minecraft.m_91087_(), minecraft.m_91097_(), minecraft.m_91304_(), minecraft.getItemColors(), blockentitywithoutlevelrenderer);
        this.tagFluidRenderer = new LaserIOItemRendererFluid(minecraft, minecraft.m_91097_(), minecraft.m_91304_(), minecraft.getItemColors(), blockentitywithoutlevelrenderer, this);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (MiscTools.inBounds(this.getGuiLeft() + 5, this.getGuiTop() + 10, 16, 16, mouseX, mouseY)) {
            if (this.isAllowList) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.allowlist"), mouseX, mouseY);
            } else {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.denylist"), mouseX, mouseY);
            }
        }
        ++this.cycleRenders;
        int availableItemsstartX = this.getGuiLeft() + 7;
        int availableItemstartY = this.getGuiTop() + 47;
        int color = -2007278757;
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        guiGraphics.m_280024_(availableItemsstartX - 2, availableItemstartY - 4, availableItemsstartX + 162, availableItemstartY + 110, color, color);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrixStack.m_85849_();
        this.displayTags = new ArrayList<String>();
        this.populateStackInSlotTags();
        int tagsPerPage = 11;
        this.stackInSlotTags.sort(Comparator.naturalOrder());
        this.tags.sort(Comparator.naturalOrder());
        ArrayList<String> tempTags = new ArrayList<String>();
        tempTags.addAll(0, this.tags);
        tempTags.addAll(0, this.stackInSlotTags);
        this.maxPages = Math.max((int)Math.ceil((double)tempTags.size() / (double)tagsPerPage) - 1, 0);
        if (this.page > this.maxPages) {
            this.page = this.maxPages;
        }
        String pagesLabel = MagicHelpers.withSuffix(this.page + 1) + " / " + MagicHelpers.withSuffix(this.maxPages + 1);
        guiGraphics.m_280056_(this.f_96547_, pagesLabel, (availableItemsstartX - 2) / 2 + (availableItemsstartX + 162) / 2 - this.f_96547_.m_92895_(pagesLabel) / 2, this.getGuiTop() + 160, Color.DARK_GRAY.getRGB(), false);
        int itemStackMin = this.page * tagsPerPage;
        int itemStackMax = Math.min(this.page * tagsPerPage + tagsPerPage, tempTags.size());
        this.displayTags = tempTags.subList(itemStackMin, itemStackMax);
        int tagStartY = availableItemstartY;
        int slot = 0;
        this.overSlot = -1;
        LaserGuiGraphics laserGuiGraphics = new LaserGuiGraphics(this.f_96541_, guiGraphics.m_280091_());
        for (String tag : this.displayTags) {
            List tagItems = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation(tag))).stream().toList();
            ItemStack drawStack = ItemStack.f_41583_;
            if (tagItems.size() > 0) {
                drawStack = new ItemStack((ItemLike)tagItems.get(this.cycleRenders / 120 % tagItems.size()));
                matrixStack.m_85836_();
                if (!drawStack.m_41619_()) {
                    laserGuiGraphics.renderItemScale(8.0f, drawStack, availableItemsstartX - 4, tagStartY - 5);
                }
                matrixStack.m_85849_();
            }
            List tagFluids = ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)new ResourceLocation(tag))).stream().toList();
            FluidStack drawFluidStack = FluidStack.EMPTY;
            ItemStack bucketStack = ItemStack.f_41583_;
            if (tagFluids.size() > 0) {
                drawFluidStack = new FluidStack((Fluid)tagFluids.get(this.cycleRenders / 120 % tagFluids.size()), 1000);
                matrixStack.m_85836_();
                if (!drawFluidStack.isEmpty() && !(bucketStack = new ItemStack((ItemLike)drawFluidStack.getFluid().m_6859_(), 1)).m_41619_()) {
                    laserGuiGraphics.renderItemScale(8.0f, bucketStack, availableItemsstartX - 4, tagStartY - 5);
                }
                matrixStack.m_85849_();
            }
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.75f, 0.75f, 0.75f);
            int fontColor = this.stackInSlotTags.contains(tag) ? Color.BLUE.getRGB() : Color.DARK_GRAY.getRGB();
            guiGraphics.drawString(this.f_96547_, tag, (float)availableItemsstartX / 0.75f + 16.0f, (float)tagStartY / 0.75f, fontColor, false);
            matrixStack.m_85849_();
            if (MiscTools.inBounds(availableItemsstartX, tagStartY - 2, 160, 8, mouseX, mouseY)) {
                this.overSlot = slot;
                color = -2130706433;
                matrixStack.m_85836_();
                RenderSystem.disableDepthTest();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                guiGraphics.m_280024_(availableItemsstartX - 1, tagStartY - 2, availableItemsstartX + 160, tagStartY + 8, color, color);
                if (MiscTools.inBounds(availableItemsstartX, tagStartY - 2, 8, 8, mouseX, mouseY)) {
                    if (!drawStack.m_41619_()) {
                        guiGraphics.m_280153_(this.f_96547_, drawStack, mouseX, mouseY);
                    }
                    if (!bucketStack.m_41619_()) {
                        guiGraphics.m_280153_(this.f_96547_, bucketStack, mouseX, mouseY);
                    }
                }
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                matrixStack.m_85849_();
            }
            if (slot == this.selectedSlot) {
                color = -65536;
                matrixStack.m_85836_();
                RenderSystem.disableDepthTest();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int x1 = availableItemsstartX + 160;
                int y1 = tagStartY + 10;
                guiGraphics.m_280656_(availableItemsstartX - 2, x1 - 0, tagStartY - 2, color);
                guiGraphics.m_280656_(availableItemsstartX - 2, x1 - 0, y1 - 3, color);
                guiGraphics.m_280315_(availableItemsstartX - 2, tagStartY - 2, y1 - 2, color);
                guiGraphics.m_280315_(x1 - 0, tagStartY - 2, y1 - 2, color);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                matrixStack.m_85849_();
            }
            tagStartY += 10;
            ++slot;
        }
    }

    protected void populateStackInSlotTags() {
        this.stackInSlotTags = new ArrayList<String>();
        ItemStack stackInSlot = this.container.handler.getStackInSlot(0);
        if (!stackInSlot.m_41619_()) {
            stackInSlot.m_41720_().m_204114_().m_203616_().forEach(t -> {
                String tag = t.f_203868_().toString().toLowerCase(Locale.ROOT);
                if (!this.stackInSlotTags.contains(tag) && !this.tags.contains(tag)) {
                    this.stackInSlotTags.add(tag);
                }
            });
            Optional fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)stackInSlot).resolve();
            if (fluidHandlerLazyOptional.isPresent()) {
                IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.get();
                for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                    FluidStack fluidStack = fluidHandler.getFluidInTank(tank);
                    fluidStack.getFluid().m_205069_().m_203616_().forEach(t -> {
                        String tag = t.f_203868_().toString().toLowerCase(Locale.ROOT);
                        if (!this.stackInSlotTags.contains(tag) && !this.tags.contains(tag)) {
                            this.stackInSlotTags.add(tag);
                        }
                    });
                }
            }
        }
    }

    public void m_7856_() {
        super.m_7856_();
        ArrayList<Object> leftWidgets = new ArrayList<Object>();
        this.isAllowList = FilterTag.getAllowList(this.filter);
        ResourceLocation[] allowListTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/allowlistfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/allowlisttrue.png")};
        leftWidgets.add((Object)new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, allowListTextures, this.isAllowList ? 1 : 0, button -> {
            this.isAllowList = !this.isAllowList;
            ((ToggleButton)button).setTexturePosition(this.isAllowList ? 1 : 0);
        }));
        ResourceLocation add = new ResourceLocation("laserio", "textures/gui/buttons/add.png");
        IconButton addButton = new IconButton(this.getGuiLeft() + 155, this.getGuiTop() + 5, 16, 16, add, button -> {
            if (!this.tagField.m_94155_().isEmpty()) {
                String tag = this.tagField.m_94155_().toLowerCase(Locale.ROOT);
                if (!this.tags.contains(tag = tag.replaceAll("[^a-z0-9/:._-]", ""))) {
                    this.tags.add(tag);
                }
                this.tagField.m_94144_("");
            } else {
                ItemStack stack = this.container.handler.getStackInSlot(0);
                if (!stack.m_41619_()) {
                    String tag;
                    if (FilterTagScreen.m_96638_()) {
                        stack.m_41720_().m_204114_().m_203616_().forEach(t -> {
                            String tag = t.f_203868_().toString().toLowerCase(Locale.ROOT);
                            if (!this.tags.contains(tag)) {
                                this.tags.add(tag);
                            }
                        });
                        this.container.handler.setStackInSlot(0, ItemStack.f_41583_);
                    } else if (this.selectedSlot != -1 && !this.tags.contains(tag = this.displayTags.get(this.selectedSlot))) {
                        this.tags.add(tag);
                        this.selectedSlot = -1;
                    }
                }
            }
        });
        leftWidgets.add((Object)addButton);
        ResourceLocation remove = new ResourceLocation("laserio", "textures/gui/buttons/remove.png");
        IconButton removeButton = new IconButton(this.getGuiLeft() + 135, this.getGuiTop() + 5, 16, 16, remove, button -> {
            if (this.selectedSlot != -1) {
                this.tags.remove(this.displayTags.get(this.selectedSlot));
                this.selectedSlot = -1;
            }
        });
        leftWidgets.add((Object)removeButton);
        ResourceLocation clear = new ResourceLocation("laserio", "textures/gui/buttons/clear.png");
        IconButton clearButton = new IconButton(this.getGuiLeft() + 115, this.getGuiTop() + 5, 16, 16, clear, button -> this.tags.clear());
        leftWidgets.add((Object)clearButton);
        ResourceLocation pageup = new ResourceLocation("laserio", "textures/gui/buttons/pageup.png");
        IconButton pageUp = new IconButton(this.getGuiLeft() + 100, this.getGuiTop() + 157, 12, 12, pageup, button -> {
            if (this.page < this.maxPages) {
                ++this.page;
            }
        });
        leftWidgets.add((Object)pageUp);
        ResourceLocation pagedown = new ResourceLocation("laserio", "textures/gui/buttons/pagedown.png");
        IconButton pageDown = new IconButton(this.getGuiLeft() + 58, this.getGuiTop() + 157, 12, 12, pagedown, button -> {
            if (this.page > 0) {
                --this.page;
            }
        });
        leftWidgets.add((Object)pageDown);
        this.tagField = new EditBox(this.f_96547_, this.getGuiLeft() + 7, this.getGuiTop() + 25, 160, 15, (Component)Component.m_237119_());
        leftWidgets.add(this.tagField);
        for (int i = 0; i < leftWidgets.size(); ++i) {
            this.m_142416_((GuiEventListener)((AbstractWidget)leftWidgets.get(i)));
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        guiGraphics.m_280163_(this.GUI, this.getGuiLeft(), this.getGuiTop(), 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        PacketHandler.sendToServer(new PacketUpdateFilterTag(this.isAllowList, this.tags));
        super.m_7379_();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256) {
            if (this.tagField.m_93696_()) {
                this.tagField.m_93692_(false);
                return true;
            }
            this.m_7379_();
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            if (this.tagField.m_93696_()) {
                return true;
            }
            this.m_7379_();
            return true;
        }
        if (this.tagField.m_93696_() && (p_keyPressed_1_ == 257 || p_keyPressed_1_ == 335) && !this.tagField.m_94155_().isEmpty()) {
            String tag = this.tagField.m_94155_().toLowerCase(Locale.ROOT);
            if (!this.tags.contains(tag = tag.replaceAll("[^a-z0-9/:._-]", ""))) {
                this.tags.add(tag);
            }
            this.tagField.m_94144_("");
            this.tagField.m_94144_("");
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6375_(double x, double y, int btn) {
        if (MiscTools.inBounds(this.tagField.m_252754_(), this.tagField.m_252907_(), this.tagField.m_5711_(), this.tagField.m_93694_(), x, y) && btn == 1) {
            this.tagField.m_94144_("");
        }
        if (this.overSlot >= 0) {
            this.selectedSlot = this.overSlot;
            if (FilterTagScreen.m_96638_() && this.selectedSlot != -1) {
                String tag;
                if (this.selectedSlot >= this.stackInSlotTags.size()) {
                    this.tags.remove(this.displayTags.get(this.selectedSlot));
                    this.selectedSlot = -1;
                    return true;
                }
                if (this.selectedSlot < this.stackInSlotTags.size() && !this.tags.contains(tag = this.displayTags.get(this.selectedSlot))) {
                    this.tags.add(tag);
                    this.selectedSlot = -1;
                    return true;
                }
            }
            return true;
        }
        if (this.f_97734_ instanceof FilterBasicSlot) {
            ItemStack stack = ((FilterTagContainer)this.f_97732_).m_142621_();
            stack = stack.m_41777_().m_41620_(this.f_97734_.m_6641_());
            this.f_97734_.m_5852_(stack);
            PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, stack, stack.m_41613_()));
            return true;
        }
        return super.m_6375_(x, y, btn);
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.f_97734_ == null) {
            if (delta == -1.0) {
                if (this.page < this.maxPages) {
                    ++this.page;
                }
            } else if (this.page > 0) {
                --this.page;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.m_237110_((String)("laserio." + key), (Object[])args);
    }
}

