/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketChangeColor {
    private BlockPos sourcePos;
    private int color;
    private int wrenchAlpha;

    public PacketChangeColor(BlockPos pos, int color, int wrenchAlpha) {
        this.sourcePos = pos;
        this.color = color;
        this.wrenchAlpha = wrenchAlpha;
    }

    public static void encode(PacketChangeColor msg, FriendlyByteBuf buffer) {
        buffer.m_130064_(msg.sourcePos);
        buffer.writeInt(msg.color);
        buffer.writeInt(msg.wrenchAlpha);
    }

    public static PacketChangeColor decode(FriendlyByteBuf buffer) {
        return new PacketChangeColor(buffer.m_130135_(), buffer.readInt(), buffer.readInt());
    }

    public static class Handler {
        public static void handle(PacketChangeColor msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender == null) {
                    return;
                }
                BlockEntity blockEntity = sender.m_9236_().m_7702_(msg.sourcePos);
                if (blockEntity instanceof LaserNodeBE) {
                    LaserNodeBE laserNodeBE = (LaserNodeBE)blockEntity;
                    laserNodeBE.setColor(new Color(msg.color, true), msg.wrenchAlpha);
                    laserNodeBE.discoverAllNodes();
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

