/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.containers.customhandler.CardItemHandler;
import com.direwolf20.laserio.common.items.CardCloner;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class PacketCopyPasteCard {
    int slot;
    boolean copy;

    public PacketCopyPasteCard(int slot, boolean copy) {
        this.slot = slot;
        this.copy = copy;
    }

    public static void encode(PacketCopyPasteCard msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.slot);
        buffer.writeBoolean(msg.copy);
    }

    public static PacketCopyPasteCard decode(FriendlyByteBuf buffer) {
        return new PacketCopyPasteCard(buffer.readInt(), buffer.readBoolean());
    }

    public static void playSound(ServerPlayer player, Holder<SoundEvent> soundEventHolder) {
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        ClientboundSoundPacket packet = new ClientboundSoundPacket(soundEventHolder, SoundSource.MASTER, x, y, z, 1.0f, 1.0f, 1L);
        player.f_8906_.m_9829_((Packet)packet);
    }

    public static boolean returnItemToholder(LaserNodeContainer container, ItemStack itemStack, boolean simulate) {
        if (itemStack.m_41619_()) {
            return true;
        }
        int neededReturn = itemStack.m_41613_();
        HashMap<Integer, Integer> returnStackMap = new HashMap<Integer, Integer>();
        for (int returnSlot = 10; returnSlot < LaserNodeContainer.SLOTS; ++returnSlot) {
            ItemStack possibleReturnStack = container.m_38853_(returnSlot).m_7993_();
            if (!possibleReturnStack.m_41619_() && (!possibleReturnStack.m_150930_(itemStack.m_41720_()) || possibleReturnStack.m_41613_() >= possibleReturnStack.m_41741_())) continue;
            int roomAvailable = possibleReturnStack.m_41741_() - possibleReturnStack.m_41613_();
            int amtFit = neededReturn - roomAvailable < 0 ? neededReturn : neededReturn - roomAvailable;
            returnStackMap.put(returnSlot, amtFit);
            if ((neededReturn -= amtFit) != 0) continue;
            if (!simulate) break;
            return true;
        }
        if (neededReturn > 0 || returnStackMap.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : returnStackMap.entrySet()) {
            ItemStack possibleReturnStack = container.m_38853_((Integer)entry.getKey()).m_7993_();
            if (possibleReturnStack.m_41619_()) {
                container.m_38853_((Integer)entry.getKey()).m_5852_(itemStack);
                possibleReturnStack = container.m_38853_((Integer)entry.getKey()).m_7993_();
                possibleReturnStack.m_41764_(((Integer)entry.getValue()).intValue());
                continue;
            }
            possibleReturnStack.m_41769_(((Integer)entry.getValue()).intValue());
        }
        return true;
    }

    public static boolean getItemFromHolder(LaserNodeContainer container, ItemStack itemStack, boolean simulate) {
        if (itemStack.m_41619_()) {
            return true;
        }
        int neededCount = itemStack.m_41613_();
        HashMap<Integer, Integer> findStackMap = new HashMap<Integer, Integer>();
        for (int getSlot = 10; getSlot < LaserNodeContainer.SLOTS; ++getSlot) {
            ItemStack possibleStack = container.m_38853_(getSlot).m_7993_();
            if (!possibleStack.m_150930_(itemStack.m_41720_())) continue;
            int stackAvailable = possibleStack.m_41613_();
            int amtFound = neededCount - stackAvailable < 0 ? neededCount : stackAvailable;
            findStackMap.put(getSlot, amtFound);
            if ((neededCount -= amtFound) != 0) continue;
            if (!simulate) break;
            return true;
        }
        if (neededCount > 0 || findStackMap.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : findStackMap.entrySet()) {
            ItemStack possibleStack = container.m_38853_((Integer)entry.getKey()).m_7993_();
            possibleStack.m_41774_(((Integer)entry.getValue()).intValue());
        }
        return true;
    }

    public static class Handler {
        public static void handle(PacketCopyPasteCard msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                AbstractContainerMenu container = player.f_36096_;
                if (container == null) {
                    return;
                }
                if (!(container instanceof LaserNodeContainer)) {
                    return;
                }
                LaserNodeContainer laserNodeContainer = (LaserNodeContainer)container;
                if (player.f_36096_.m_142621_().m_41619_()) {
                    return;
                }
                ItemStack slotStack = container.m_38853_(msg.slot).m_7993_();
                ItemStack clonerStack = container.m_142621_();
                if (msg.copy) {
                    CardCloner.setItemType(clonerStack, slotStack.m_41720_().toString());
                    CompoundTag compoundTag = slotStack.m_41783_() == null ? new CompoundTag() : slotStack.m_41783_();
                    CardCloner.saveSettings(clonerStack, compoundTag);
                    PacketCopyPasteCard.playSound(player, (Holder<SoundEvent>)Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(SoundEvents.f_12493_.m_11660_().toString()))));
                } else if (slotStack.m_41720_().toString().equals(CardCloner.getItemType(clonerStack))) {
                    ItemStack findStack;
                    int amtNeeded;
                    ItemStack returnStack;
                    int amtReturn;
                    CardItemHandler cardItemHandler = BaseCard.getInventory(slotStack);
                    ItemStack filterNeeded = CardCloner.getFilter(clonerStack);
                    ItemStack existingFilter = cardItemHandler.getStackInSlot(0);
                    ItemStack overclockersNeeded = CardCloner.getOverclocker(clonerStack);
                    ItemStack existingOverclockers = cardItemHandler.getStackInSlot(1);
                    boolean filterSatisfied = false;
                    boolean filterNeedsReturn = false;
                    boolean overclockSatisfied = false;
                    boolean overclockNeedsReturn = false;
                    if (existingFilter.m_150930_(filterNeeded.m_41720_())) {
                        filterSatisfied = true;
                    } else {
                        if (!existingFilter.m_41619_()) {
                            boolean bl = filterNeedsReturn = !PacketCopyPasteCard.returnItemToholder(laserNodeContainer, existingFilter, true);
                        }
                        if (!filterNeedsReturn) {
                            filterSatisfied = PacketCopyPasteCard.getItemFromHolder(laserNodeContainer, filterNeeded, true);
                        }
                    }
                    if (existingOverclockers.m_41613_() == overclockersNeeded.m_41613_()) {
                        overclockSatisfied = true;
                    } else if (existingOverclockers.m_41613_() > overclockersNeeded.m_41613_()) {
                        amtReturn = existingOverclockers.m_41613_() - overclockersNeeded.m_41613_();
                        returnStack = new ItemStack((ItemLike)existingOverclockers.m_41720_(), amtReturn);
                        overclockNeedsReturn = !PacketCopyPasteCard.returnItemToholder(laserNodeContainer, returnStack, true);
                        overclockSatisfied = true;
                    } else {
                        amtNeeded = overclockersNeeded.m_41613_() - existingOverclockers.m_41613_();
                        findStack = new ItemStack((ItemLike)overclockersNeeded.m_41720_(), amtNeeded);
                        overclockSatisfied = PacketCopyPasteCard.getItemFromHolder(laserNodeContainer, findStack, true);
                    }
                    if (filterSatisfied && !filterNeedsReturn && overclockSatisfied && !overclockNeedsReturn) {
                        if (!existingFilter.m_150930_(filterNeeded.m_41720_())) {
                            boolean success = PacketCopyPasteCard.returnItemToholder(laserNodeContainer, existingFilter, false);
                            if (!success) {
                                ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), existingFilter);
                                player.m_9236_().m_7967_((Entity)itemEntity);
                            }
                            PacketCopyPasteCard.getItemFromHolder(laserNodeContainer, filterNeeded, false);
                        }
                        if (existingOverclockers.m_41613_() != overclockersNeeded.m_41613_()) {
                            if (existingOverclockers.m_41613_() > overclockersNeeded.m_41613_()) {
                                amtReturn = existingOverclockers.m_41613_() - overclockersNeeded.m_41613_();
                                returnStack = new ItemStack((ItemLike)existingOverclockers.m_41720_(), amtReturn);
                                boolean success = PacketCopyPasteCard.returnItemToholder(laserNodeContainer, returnStack, false);
                                if (!success) {
                                    ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), returnStack);
                                    player.m_9236_().m_7967_((Entity)itemEntity);
                                }
                            } else {
                                amtNeeded = overclockersNeeded.m_41613_() - existingOverclockers.m_41613_();
                                findStack = new ItemStack((ItemLike)overclockersNeeded.m_41720_(), amtNeeded);
                                PacketCopyPasteCard.getItemFromHolder(laserNodeContainer, findStack, false);
                            }
                        }
                        ItemStack tempStack = slotStack.m_41777_();
                        CompoundTag compoundTag = CardCloner.getSettings(clonerStack);
                        if (compoundTag.equals((Object)new CompoundTag())) {
                            tempStack.m_41751_(null);
                        } else {
                            tempStack.m_41751_(CardCloner.getSettings(clonerStack));
                        }
                        container.m_38853_(msg.slot).m_5852_(tempStack);
                        PacketCopyPasteCard.playSound(player, (Holder<SoundEvent>)Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(SoundEvents.f_11887_.m_11660_().toString()))));
                        ((LaserNodeContainer)container).tile.updateThisNode();
                    } else {
                        PacketCopyPasteCard.playSound(player, (Holder<SoundEvent>)Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(SoundEvents.f_276627_.m_11660_().toString()))));
                    }
                } else {
                    PacketCopyPasteCard.playSound(player, (Holder<SoundEvent>)Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(SoundEvents.f_276627_.m_11660_().toString()))));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

