/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.util.BaseCardCache;
import com.direwolf20.laserio.util.ItemHandlerUtil;
import com.direwolf20.laserio.util.StockerCardCache;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TransferResult {
    public List<Result> results = new CopyOnWriteArrayList<Result>();
    public ItemStack remainingStack = ItemStack.f_41583_;

    public TransferResult() {
    }

    public TransferResult(Result result) {
        this.results.add(result);
    }

    public TransferResult(Result result, ItemStack itemStack) {
        this.results.add(result);
        this.remainingStack = itemStack;
    }

    public void addResult(Result result) {
        this.results.add(result);
    }

    public void addRemainingStack(ItemStack stack) {
        this.remainingStack = stack;
    }

    public int getTotalItemCounts() {
        return this.results.stream().mapToInt(i -> i.itemStack.m_41613_()).sum();
    }

    public void addResult(TransferResult newResult) {
        this.results.addAll(newResult.results);
        if (this.remainingStack.m_41619_()) {
            this.remainingStack = newResult.remainingStack;
        } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.remainingStack, (ItemStack)newResult.remainingStack)) {
            this.remainingStack.m_41769_(newResult.remainingStack.m_41613_());
        }
    }

    public void addOtherCard(IItemHandler handler, int slot, BaseCardCache card, LaserNodeBE be) {
        for (Result result : this.results) {
            if (result.inserterCardCache == null) {
                result.addInserter(handler, slot, card, be);
                continue;
            }
            if (result.extractorCardCache != null) continue;
            result.addExtractor(handler, slot, card, be);
        }
    }

    public Result splitResult(Result result, int count) {
        if (!this.results.contains(result)) {
            return null;
        }
        int position = this.results.indexOf(result);
        Result newResult = new Result(result.insertHandler, result.extractHandler, result.insertSlot, result.extractSlot, result.inserterCardCache, result.extractorCardCache, result.fromBE, result.toBE, result.itemStack);
        this.results.get((int)position).itemStack.m_41774_(count);
        newResult.itemStack.m_41774_(result.itemStack.m_41613_());
        this.results.add(newResult);
        return result;
    }

    public void doIt() {
        for (Result result : this.results) {
            result.doIt();
        }
    }

    public static class Result {
        public IItemHandler extractHandler;
        public IItemHandler insertHandler;
        public int insertSlot;
        public int extractSlot;
        public BaseCardCache inserterCardCache;
        public BaseCardCache extractorCardCache;
        public ItemStack itemStack;
        public LaserNodeBE fromBE;
        public LaserNodeBE toBE;

        public Result(IItemHandler insertHandler, IItemHandler extractHandler, int insertSlot, int extractSlot, BaseCardCache inserterCardCache, BaseCardCache extractorCardCache, LaserNodeBE fromBE, LaserNodeBE toBE, ItemStack itemStack) {
            this.insertHandler = insertHandler;
            this.extractHandler = extractHandler;
            this.insertSlot = insertSlot;
            this.extractSlot = extractSlot;
            this.inserterCardCache = inserterCardCache;
            this.extractorCardCache = extractorCardCache;
            this.fromBE = fromBE;
            this.toBE = toBE;
            this.itemStack = itemStack;
        }

        public Result(IItemHandler handler, int slot, BaseCardCache cardCache, ItemStack itemStack, LaserNodeBE be, boolean extractor) {
            if (extractor) {
                this.extractHandler = handler;
                this.extractSlot = slot;
                this.extractorCardCache = cardCache;
                this.itemStack = itemStack;
                this.fromBE = be;
            } else {
                this.insertHandler = handler;
                this.insertSlot = slot;
                this.inserterCardCache = cardCache;
                this.itemStack = itemStack;
                this.toBE = be;
            }
        }

        public void addInserter(IItemHandler handler, int slot, BaseCardCache inserterCardCache, LaserNodeBE be) {
            this.insertHandler = handler;
            this.insertSlot = slot;
            this.inserterCardCache = inserterCardCache;
            this.toBE = be;
        }

        public void addExtractor(IItemHandler handler, int slot, BaseCardCache extractorCardCache, LaserNodeBE be) {
            this.extractHandler = handler;
            this.extractSlot = slot;
            this.extractorCardCache = extractorCardCache;
            this.fromBE = be;
        }

        public void doIt() {
            if (this.fromBE == null || this.toBE == null || this.extractorCardCache == null || this.inserterCardCache == null) {
                return;
            }
            if (this.extractSlot == -1) {
                ItemHandlerUtil.extractItem(this.extractHandler, this.itemStack, false, this.extractorCardCache.isCompareNBT).itemStack();
            } else {
                this.extractHandler.extractItem(this.extractSlot, this.itemStack.m_41613_(), false);
            }
            if (this.insertSlot == -1) {
                ItemHandlerHelper.insertItem((IItemHandler)this.insertHandler, (ItemStack)this.itemStack, (boolean)false);
            } else {
                this.insertHandler.insertItem(this.insertSlot, this.itemStack, false);
            }
            if (this.extractorCardCache instanceof StockerCardCache) {
                this.fromBE.drawParticles(this.itemStack, this.inserterCardCache.direction, this.toBE, this.fromBE, this.extractorCardCache.direction, this.inserterCardCache.cardSlot, this.extractorCardCache.cardSlot);
            } else {
                this.fromBE.drawParticles(this.itemStack, this.extractorCardCache.direction, this.fromBE, this.toBE, this.inserterCardCache.direction, this.extractorCardCache.cardSlot, this.inserterCardCache.cardSlot);
            }
        }

        public int count() {
            return this.itemStack.m_41613_();
        }
    }
}

