/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.network.ClientNetworking;
import dan200.computercraft.shared.computer.core.InputHandler;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.QueueEventServerMessage;
import javax.annotation.Nullable;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class ClientInputHandler
implements InputHandler {
    private final AbstractContainerMenu menu;

    public ClientInputHandler(AbstractContainerMenu menu) {
        this.menu = menu;
    }

    @Override
    public void turnOn() {
        ClientNetworking.sendToServer(new ComputerActionServerMessage(this.menu, ComputerActionServerMessage.Action.TURN_ON));
    }

    @Override
    public void shutdown() {
        ClientNetworking.sendToServer(new ComputerActionServerMessage(this.menu, ComputerActionServerMessage.Action.SHUTDOWN));
    }

    @Override
    public void reboot() {
        ClientNetworking.sendToServer(new ComputerActionServerMessage(this.menu, ComputerActionServerMessage.Action.REBOOT));
    }

    @Override
    public void queueEvent(String event, @Nullable Object[] arguments) {
        ClientNetworking.sendToServer(new QueueEventServerMessage(this.menu, event, arguments));
    }

    @Override
    public void keyDown(int key, boolean repeat) {
        ClientNetworking.sendToServer(new KeyEventServerMessage(this.menu, repeat ? KeyEventServerMessage.Action.REPEAT : KeyEventServerMessage.Action.DOWN, key));
    }

    @Override
    public void keyUp(int key) {
        ClientNetworking.sendToServer(new KeyEventServerMessage(this.menu, KeyEventServerMessage.Action.UP, key));
    }

    @Override
    public void mouseClick(int button, int x, int y) {
        ClientNetworking.sendToServer(new MouseEventServerMessage(this.menu, MouseEventServerMessage.Action.CLICK, button, x, y));
    }

    @Override
    public void mouseUp(int button, int x, int y) {
        ClientNetworking.sendToServer(new MouseEventServerMessage(this.menu, MouseEventServerMessage.Action.UP, button, x, y));
    }

    @Override
    public void mouseDrag(int button, int x, int y) {
        ClientNetworking.sendToServer(new MouseEventServerMessage(this.menu, MouseEventServerMessage.Action.DRAG, button, x, y));
    }

    @Override
    public void mouseScroll(int direction, int x, int y) {
        ClientNetworking.sendToServer(new MouseEventServerMessage(this.menu, MouseEventServerMessage.Action.SCROLL, direction, x, y));
    }
}

