/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import com.mojang.brigadier.CommandDispatcher;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.CommonHooks;
import dan200.computercraft.shared.command.CommandComputerCraft;
import dan200.computercraft.shared.computer.blocks.ComputerBlockEntity;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.integration.Optifine;
import dan200.computercraft.shared.network.client.UpgradesLoadedMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.peripheral.commandblock.CommandBlockPeripheral;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlockEntity;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.printer.PrinterBlockEntity;
import dan200.computercraft.shared.peripheral.speaker.SpeakerBlockEntity;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.util.CapabilityProvider;
import dan200.computercraft.shared.util.SidedCapabilityProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkTicketLevelUpdatedEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

@Mod.EventBusSubscriber(modid="computercraft")
public class ForgeCommonHooks {
    private static final ResourceLocation PERIPHERAL = new ResourceLocation("computercraft", "peripheral");
    private static final ResourceLocation WIRED_ELEMENT = new ResourceLocation("computercraft", "wired_node");
    private static final ResourceLocation INVENTORY = new ResourceLocation("computercraft", "inventory");

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        switch (event.phase) {
            case START: {
                CommonHooks.onServerTickStart(event.getServer());
                break;
            }
            case END: {
                CommonHooks.onServerTickEnd();
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        CommonHooks.onServerStarting(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Optifine.warnAboutOptifine(arg_0 -> ((Player)event.getEntity()).m_213846_(arg_0));
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        CommonHooks.onServerStopped();
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        CommandComputerCraft.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ChunkAccess chunkAccess;
        if (event.getLevel() instanceof ServerLevel && (chunkAccess = event.getChunk()) instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            CommonHooks.onServerChunkUnload(chunk);
        }
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        CommonHooks.onChunkWatch(event.getChunk(), event.getPlayer());
    }

    @SubscribeEvent
    public static void onChunkTicketLevelChanged(ChunkTicketLevelUpdatedEvent event) {
        CommonHooks.onChunkTicketLevelChanged(event.getLevel(), event.getChunkPos(), event.getOldTicketLevel(), event.getNewTicketLevel());
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        CommonHooks.onDatapackReload((id, listener) -> event.addListener(listener));
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        UpgradesLoadedMessage packet = new UpgradesLoadedMessage();
        if (event.getPlayer() == null) {
            ServerNetworking.sendToAllPlayers(packet, event.getPlayerList().m_7873_());
        } else {
            ServerNetworking.sendToPlayer(packet, event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onCapability(AttachCapabilitiesEvent<BlockEntity> event) {
        BlockEntity blockEntity = (BlockEntity)event.getObject();
        if (blockEntity instanceof ComputerBlockEntity) {
            ComputerBlockEntity computer = (ComputerBlockEntity)blockEntity;
            CapabilityProvider.attach(event, PERIPHERAL, Capabilities.CAPABILITY_PERIPHERAL, computer::peripheral);
        } else if (blockEntity instanceof TurtleBlockEntity) {
            TurtleBlockEntity turtle = (TurtleBlockEntity)blockEntity;
            CapabilityProvider.attach(event, INVENTORY, ForgeCapabilities.ITEM_HANDLER, () -> new InvWrapper((Container)turtle));
            CapabilityProvider<IPeripheral> peripheral = CapabilityProvider.attach(event, PERIPHERAL, Capabilities.CAPABILITY_PERIPHERAL, turtle::peripheral);
            turtle.onMoved(peripheral::invalidate);
        } else if (blockEntity instanceof DiskDriveBlockEntity) {
            DiskDriveBlockEntity diskDrive = (DiskDriveBlockEntity)blockEntity;
            CapabilityProvider.attach(event, INVENTORY, ForgeCapabilities.ITEM_HANDLER, () -> new InvWrapper((Container)diskDrive));
            CapabilityProvider.attach(event, PERIPHERAL, Capabilities.CAPABILITY_PERIPHERAL, diskDrive::peripheral);
        } else if (blockEntity instanceof CableBlockEntity) {
            CableBlockEntity cable = (CableBlockEntity)blockEntity;
            SidedCapabilityProvider<IPeripheral> peripheralHandler = SidedCapabilityProvider.attach(event, PERIPHERAL, Capabilities.CAPABILITY_PERIPHERAL, cable::getPeripheral);
            SidedCapabilityProvider<WiredElement> elementHandler = SidedCapabilityProvider.attach(event, WIRED_ELEMENT, Capabilities.CAPABILITY_WIRED_ELEMENT, cable::getWiredElement);
            cable.onModemChanged(() -> {
                peripheralHandler.invalidate();
                elementHandler.invalidate();
            });
        } else if (blockEntity instanceof WiredModemFullBlockEntity) {
            WiredModemFullBlockEntity modem = (WiredModemFullBlockEntity)blockEntity;
            SidedCapabilityProvider.attach(event, PERIPHERAL, Capabilities.CAPABILITY_PERIPHERAL, modem::getPeripheral);
            CapabilityProvider.attach(event, WIRED_ELEMENT, Capabilities.CAPABILITY_WIRED_ELEMENT, modem::getElement);
        } else if (blockEntity instanceof WirelessModemBlockEntity) {
            WirelessModemBlockEntity modem = (WirelessModemBlockEntity)blockEntity;
            SidedCapabilityProvider<IPeripheral> peripheral = SidedCapabilityProvider.attach(event, PERIPHERAL, Capabilities.CAPABILITY_PERIPHERAL, modem::getPeripheral);
            modem.onModemChanged(peripheral::invalidate);
        } else if (blockEntity instanceof MonitorBlockEntity) {
            MonitorBlockEntity monitor = (MonitorBlockEntity)blockEntity;
            CapabilityProvider.attach(event, PERIPHERAL, Capabilities.CAPABILITY_PERIPHERAL, monitor::peripheral);
        } else if (blockEntity instanceof SpeakerBlockEntity) {
            SpeakerBlockEntity speaker = (SpeakerBlockEntity)blockEntity;
            CapabilityProvider.attach(event, PERIPHERAL, Capabilities.CAPABILITY_PERIPHERAL, speaker::peripheral);
        } else if (blockEntity instanceof PrinterBlockEntity) {
            PrinterBlockEntity printer = (PrinterBlockEntity)blockEntity;
            CapabilityProvider.attach(event, PERIPHERAL, Capabilities.CAPABILITY_PERIPHERAL, printer::peripheral);
            SidedCapabilityProvider.attach(event, INVENTORY, ForgeCapabilities.ITEM_HANDLER, s -> s == null ? new InvWrapper((Container)printer) : new SidedInvWrapper((WorldlyContainer)printer, s));
        } else if (Config.enableCommandBlock && blockEntity instanceof CommandBlockEntity) {
            CommandBlockEntity commandBlock = (CommandBlockEntity)blockEntity;
            CapabilityProvider.attach(event, PERIPHERAL, Capabilities.CAPABILITY_PERIPHERAL, () -> new CommandBlockPeripheral(commandBlock));
        }
    }

    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent event) {
        LootPool.Builder pool = CommonHooks.getExtraLootPool(event.getName());
        if (pool != null) {
            event.getTable().addPool(pool.m_79082_());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        if (CommonHooks.onEntitySpawn(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingDrops(LivingDropsEvent event) {
        event.getDrops().removeIf(itemEntity -> CommonHooks.onLivingDrop((Entity)event.getEntity(), itemEntity.m_32055_()));
    }
}

