/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei.category;

import giselle.jei_mekanism_multiblocks.client.TooltipHelper;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWithButtons;
import giselle.jei_mekanism_multiblocks.client.gui.Mod2IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.jei.CostWidget;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockCategory;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockWidget;
import giselle.jei_mekanism_multiblocks.client.jei.ResultWidget;
import giselle.jei_mekanism_multiblocks.client.jei.category.ICostConsumer;
import giselle.jei_mekanism_multiblocks.common.util.VolumeTextHelper;
import java.util.function.Consumer;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsItems;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class TurbineCategory
extends MultiblockCategory<TurbineWidget> {
    public TurbineCategory(IGuiHelper helper) {
        super(helper, MekanismGenerators.rl((String)"turbine"), TurbineWidget.class, (Component)GeneratorsLang.TURBINE.translate(new Object[0]), GeneratorsBlocks.TURBINE_VALVE.getItemStack());
    }

    @Override
    protected void getRecipeCatalystItemStacks(Consumer<ItemStack> consumer) {
        super.getRecipeCatalystItemStacks(consumer);
        consumer.accept(GeneratorsBlocks.TURBINE_CASING.getItemStack());
        consumer.accept(GeneratorsBlocks.TURBINE_VALVE.getItemStack());
        consumer.accept(GeneratorsBlocks.TURBINE_VENT.getItemStack());
        consumer.accept(GeneratorsBlocks.ROTATIONAL_COMPLEX.getItemStack());
        consumer.accept(GeneratorsBlocks.TURBINE_ROTOR.getItemStack());
        consumer.accept(GeneratorsItems.TURBINE_BLADE.getItemStack());
        consumer.accept(MekanismBlocks.PRESSURE_DISPERSER.getItemStack());
        consumer.accept(GeneratorsBlocks.ELECTROMAGNETIC_COIL.getItemStack());
        consumer.accept(GeneratorsBlocks.SATURATING_CONDENSER.getItemStack());
        consumer.accept(MekanismBlocks.STRUCTURAL_GLASS.getItemStack());
    }

    public static class TurbineWidget
    extends MultiblockWidget {
        protected IntSliderWithButtons rotorsWidget;
        protected IntSliderWithButtons ventsWidget;
        protected IntSliderWithButtons condensersWidget;
        protected IntSliderWithButtons valvesWidget;
        private boolean needMoreVents;

        public TurbineWidget() {
            this.widthWidget.setTranslationKey("text.jei_mekanism_multiblocks.specs.width_length");
        }

        @Override
        protected IntSliderWidget createDimensionSlider(int index, int min, int max) {
            if (index == 0) {
                return new Mod2IntSliderWidget(0, 0, 0, 0, (Component)Component.m_237119_(), min, min, max, 0);
            }
            return super.createDimensionSlider(index, min, max);
        }

        @Override
        protected boolean isUseDimensionWidget(IntSliderWithButtons widget) {
            if (widget == this.lengthWidget) {
                return false;
            }
            return super.isUseDimensionWidget(widget);
        }

        @Override
        protected void collectOtherConfigs(Consumer<AbstractWidget> consumer) {
            super.collectOtherConfigs(consumer);
            this.rotorsWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.rotors", 0, 1, 0);
            consumer.accept(this.rotorsWidget);
            ((IntSliderWidget)((Object)this.rotorsWidget.getSlider())).addValueChangeHanlder(this::onRotorsChanged);
            this.ventsWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.vents", 0, 1, 0);
            consumer.accept(this.ventsWidget);
            ((IntSliderWidget)((Object)this.ventsWidget.getSlider())).addValueChangeHanlder(this::onVentsChanged);
            this.condensersWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.condensers", 0, 0, 0);
            consumer.accept(this.condensersWidget);
            ((IntSliderWidget)((Object)this.condensersWidget.getSlider())).addValueChangeHanlder(this::onCondensersChanged);
            this.valvesWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.valves", 0, 2, 0);
            consumer.accept(this.valvesWidget);
            ((IntSliderWidget)((Object)this.valvesWidget.getSlider())).addValueChangeHanlder(this::onValvesChanged);
            this.updateRotorsSliderLimit();
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.setRotorCount(tag.m_128451_("RotorCount"));
            this.setVentCount(tag.m_128451_("VentCount"));
            this.setCondenserCount(tag.m_128451_("CondenserCount"));
            this.setValveCount(tag.m_128451_("ValveCount"));
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.m_128405_("RotorCount", this.getRotorCount());
            tag.m_128405_("VentCount", this.getVentCount());
            tag.m_128405_("CondenserCount", this.getCondenserCount());
            tag.m_128405_("ValveCount", this.getValveCount());
        }

        @Override
        protected void onDimensionWidthChanged(int width) {
            width += width % 2 - 1;
            IntSliderWidget widthSlider = (IntSliderWidget)((Object)this.widthWidget.getSlider());
            widthSlider.setValue(width);
            super.onDimensionWidthChanged(width);
            IntSliderWidget lengthSlider = (IntSliderWidget)((Object)this.lengthWidget.getSlider());
            lengthSlider.setMinValue(width);
            lengthSlider.setMaxValue(width);
            lengthSlider.setValue(width);
        }

        @Override
        protected void onDimensionChanged() {
            super.onDimensionChanged();
            this.updateRotorsSliderLimit();
            this.setRotorCount(((IntSliderWidget)((Object)this.rotorsWidget.getSlider())).getMaxValue());
            this.setVentCount(this.getClampedMaxVentCount(this.getRotorCount()));
            this.setCondenserCount(this.getClampedMaxCondenserCount(this.getRotorCount(), this.getVentCount()));
        }

        public void updateRotorsSliderLimit() {
            Vec3i inner = this.getDimensionInner();
            int innerRadius = (inner.m_123341_() - 1) / 2;
            IntSliderWidget rotorsSlider = (IntSliderWidget)((Object)this.rotorsWidget.getSlider());
            int rotors = rotorsSlider.getValue();
            rotorsSlider.setMaxValue(Math.min((innerRadius + 1) * 4 - 3, inner.m_123342_() - 2));
            rotorsSlider.setValue(rotors);
            this.updateVentsSliderLimit();
        }

        protected void onRotorsChanged(int rotors) {
            this.updateVentsSliderLimit();
            this.setVentCount(this.getClampedMaxVentCount(rotors));
            this.setCondenserCount(this.getClampedMaxCondenserCount(rotors, this.getVentCount()));
            this.markNeedUpdate();
        }

        public void updateVentsSliderLimit() {
            IntSliderWidget ventsSlider = (IntSliderWidget)((Object)this.ventsWidget.getSlider());
            int vents = ventsSlider.getValue();
            ventsSlider.setMaxValue(this.getClampedMaxVentCount(this.getRotorCount()));
            ventsSlider.setValue(vents);
            this.updateCondensersSliderLimit();
            this.updateValvesSliderLimit();
        }

        protected void onVentsChanged(int vents) {
            this.updateCondensersSliderLimit();
            this.updateValvesSliderLimit();
            this.markNeedUpdate();
        }

        public void updateCondensersSliderLimit() {
            IntSliderWidget condensersSlider = (IntSliderWidget)((Object)this.condensersWidget.getSlider());
            int condensers = condensersSlider.getValue();
            condensersSlider.setMaxValue(this.getClampedMaxCondenserCount(this.getRotorCount(), this.getVentCount()));
            condensersSlider.setValue(condensers);
        }

        protected void onCondensersChanged(int condensers) {
            this.markNeedUpdate();
        }

        public void updateValvesSliderLimit() {
            IntSliderWidget valvesSlider = (IntSliderWidget)((Object)this.valvesWidget.getSlider());
            int valves = valvesSlider.getValue();
            valvesSlider.setMaxValue(this.getSideBlocks() - this.getVentCount());
            valvesSlider.setValue(valves);
        }

        protected void onValvesChanged(int valves) {
            this.markNeedUpdate();
        }

        @Override
        protected void collectCost(ICostConsumer consumer) {
            super.collectCost(consumer);
            int corners = this.getCornerBlocks();
            int sides = this.getSideBlocks();
            int rotors = this.getRotorCount();
            int blades = this.getBladeCount(rotors);
            int lowerVolume = this.getLowerVolume(rotors);
            int vents = this.getVentCount();
            sides -= vents;
            int valves = this.getValveCount();
            sides -= valves;
            int casing = 0;
            int glasses = 0;
            if (this.isUseGlass()) {
                casing = corners;
                glasses = sides;
            } else {
                casing = corners + sides;
                glasses = 0;
            }
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.TURBINE_CASING, casing));
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.TURBINE_VALVE, valves));
            CostWidget vent = consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.TURBINE_VENT, vents));
            if (this.needMoreVents) {
                vent.setFGColor(0xFF8000);
                vent.setHeadTooltip(new Component[]{Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.value_limited", (Object[])new Object[]{Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.max_flow_rate")}).m_130940_(ChatFormatting.RED), Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.need_more", (Object[])new Object[]{GeneratorsBlocks.TURBINE_VENT.getTextComponent()}).m_130940_(ChatFormatting.RED)});
            }
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.ROTATIONAL_COMPLEX));
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.TURBINE_ROTOR, rotors));
            consumer.accept(new ItemStack((ItemLike)GeneratorsItems.TURBINE_BLADE, blades));
            consumer.accept(new ItemStack((ItemLike)MekanismBlocks.PRESSURE_DISPERSER, this.getDisperserCount()));
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.ELECTROMAGNETIC_COIL, this.getNeededCoilCount(blades)));
            CostWidget maxWaterOutputWidget = consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.SATURATING_CONDENSER, this.getCondenserCount()));
            int maxFlow = MathUtils.clampToInt((double)this.getMaxFlowRateClamped(lowerVolume, vents));
            if ((long)maxFlow > this.getMaxWaterOutput()) {
                maxWaterOutputWidget.setFGColor(0xFF8000);
                maxWaterOutputWidget.setHeadTooltip(new Component[]{Component.m_237115_((String)"text.jei_mekanism_multiblocks.tooltip.warning").m_130940_(ChatFormatting.RED), Component.m_237115_((String)"text.jei_mekanism_multiblocks.tooltip.water_will_losing").m_130940_(ChatFormatting.RED), Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.need_more", (Object[])new Object[]{GeneratorsBlocks.SATURATING_CONDENSER.getTextComponent()}).m_130940_(ChatFormatting.RED)});
            }
            consumer.accept(new ItemStack((ItemLike)this.getGlassBlock(), glasses));
        }

        @Override
        protected void collectResult(Consumer<AbstractWidget> consumer) {
            super.collectResult(consumer);
            int volume = this.getDimensionVolume();
            int rotors = this.getRotorCount();
            int lowerVolume = this.getLowerVolume(rotors);
            int blades = this.getBladeCount(rotors);
            int vents = this.getVentCount();
            FloatingLong maxProduction = this.getMaxProduction(lowerVolume, blades, vents);
            int maxFlow = MathUtils.clampToInt((double)this.getMaxFlowRateClamped(lowerVolume, vents));
            long maxWaterOutput = this.getMaxWaterOutput();
            long steamTank = this.getSteamTank(lowerVolume);
            FloatingLong energyCapacity = this.getEnergyCapacity(volume);
            FloatingLong productionPerFlow = maxProduction.divide((long)maxFlow);
            MutableComponent productionPerFlowTooltip = Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.production_per_flow", (Object[])new Object[]{Component.m_237110_((String)"%1$s/%2$s", (Object[])new Object[]{EnergyDisplay.of((FloatingLong)productionPerFlow).getTextComponent(), "mB"})});
            ResultWidget maxProductionWidget = new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.max_production"), (Component)Component.m_237110_((String)"%s/t", (Object[])new Object[]{EnergyDisplay.of((FloatingLong)maxProduction).getTextComponent()}));
            maxProductionWidget.m_257544_(TooltipHelper.createMessageOnly(new Component[]{productionPerFlowTooltip}));
            consumer.accept(maxProductionWidget);
            ResultWidget maxFlowRateWidget = new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.max_flow_rate"), VolumeTextHelper.formatMBt(maxFlow));
            consumer.accept(maxFlowRateWidget);
            boolean bl = this.needMoreVents = vents < this.getClampedMaxVentCount(this.getRotorCount());
            if (this.needMoreVents) {
                maxFlowRateWidget.getValueLabel().setFGColor(0xFF8000);
                maxFlowRateWidget.m_257544_(TooltipHelper.createMessageOnly(new Component[]{productionPerFlowTooltip, Component.m_237115_((String)"text.jei_mekanism_multiblocks.tooltip.limited").m_130940_(ChatFormatting.RED), Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.need_more", (Object[])new Object[]{GeneratorsBlocks.TURBINE_VENT.getTextComponent()}).m_130940_(ChatFormatting.RED)}));
            } else {
                maxFlowRateWidget.m_257544_(TooltipHelper.createMessageOnly(new Component[]{productionPerFlowTooltip}));
            }
            ResultWidget maxWaterOutputWidget = new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.max_water_output"), VolumeTextHelper.formatMBt(maxWaterOutput));
            consumer.accept(maxWaterOutputWidget);
            if ((long)maxFlow > maxWaterOutput) {
                maxWaterOutputWidget.getValueLabel().setFGColor(0xFF8000);
                maxWaterOutputWidget.m_257544_(TooltipHelper.createMessageOnly(new Component[]{Component.m_237115_((String)"text.jei_mekanism_multiblocks.tooltip.warning").m_130940_(ChatFormatting.RED), Component.m_237115_((String)"text.jei_mekanism_multiblocks.tooltip.water_will_losing").m_130940_(ChatFormatting.RED), Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.need_more", (Object[])new Object[]{GeneratorsBlocks.SATURATING_CONDENSER.getTextComponent()}).m_130940_(ChatFormatting.RED)}));
            }
            consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.steam_tank"), VolumeTextHelper.formatMB(steamTank)));
            consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.energy_capacity"), EnergyDisplay.of((FloatingLong)energyCapacity).getTextComponent()));
        }

        public long getSteamTank(int lowerVolume) {
            return (long)lowerVolume * MekanismGeneratorsConfig.generators.turbineGasPerTank.get();
        }

        public FloatingLong getEnergyCapacity(int volume) {
            return ((FloatingLong)MekanismGeneratorsConfig.generators.turbineEnergyCapacityPerVolume.get()).multiply((long)volume);
        }

        public int getClampedMaxVentCount(int rotorCount) {
            int unclamped = this.getNeededVentCountUnclamped(this.getLowerVolume(rotorCount));
            int upperSideBlocks = this.getUpperSideBlocks(rotorCount);
            return Math.min(unclamped, upperSideBlocks);
        }

        public int getClampedMaxCondenserCount(int rotorCount, int ventCount) {
            int coils = this.getNeededCoilCount(this.getBladeCount(rotorCount));
            int lowerVolume = this.getLowerVolume(rotorCount);
            double maxFlowRate = this.getMaxFlowRateClamped(lowerVolume, ventCount);
            int unclampedCondensers = Mth.m_14165_((double)(maxFlowRate / (double)MekanismGeneratorsConfig.generators.condenserRate.get()));
            return Math.min(unclampedCondensers, this.getUpperInnerVolume(rotorCount) - coils);
        }

        public int getLowerSideBlocks(int rotorCount) {
            Vec3i inner = this.getDimensionInner();
            int innerSquare = inner.m_123341_() * inner.m_123343_();
            return innerSquare + (inner.m_123341_() * 2 + inner.m_123343_() * 2) * rotorCount;
        }

        public int getUpperSideBlocks(int rotorCount) {
            Vec3i inner = this.getDimensionInner();
            int innerSquare = inner.m_123341_() * inner.m_123343_();
            int upperHeight = this.getUpperHeight(rotorCount);
            return innerSquare + (inner.m_123341_() * 2 + inner.m_123343_() * 2) * upperHeight;
        }

        public int getUpperHeight(int rotorCount) {
            return this.getDimensionInner().m_123342_() - rotorCount;
        }

        public int getUpperInnerVolume(int rotorCount) {
            Vec3i inner = this.getDimensionInner();
            int innerSquare = inner.m_123341_() * inner.m_123343_();
            int upperHeight = this.getUpperHeight(rotorCount);
            return innerSquare * (upperHeight - 1);
        }

        public int getNeededVentCountUnclamped(int lowerVolume) {
            double flowRate = this.getMaxFlowRateUnclamped(lowerVolume);
            return Mth.m_14165_((double)(flowRate / MekanismGeneratorsConfig.generators.turbineVentGasFlow.get()));
        }

        public int getNeededCoilCount(int bladeCount) {
            return Mth.m_14165_((double)((double)bladeCount / (double)MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
        }

        public double getMaxFlowRateUnclamped(int lowerVolume) {
            return (double)(lowerVolume * this.getDisperserCount()) * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get();
        }

        public double getMaxFlowRateClamped(int lowerVolume, int vents) {
            double unclamped = this.getMaxFlowRateUnclamped(lowerVolume);
            return Math.min(unclamped, (double)vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
        }

        public long getMaxWaterOutput() {
            return (long)this.getCondenserCount() * (long)MekanismGeneratorsConfig.generators.condenserRate.get();
        }

        public FloatingLong getMaxProduction(int lowerVolume, int blades, int vents) {
            double flowRate = this.getMaxFlowRateClamped(lowerVolume, vents);
            if (flowRate > 0.0) {
                int coils = this.getNeededCoilCount(lowerVolume);
                FloatingLong energyMultiplier = ((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply((long)Math.min(blades, coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
                return energyMultiplier.multiply(flowRate);
            }
            return FloatingLong.ZERO;
        }

        public int getLowerVolume(int rotorCount) {
            Vec3i outer = this.getDimension();
            return outer.m_123341_() * outer.m_123343_() * rotorCount;
        }

        public int getDisperserCount() {
            Vec3i inner = this.getDimensionInner();
            return inner.m_123341_() * inner.m_123343_() - 1;
        }

        public int getValveCount() {
            return ((IntSliderWidget)((Object)this.valvesWidget.getSlider())).getValue();
        }

        public void setValveCount(int valveCount) {
            ((IntSliderWidget)((Object)this.valvesWidget.getSlider())).setValue(valveCount);
        }

        public int getRotorCount() {
            return ((IntSliderWidget)((Object)this.rotorsWidget.getSlider())).getValue();
        }

        public int getBladeCount(int rotorCount) {
            return rotorCount * 2;
        }

        public void setRotorCount(int rotorCount) {
            ((IntSliderWidget)((Object)this.rotorsWidget.getSlider())).setValue(rotorCount);
        }

        public int getCondenserCount() {
            return ((IntSliderWidget)((Object)this.condensersWidget.getSlider())).getValue();
        }

        public void setCondenserCount(int condenserCount) {
            ((IntSliderWidget)((Object)this.condensersWidget.getSlider())).setValue(condenserCount);
        }

        public int getVentCount() {
            return ((IntSliderWidget)((Object)this.ventsWidget.getSlider())).getValue();
        }

        public void setVentCount(int ventCount) {
            ((IntSliderWidget)((Object)this.ventsWidget.getSlider())).setValue(ventCount);
        }

        @Override
        public int getDimensionWidthMin() {
            return 5;
        }

        @Override
        public int getDimensionWidthMax() {
            return 17;
        }

        @Override
        public int getDimensionLengthMin() {
            return this.getDimensionWidthMin();
        }

        @Override
        public int getDimensionLengthMax() {
            return this.getDimensionWidthMax();
        }

        @Override
        public int getDimensionHeightMin() {
            return 5;
        }

        @Override
        public int getDimensionHeightMax() {
            return 18;
        }

        @Override
        public Block getGlassBlock() {
            return MekanismBlocks.STRUCTURAL_GLASS.getBlock();
        }
    }
}

