/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms;

import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.common.network.PacketPlayerConfig;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.platforms.Values;

public class Configuration {
    private static final ForgeConfigSpec.Builder BUILDER_CLIENT = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder BUILDER_COMMON = new ForgeConfigSpec.Builder();
    public static final Menu_General GENERAL = new Menu_General(BUILDER_CLIENT, BUILDER_COMMON);
    public static final Menu_GUI GUI_STYLE = new Menu_GUI(BUILDER_CLIENT);
    public static final Crafting CRAFTING = new Crafting(BUILDER_COMMON);
    public static final DustCovering DUST_COVERING = new DustCovering(BUILDER_COMMON);
    static final ForgeConfigSpec SPEC_CLIENT = BUILDER_CLIENT.build();
    static final ForgeConfigSpec SPEC_COMMON = BUILDER_COMMON.build();

    @SubscribeEvent
    public static void onReLoad(ModConfigEvent.Reloading event) {
        ModConfig config = event.getConfig();
        if (config.getType() == ModConfig.Type.CLIENT) {
            Configuration.sync();
        }
    }

    public static void sync() {
        if (NetworkHandler.isLoaded()) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().execute(() -> {
                try {
                    NetworkHandler.sendToServer((PacketBase)PacketPlayerConfig.sync((ResourceLocation)Values.CONFIGKEY_SELECT, (int)((Menu_General.PlatformSelect)((Object)((Object)((Object)((Object)Configuration.GENERAL.platformSelect.get()))))).ordinal()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
        }
    }

    public static class Menu_General {
        public ForgeConfigSpec.EnumValue<PlatformSelect> platformSelect;
        public ForgeConfigSpec.EnumValue<ClimbMode> frameClimbMode;

        Menu_General(ForgeConfigSpec.Builder client_builder, ForgeConfigSpec.Builder common_builder) {
            this.platformSelect = client_builder.comment(new String[]{"Changes what sneak right-clicking on a platform with a wrench will do", "GUI: opens the platform selector GUI", "CYCLE: cycles through the options", "MIXED: uses the GUI if the is more then 5 options"}).defineEnum("Selection Mode", (Enum)PlatformSelect.MIXED);
            this.frameClimbMode = common_builder.comment(new String[]{"Sets Frame climbing behaviour", "NONE: Can not be climbed", "LADDER: Ascend via walking. Descends automatically. Sneak holds position.", "SCAFFOLD: Ascend via jumping. Descend via sneaking. Automatically holds position.", "HYBRID: Ascend via walking. Descend via sneaking. Automatically holds position."}).defineEnum("frameClimbMode", (Enum)ClimbMode.HYBRID);
        }

        public static enum PlatformSelect {
            GUI,
            CYCLE,
            MIXED;

        }

        public static enum ClimbMode {
            NONE,
            LADDER,
            SCAFFOLD,
            HYBRID;


            public boolean sneakDescend() {
                return this == SCAFFOLD || this == HYBRID;
            }
        }
    }

    public static class Menu_GUI {
        public ForgeConfigSpec.EnumValue<STYLE> platformer;
        public ForgeConfigSpec.EnumValue<STYLE> wrench;

        Menu_GUI(ForgeConfigSpec.Builder builder) {
            builder.comment("Select A GUI Style").push("gui_style");
            this.platformer = builder.defineEnum("PlatFormer", (Enum)STYLE.DEFAULT);
            this.wrench = builder.defineEnum("Platform Select", (Enum)STYLE.DEFAULT);
            builder.pop();
        }

        public static enum STYLE {
            DEFAULT,
            VANILLA;

        }
    }

    public static class Crafting {
        public ForgeConfigSpec.IntValue compressedMultiplier;
        public ForgeConfigSpec.IntValue baseFlat;
        public ForgeConfigSpec.IntValue baseFloor;
        public ForgeConfigSpec.IntValue baseFrame;
        public ForgeConfigSpec.IntValue baseInclines;
        public ForgeConfigSpec.IntValue baseRoofs;
        public ForgeConfigSpec.IntValue baseRailings;

        Crafting(ForgeConfigSpec.Builder builder) {
            builder.comment("Craft Output Control").push("crafting");
            this.compressedMultiplier = builder.comment(new String[]{"Multiplies the craft amount by the given value if a 'compressed' block is used (2x value if two are used)", "See 'data/forge/tags/items/storage_blocks/' to know what qualifies", "Note: Final value will be capped at a full stack"}).defineInRange("'Compressed' Block Multiplier", 4, 1, 16);
            this.baseFlat = builder.defineInRange("Flat", 4, 1, 16);
            this.baseFloor = builder.defineInRange("Floor", 2, 1, 16);
            this.baseInclines = builder.defineInRange("Inclines", 2, 1, 16);
            this.baseRoofs = builder.defineInRange("Roofs", 2, 1, 16);
            this.baseFrame = builder.defineInRange("Frame", 2, 1, 16);
            this.baseRailings = builder.defineInRange("Railings", 4, 1, 16);
            builder.pop();
        }
    }

    public static class DustCovering {
        public ForgeConfigSpec.BooleanValue canManuallyAdd;
        public ForgeConfigSpec.BooleanValue isEnvironmentReactive;
        public ForgeConfigSpec.BooleanValue isEntityReactive;
        public ForgeConfigSpec.IntValue chanceSand;
        public ForgeConfigSpec.IntValue chanceSandStorm;
        public ForgeConfigSpec.IntValue chanceSnow;
        public ForgeConfigSpec.IntValue chanceRainWash;

        DustCovering(ForgeConfigSpec.Builder builder) {
            builder.comment("Platform Dust Covering Options").push("covering");
            this.canManuallyAdd = builder.comment(new String[]{"Enables the manual placement of sand, snow, and gravel via sneak place", "Other blocks are supported as long as the extend FallingBlock and use Material.SAND"}).define("canManuallyAdd", true);
            this.isEnvironmentReactive = builder.comment("When enabled the amount of snow/sand built up on platforms will change with the weather").define("isEnvironmentReactive", true);
            this.isEntityReactive = builder.comment(new String[]{"When enabled walking on platforms will disturb the collected snow/sand", "Regardless of setting you can still remove layers by right clicking with a shovel"}).define("isEntityReactive", true);
            this.chanceSand = builder.comment(new String[]{"1 in x chance sand will passively accumulate", "Disabled when set to zero, or when 'isEnvironmentReactive' is disabled"}).defineInRange("chanceSand", 4, 0, 1000);
            this.chanceSandStorm = builder.comment(new String[]{"1 in x chance sand will accumulate during a storm", "Disabled when set to zero, or when 'isEnvironmentReactive' is disabled"}).defineInRange("chanceSandStorm", 3, 0, 1000);
            this.chanceSnow = builder.comment(new String[]{"1 in x chance snow will accumulate while snowing", "Disabled when set to zero, or when 'isEnvironmentReactive' is disabled"}).defineInRange("chanceSnowStorm", 3, 0, 1000);
            this.chanceRainWash = builder.comment(new String[]{"1 in x chance rain will wash away dust layers", "Disabled when set to zero, or when 'isEnvironmentReactive' is disabled"}).defineInRange("chanceRainWash", 3, 0, 1000);
            builder.pop();
        }
    }
}

