/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.Function;
import shetiphian.platforms.common.block.BlockPlatformType;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class BlockPlatformRamp
extends BlockPlatformType.Inclines {
    public BlockPlatformRamp() {
        super(EnumPlatformType.RAMP);
    }

    @Override
    protected VoxelShape buildShape(EnumSubType subType, Direction direction, EnumPlatformType railType, String linked, boolean collision) {
        if (!HITBOXES.isEmpty()) {
            VoxelShape[] parts = new VoxelShape[2];
            String base = subType.getBaseType() == EnumSubType.EnumBase.NORMAL ? "normal" : subType.getStyleName();
            parts[0] = (VoxelShape)HITBOXES.get((Object)("ramp_" + base + (collision ? "_collide" : "_select")), (Object)direction);
            if (railType != null) {
                parts[1] = this.getRailingBox(subType.getStyleType(), railType, collision, direction);
            }
            return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])((VoxelShape[])Arrays.stream(parts).filter(Objects::nonNull).toArray(VoxelShape[]::new)));
        }
        return null;
    }

    @Override
    protected void updateBlock(TileEntityPlatformBase tile, BlockState state, Level world, BlockPos pos) {
        int altSupport = this.getSupports(world, pos);
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        TileHelper.setAltSupport((BlockEntity)tile, altSupport += this.connectsTo(state, world, pos, direction) || BlockPlatformRamp.getPlatformSubType(state).getBaseType() == EnumSubType.EnumBase.CORNER && this.connectsTo(state, world, pos, direction.m_122427_()) ? 3 : 0);
        Function.syncTile((BlockEntity)tile);
    }

    private boolean connectsTo(BlockState state, Level world, BlockPos pos, Direction direction) {
        BlockPos posForward = pos.m_121945_(direction);
        BlockState stateForward = world.m_8055_(posForward);
        if (stateForward.m_60734_() != state.m_60734_() && !stateForward.m_247087_()) {
            AABB aabbForward = this.getShapeBoundingBox(stateForward.m_60808_((BlockGetter)world, posForward));
            AABB aabb = this.getShapeBoundingBox(state.m_60808_((BlockGetter)world, pos));
            return aabb != null && aabbForward != null && aabb.m_82338_(pos).m_82381_(aabbForward.m_82338_(posForward).m_82400_(0.1));
        }
        return false;
    }

    static {
        BlockPlatformRamp.addHitBoxData("ramp_normal_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 2.0, 16.0}, {0.0, 2.0, 0.0, 16.0, 4.0, 14.0}, {0.0, 4.0, 0.0, 16.0, 6.0, 12.0}, {0.0, 6.0, 0.0, 16.0, 8.0, 10.0}, {0.0, 8.0, 0.0, 16.0, 10.0, 8.0}, {0.0, 10.0, 0.0, 16.0, 12.0, 6.0}, {0.0, 12.0, 0.0, 16.0, 14.0, 4.0}, {0.0, 14.0, 0.0, 16.0, 16.0, 2.0}});
        BlockPlatformRamp.addHitBoxData("ramp_normal_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 2.0, 16.0}, {0.0, 2.0, 0.0, 16.0, 4.0, 14.0}, {0.0, 4.0, 0.0, 16.0, 6.0, 12.0}, {0.0, 6.0, 0.0, 16.0, 8.0, 10.0}, {0.0, 8.0, 0.0, 16.0, 10.0, 8.0}, {0.0, 10.0, 0.0, 16.0, 12.0, 6.0}, {0.0, 12.0, 0.0, 16.0, 14.0, 4.0}, {0.0, 14.0, 0.0, 16.0, 16.0, 2.0}});
        BlockPlatformRamp.addHitBoxData("ramp_inside_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 2.0, 16.0}, {0.0, 2.0, 0.0, 16.0, 4.0, 14.0}, {2.0, 2.0, 14.0, 16.0, 4.0, 16.0}, {0.0, 4.0, 0.0, 16.0, 6.0, 12.0}, {4.0, 4.0, 12.0, 16.0, 6.0, 16.0}, {0.0, 6.0, 0.0, 16.0, 8.0, 10.0}, {6.0, 6.0, 10.0, 16.0, 8.0, 16.0}, {0.0, 8.0, 0.0, 16.0, 10.0, 8.0}, {8.0, 8.0, 8.0, 16.0, 10.0, 16.0}, {0.0, 10.0, 0.0, 16.0, 12.0, 6.0}, {10.0, 10.0, 6.0, 16.0, 12.0, 16.0}, {0.0, 12.0, 0.0, 16.0, 14.0, 4.0}, {12.0, 12.0, 4.0, 16.0, 14.0, 16.0}, {0.0, 14.0, 0.0, 16.0, 16.0, 2.0}, {14.0, 14.0, 2.0, 16.0, 16.0, 16.0}});
        BlockPlatformRamp.addHitBoxData("ramp_inside_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 2.0, 16.0}, {0.0, 2.0, 0.0, 16.0, 4.0, 14.0}, {2.0, 2.0, 14.0, 16.0, 4.0, 16.0}, {0.0, 4.0, 0.0, 16.0, 6.0, 12.0}, {4.0, 4.0, 12.0, 16.0, 6.0, 16.0}, {0.0, 6.0, 0.0, 16.0, 8.0, 10.0}, {6.0, 6.0, 10.0, 16.0, 8.0, 16.0}, {0.0, 8.0, 0.0, 16.0, 10.0, 8.0}, {8.0, 8.0, 8.0, 16.0, 10.0, 16.0}, {0.0, 10.0, 0.0, 16.0, 12.0, 6.0}, {10.0, 10.0, 6.0, 16.0, 12.0, 16.0}, {0.0, 12.0, 0.0, 16.0, 14.0, 4.0}, {12.0, 12.0, 4.0, 16.0, 14.0, 16.0}, {0.0, 14.0, 0.0, 16.0, 16.0, 2.0}, {14.0, 14.0, 2.0, 16.0, 16.0, 16.0}});
        BlockPlatformRamp.addHitBoxData("ramp_outside_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 2.0, 16.0}, {2.0, 2.0, 0.0, 16.0, 4.0, 14.0}, {4.0, 4.0, 0.0, 16.0, 6.0, 12.0}, {6.0, 6.0, 0.0, 16.0, 8.0, 10.0}, {8.0, 8.0, 0.0, 16.0, 10.0, 8.0}, {10.0, 10.0, 0.0, 16.0, 12.0, 6.0}, {12.0, 12.0, 0.0, 16.0, 14.0, 4.0}, {14.0, 14.0, 0.0, 16.0, 16.0, 2.0}});
        BlockPlatformRamp.addHitBoxData("ramp_outside_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 2.0, 16.0}, {2.0, 2.0, 0.0, 16.0, 4.0, 14.0}, {4.0, 4.0, 0.0, 16.0, 6.0, 12.0}, {6.0, 6.0, 0.0, 16.0, 8.0, 10.0}, {8.0, 8.0, 0.0, 16.0, 10.0, 8.0}, {10.0, 10.0, 0.0, 16.0, 12.0, 6.0}, {12.0, 12.0, 0.0, 16.0, 14.0, 4.0}, {14.0, 14.0, 0.0, 16.0, 16.0, 2.0}});
    }
}

