/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.core.common.BlockLightingHelper;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFloor;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFrame;
import shetiphian.platforms.common.tileentity.TileEntityPlatformIncline;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRoof;

public class TileHelper {
    public static TileEntityPlatformBase getPlatformTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileEntityPlatformBase ? (TileEntityPlatformBase)tile : null;
    }

    public static boolean hasRail(TileEntityPlatformBase tile) {
        return tile != null && tile.hasRail();
    }

    public static EnumPlatformType getRail(TileEntityPlatformBase tile) {
        ItemStack rail;
        if (TileHelper.hasRail(tile) && !(rail = tile.getRailItem()).m_41619_() && rail.m_41720_() instanceof ItemBlockPlatform) {
            return ((ItemBlockPlatform)rail.m_41720_()).getPlatformType();
        }
        return null;
    }

    public static boolean setRail(TileEntityPlatformBase tile, ItemStack stack) {
        if (!stack.m_41619_()) {
            return tile.setRailItem(stack);
        }
        return false;
    }

    public static boolean removeRail(TileEntityPlatformBase tile) {
        if (TileHelper.hasRail(tile)) {
            tile.removeRail();
            return true;
        }
        return false;
    }

    public static boolean hasTorch(TileEntityPlatformBase tile) {
        return tile instanceof TileEntityPlatformFrame && ((TileEntityPlatformFrame)tile).getTorch() != EnumTorchType.NONE;
    }

    public static EnumTorchType getTorch(TileEntityPlatformBase tile) {
        return tile instanceof TileEntityPlatformFrame ? ((TileEntityPlatformFrame)tile).getTorch() : null;
    }

    public static boolean setTorch(TileEntityPlatformBase tile, EnumTorchType torchType) {
        return tile instanceof TileEntityPlatformFrame && ((TileEntityPlatformFrame)tile).setTorch(torchType);
    }

    public static boolean removeTorch(TileEntityPlatformBase tile) {
        if (TileHelper.hasTorch(tile)) {
            ((TileEntityPlatformFrame)tile).removeTorch();
            return true;
        }
        return false;
    }

    public static byte getAltSupport(BlockEntity tile) {
        if (tile instanceof TileEntityPlatformIncline) {
            return ((TileEntityPlatformIncline)tile).getSupport();
        }
        if (tile instanceof TileEntityPlatformFloor) {
            return ((TileEntityPlatformFloor)tile).getSupport();
        }
        return 0;
    }

    public static void setAltSupport(BlockEntity tile, int altSupport) {
        if (tile instanceof TileEntityPlatformIncline) {
            ((TileEntityPlatformIncline)tile).setSupport(altSupport);
        } else if (tile instanceof TileEntityPlatformFloor) {
            ((TileEntityPlatformFloor)tile).setSupport(altSupport);
        } else if (tile instanceof TileEntityPlatformRoof) {
            ((TileEntityPlatformRoof)tile).setSupport(altSupport);
        }
    }

    public static Optional<Boolean> isTranslucent(TileEntityPlatformBase tile) {
        if (tile != null) {
            boolean isRoof = tile instanceof TileEntityPlatformRoof;
            return TileHelper.isTranslucent(tile.getCoverTextureBlock(), isRoof ? ItemStack.f_41583_ : tile.getFrameTextureBlock());
        }
        return Optional.empty();
    }

    public static Optional<Boolean> isTranslucent(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemBlockPlatform) {
            boolean isRoof = ((ItemBlockPlatform)stack.m_41720_()).getPlatformType().isRoof();
            return TileHelper.isTranslucent(ItemBlockPlatform.getCoverTextureStack(stack), isRoof ? ItemStack.f_41583_ : ItemBlockPlatform.getFrameTextureStack(stack));
        }
        return Optional.empty();
    }

    private static Optional<Boolean> isTranslucent(ItemStack itemBaseCover, ItemStack itemBaseFrame) {
        if (!itemBaseCover.m_41619_()) {
            if (BlockLightingHelper.isTransmissive((ItemStack)itemBaseCover)) {
                if (itemBaseFrame.m_41619_()) {
                    return Optional.of(true);
                }
                return Optional.of(BlockLightingHelper.isTransmissive((ItemStack)itemBaseFrame));
            }
            return Optional.of(false);
        }
        return Optional.empty();
    }

    public static int getLightValue(TileEntityPlatformBase tile) {
        if (tile != null) {
            int value = TileHelper.getMax(tile.getCoverTextureBlock(), tile.getFrameTextureBlock(), tile.getRailCoverTextureBlock(), tile.getRailFrameTextureBlock(), tile.getCoveringStack());
            return tile instanceof TileEntityPlatformFrame ? Math.max(value, ((TileEntityPlatformFrame)tile).getLightValue()) : value;
        }
        return 0;
    }

    public static int getLightValue(ItemStack stack) {
        if (!stack.m_41619_()) {
            if (stack.m_41720_() instanceof ItemBlockPlatform) {
                return TileHelper.getMax(ItemBlockPlatform.getCoverTextureStack(stack), ItemBlockPlatform.getFrameTextureStack(stack));
            }
            return Mth.m_14045_((int)BlockLightingHelper.getLuminosity((ItemStack)stack), (int)0, (int)15);
        }
        return 0;
    }

    private static int getMax(ItemStack ... stacks) {
        int value = 0;
        for (ItemStack stack : stacks) {
            if ((value = Math.max(value, BlockLightingHelper.getLuminosity((ItemStack)stack))) < 15) continue;
            return 15;
        }
        return value;
    }
}

