/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmerrymaking.blocks;

import com.maideniles.maidensmerrymaking.blocks.deco.HorizontalDecoBlock;
import com.maideniles.maidensmerrymaking.config.MerryMakingCommonConfig;
import com.maideniles.maidensmerrymaking.entity.halloween.DrownedCostumeEntity;
import com.maideniles.maidensmerrymaking.entity.halloween.HuskCostumeEntity;
import com.maideniles.maidensmerrymaking.entity.halloween.SkeletonCostumeEntity;
import com.maideniles.maidensmerrymaking.entity.halloween.ZombieCostumeEntity;
import com.maideniles.maidensmerrymaking.init.ModEntityTypes;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GravestoneBlock
extends HorizontalDecoBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public GravestoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_48946_, BlockPos p_48947_, CollisionContext p_48948_) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_13065_);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState p_49849_, @Nullable LivingEntity p_49850_, ItemStack p_49851_) {
        Random rand = new Random();
        Integer undead_id = rand.nextInt(4);
        if (level instanceof ServerLevel) {
            if (((Boolean)MerryMakingCommonConfig.COSTUMES_ENABLED.get()).booleanValue()) {
                if (undead_id == 0) {
                    GravestoneBlock.spawnCostumedZombie((ServerLevel)level, pos);
                }
                if (undead_id == 1) {
                    GravestoneBlock.spawnCostumedDrowned((ServerLevel)level, pos);
                }
                if (undead_id == 2) {
                    GravestoneBlock.spawnCostumedHusk((ServerLevel)level, pos);
                }
                if (undead_id == 3) {
                    GravestoneBlock.spawnCostumedSkeleton((ServerLevel)level, pos);
                }
            } else {
                if (undead_id == 0) {
                    GravestoneBlock.spawnZombie((ServerLevel)level, pos);
                }
                if (undead_id == 1) {
                    GravestoneBlock.spawnDrowned((ServerLevel)level, pos);
                }
                if (undead_id == 2) {
                    GravestoneBlock.spawnHusk((ServerLevel)level, pos);
                }
                if (undead_id == 3) {
                    GravestoneBlock.spawnSkeleton((ServerLevel)level, pos);
                }
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState p_49854_, Player p_49855_) {
        Random rand = new Random();
        Integer undead_id = rand.nextInt(4);
        if (level instanceof ServerLevel) {
            if (((Boolean)MerryMakingCommonConfig.COSTUMES_ENABLED.get()).booleanValue()) {
                if (undead_id == 0) {
                    GravestoneBlock.spawnCostumedZombie((ServerLevel)level, pos);
                }
                if (undead_id == 1) {
                    GravestoneBlock.spawnCostumedDrowned((ServerLevel)level, pos);
                }
                if (undead_id == 2) {
                    GravestoneBlock.spawnCostumedHusk((ServerLevel)level, pos);
                }
                if (undead_id == 3) {
                    GravestoneBlock.spawnCostumedSkeleton((ServerLevel)level, pos);
                }
            } else {
                if (undead_id == 0) {
                    GravestoneBlock.spawnZombie((ServerLevel)level, pos);
                }
                if (undead_id == 1) {
                    GravestoneBlock.spawnDrowned((ServerLevel)level, pos);
                }
                if (undead_id == 2) {
                    GravestoneBlock.spawnHusk((ServerLevel)level, pos);
                }
                if (undead_id == 3) {
                    GravestoneBlock.spawnSkeleton((ServerLevel)level, pos);
                }
            }
        }
    }

    private static void spawnZombie(ServerLevel p_54181_, BlockPos p_54182_) {
        Zombie zombie = (Zombie)EntityType.f_20501_.m_20615_((Level)p_54181_);
        if (zombie != null) {
            p_54181_.m_7967_((Entity)zombie);
            zombie.m_7678_((double)p_54182_.m_123341_() + 1.0, (double)p_54182_.m_123342_(), (double)p_54182_.m_123343_() + 1.0, 0.0f, 0.0f);
            zombie.m_21373_();
        }
    }

    private static void spawnHusk(ServerLevel p_54181_, BlockPos p_54182_) {
        Zombie zombie = (Zombie)EntityType.f_20458_.m_20615_((Level)p_54181_);
        if (zombie != null) {
            p_54181_.m_7967_((Entity)zombie);
            zombie.m_7678_((double)p_54182_.m_123341_() + 1.0, (double)p_54182_.m_123342_(), (double)p_54182_.m_123343_() + 1.0, 0.0f, 0.0f);
            zombie.m_21373_();
        }
    }

    private static void spawnDrowned(ServerLevel p_54181_, BlockPos p_54182_) {
        Zombie zombie = (Zombie)EntityType.f_20562_.m_20615_((Level)p_54181_);
        if (zombie != null) {
            p_54181_.m_7967_((Entity)zombie);
            zombie.m_7678_((double)p_54182_.m_123341_() + 1.0, (double)p_54182_.m_123342_(), (double)p_54182_.m_123343_() + 1.0, 0.0f, 0.0f);
            zombie.m_21373_();
        }
    }

    private static void spawnSkeleton(ServerLevel p_54181_, BlockPos p_54182_) {
        Skeleton skele = (Skeleton)EntityType.f_20524_.m_20615_((Level)p_54181_);
        if (skele != null) {
            p_54181_.m_7967_((Entity)skele);
            skele.m_7678_((double)p_54182_.m_123341_() + 1.0, (double)p_54182_.m_123342_(), (double)p_54182_.m_123343_() + 1.0, 0.0f, 0.0f);
            skele.m_21373_();
        }
    }

    private static void spawnCostumedZombie(ServerLevel p_54181_, BlockPos p_54182_) {
        ZombieCostumeEntity zombie = (ZombieCostumeEntity)((EntityType)ModEntityTypes.COSTUMED_ZOMBIE.get()).m_20615_((Level)p_54181_);
        if (zombie != null) {
            p_54181_.m_7967_((Entity)zombie);
            zombie.m_7678_((double)p_54182_.m_123341_() + 1.0, p_54182_.m_123342_(), (double)p_54182_.m_123343_() + 1.0, 0.0f, 0.0f);
            zombie.m_21373_();
        }
    }

    private static void spawnCostumedDrowned(ServerLevel p_54181_, BlockPos p_54182_) {
        Random rand = new Random();
        int rng = rand.nextInt(2);
        DrownedCostumeEntity zombie = null;
        if (rng == 0) {
            zombie = (DrownedCostumeEntity)((EntityType)ModEntityTypes.COSTUMED_DROWNED.get()).m_20615_((Level)p_54181_);
        } else if (rng == 1) {
            zombie = (DrownedCostumeEntity)((EntityType)ModEntityTypes.COSTUMED_DROWNED_MERMAID.get()).m_20615_((Level)p_54181_);
        }
        if (zombie != null) {
            p_54181_.m_7967_((Entity)zombie);
            zombie.m_7678_((double)p_54182_.m_123341_() + 1.0, p_54182_.m_123342_(), (double)p_54182_.m_123343_() + 1.0, 0.0f, 0.0f);
            zombie.m_21373_();
        }
    }

    private static void spawnCostumedHusk(ServerLevel p_54181_, BlockPos p_54182_) {
        HuskCostumeEntity zombie = (HuskCostumeEntity)((EntityType)ModEntityTypes.COSTUMED_HUSK.get()).m_20615_((Level)p_54181_);
        if (zombie != null) {
            p_54181_.m_7967_((Entity)zombie);
            zombie.m_7678_((double)p_54182_.m_123341_() + 1.0, p_54182_.m_123342_(), (double)p_54182_.m_123343_() + 1.0, 0.0f, 0.0f);
            zombie.m_21373_();
        }
    }

    private static void spawnCostumedSkeleton(ServerLevel p_54181_, BlockPos p_54182_) {
        SkeletonCostumeEntity skele = (SkeletonCostumeEntity)((EntityType)ModEntityTypes.COSTUMED_SKELETON.get()).m_20615_((Level)p_54181_);
        if (skele != null) {
            p_54181_.m_7967_((Entity)skele);
            skele.m_7678_((double)p_54182_.m_123341_() + 1.0, p_54182_.m_123342_(), (double)p_54182_.m_123343_() + 1.0, 0.0f, 0.0f);
            skele.m_21373_();
        }
    }
}

