/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmerrymaking.entity;

import com.maideniles.maidensmerrymaking.entity.variant.PastelRabbitVariant;
import com.maideniles.maidensmerrymaking.init.RabbitRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PastelRabbitEntity
extends TamableAnimal
implements GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final double STROLL_SPEED_MOD = 0.6;
    public static final double BREED_SPEED_MOD = 0.8;
    public static final double FOLLOW_SPEED_MOD = 1.0;
    public static final double FLEE_SPEED_MOD = 2.2;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int jumpDelayTicks;
    int moreCarrotTicks;
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(PastelRabbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(PastelRabbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_, Items.f_42677_});

    public PastelRabbitEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21343_ = new PastelRabbitJumpControl(this);
        this.f_21342_ = new PastelRabbitMoveControl(this);
        this.setSpeedModifier(0.0);
    }

    @NotNull
    public LookControl m_21563_() {
        return this.f_21365_;
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new PastelRabbitPanicGoal(this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public void setSpeedModifier(double p_29726_) {
        this.m_21573_().m_26517_(p_29726_);
        this.f_21342_.m_6849_(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_(), p_29726_);
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_12354_;
    }

    protected float m_6118_() {
        if (!(this.f_19862_ || this.f_21342_.m_24995_() && this.f_21342_.m_25001_() > this.m_20186_() + 0.5)) {
            Path path = this.f_21344_.m_26570_();
            if (path != null && !path.m_77392_()) {
                Vec3 vec3 = path.m_77380_((Entity)this);
                if (vec3.f_82480_ > this.m_20186_() + 0.5) {
                    return 0.5f;
                }
            }
            return this.f_21342_.m_24999_() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    protected void m_6135_() {
        double d1;
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)1);
        }
    }

    public float getJumpCompletion(float p_29736_) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + p_29736_) / (float)this.jumpDuration;
    }

    public void m_6862_(boolean p_29732_) {
        super.m_6862_(p_29732_);
        if (p_29732_) {
            this.m_5496_(this.getJumpSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.m_6862_(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void m_8024_() {
        if (this.jumpDelayTicks > 0) {
            --this.jumpDelayTicks;
        }
        if (this.moreCarrotTicks > 0) {
            this.moreCarrotTicks -= this.f_19796_.m_188503_(3);
            if (this.moreCarrotTicks < 0) {
                this.moreCarrotTicks = 0;
            }
        }
        if (this.m_20096_()) {
            PastelRabbitJumpControl rabbit$rabbitjumpcontrol;
            if (!this.wasOnGround) {
                this.m_6862_(false);
                this.checkLandingDelay();
            }
            if (!(rabbit$rabbitjumpcontrol = (PastelRabbitJumpControl)this.f_21343_).wantJump()) {
                if (this.f_21342_.m_24995_() && this.jumpDelayTicks == 0) {
                    Path path = this.f_21344_.m_26570_();
                    Vec3 vec3 = new Vec3(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_());
                    if (path != null && !path.m_77392_()) {
                        vec3 = path.m_77380_((Entity)this);
                    }
                    this.facePoint(vec3.f_82479_, vec3.f_82481_);
                    this.startJumping();
                }
            } else if (!rabbit$rabbitjumpcontrol.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.m_20096_();
    }

    public boolean m_5843_() {
        return false;
    }

    private void facePoint(double p_29687_, double p_29688_) {
        this.m_146922_((float)(Mth.m_14136_((double)(p_29688_ - this.m_20189_()), (double)(p_29687_ - this.m_20185_())) * 57.2957763671875) - 90.0f);
    }

    private void enableJumpControl() {
        ((PastelRabbitJumpControl)this.f_21343_).setCanJump(true);
    }

    private void disableJumpControl() {
        ((PastelRabbitJumpControl)this.f_21343_).setCanJump(false);
    }

    private void setLandingDelay() {
        this.jumpDelayTicks = this.f_21342_.m_24999_() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.setLandingDelay();
        this.disableJumpControl();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.m_6862_(false);
        }
    }

    public void m_7822_(byte p_29663_) {
        if (p_29663_ == 1) {
            this.m_20076_();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.m_7822_(p_29663_);
        }
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_41720_() == Items.f_42677_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{DefaultAnimations.genericWalkRunIdleController((Entity)this)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("move.walk", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12354_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12297_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12353_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12352_;
    }

    protected float m_6121_() {
        return 0.2f;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        Item itemForTaming = Items.f_42619_;
        if (this.m_6898_(itemstack)) {
            return super.m_6071_(player, hand);
        }
        if (item == itemForTaming && !this.m_21824_()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(10) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player) && !this.m_9236_().f_46443_) {
                super.m_21828_(player);
                this.f_21344_.m_26569_();
                this.m_6710_(null);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                this.setSitting(true);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && !this.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND) {
            this.setSitting(!this.isSitting());
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() == itemForTaming) {
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSitting(tag.m_128471_("isSitting"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("isSitting", this.isSitting());
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        this.m_21839_(sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public Team m_5647_() {
        return super.m_5647_();
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(60.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.5);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        PastelRabbitVariant variant = (PastelRabbitVariant)((Object)Util.m_214670_((Object[])PastelRabbitVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob p_146744_) {
        PastelRabbitEntity baby = (PastelRabbitEntity)((EntityType)RabbitRegistry.BUNNY.get()).m_20615_((Level)serverLevel);
        PastelRabbitVariant variant = (PastelRabbitVariant)((Object)Util.m_214670_((Object[])PastelRabbitVariant.values(), (RandomSource)this.f_19796_));
        baby.setVariant(variant);
        return baby;
    }

    public PastelRabbitVariant getVariant() {
        return PastelRabbitVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(PastelRabbitVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public static class PastelRabbitJumpControl
    extends JumpControl {
        private final PastelRabbitEntity rabbit;
        private boolean canJump;

        public PastelRabbitJumpControl(PastelRabbitEntity p_186229_) {
            super((Mob)p_186229_);
            this.rabbit = p_186229_;
        }

        public boolean wantJump() {
            return this.f_24897_;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean p_29759_) {
            this.canJump = p_29759_;
        }

        public void m_8124_() {
            if (this.f_24897_) {
                this.rabbit.startJumping();
                this.f_24897_ = false;
            }
        }
    }

    static class PastelRabbitMoveControl
    extends MoveControl {
        private final PastelRabbitEntity rabbit;
        private double nextJumpSpeed;

        public PastelRabbitMoveControl(PastelRabbitEntity p_29766_) {
            super((Mob)p_29766_);
            this.rabbit = p_29766_;
        }

        public void m_8126_() {
            if (this.rabbit.m_20096_() && !this.rabbit.f_20899_ && !((PastelRabbitJumpControl)this.rabbit.f_21343_).wantJump()) {
                this.rabbit.setSpeedModifier(0.0);
            } else if (this.m_24995_()) {
                this.rabbit.setSpeedModifier(this.nextJumpSpeed);
            }
            super.m_8126_();
        }

        public void m_6849_(double p_29769_, double p_29770_, double p_29771_, double p_29772_) {
            if (this.rabbit.m_20069_()) {
                p_29772_ = 1.5;
            }
            super.m_6849_(p_29769_, p_29770_, p_29771_, p_29772_);
            if (p_29772_ > 0.0) {
                this.nextJumpSpeed = p_29772_;
            }
        }
    }

    static class PastelRabbitPanicGoal
    extends PanicGoal {
        private final PastelRabbitEntity rabbit;

        public PastelRabbitPanicGoal(PastelRabbitEntity p_29775_, double p_29776_) {
            super((PathfinderMob)p_29775_, p_29776_);
            this.rabbit = p_29775_;
        }

        public void m_8037_() {
            this.f_25684_.m_21573_().m_26519_(this.f_25686_, this.f_25687_, this.f_25688_, (double)2.2f);
            this.rabbit.setSpeedModifier(2.2f);
        }
    }
}

