/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.common.recipes;

import com.github.jarva.allthearcanistgear.AllTheArcanistGear;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class PerkTierIngredient
extends AbstractIngredient {
    public static final Serializer INSTANCE = new Serializer();
    private final int minLevel;
    private final TagKey<Item> tag;
    public static final MapCodec<PerkTierIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.m_203877_((ResourceKey)Registries.f_256913_).fieldOf("tag").forGetter(e -> e.tag), (App)Codec.INT.fieldOf("min_level").forGetter(e -> e.minLevel)).apply((Applicative)instance, PerkTierIngredient::new));

    public PerkTierIngredient(TagKey<Item> tag, int level) {
        this.tag = tag;
        this.minLevel = level;
    }

    public boolean test(ItemStack itemStack) {
        if (!itemStack.m_204117_(this.tag)) {
            return false;
        }
        IPerkHolder data = PerkUtil.getPerkHolder((ItemStack)itemStack);
        if (data instanceof ArmorPerkHolder) {
            ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)data;
            return armorPerkHolder.getTier() >= this.minLevel;
        }
        return false;
    }

    public ItemStack[] m_43908_() {
        return (ItemStack[])BuiltInRegistries.f_257033_.m_203561_(this.tag).m_203614_().map(ItemStack::new).map(is -> {
            IPerkHolder data = PerkUtil.getPerkHolder((ItemStack)is);
            if (data instanceof ArmorPerkHolder) {
                ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)data;
                armorPerkHolder.setTier(this.minLevel);
                return is;
            }
            return null;
        }).filter(Objects::nonNull).toArray(ItemStack[]::new);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = ((JsonElement)CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().get()).getAsJsonObject();
        json.addProperty("type", AllTheArcanistGear.prefix("perk_tier").toString());
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<PerkTierIngredient> {
        public PerkTierIngredient parse(FriendlyByteBuf arg) {
            return (PerkTierIngredient)((Object)arg.m_271872_(CODEC.codec()));
        }

        public PerkTierIngredient parse(JsonObject jsonObject) {
            return (PerkTierIngredient)((Object)CODEC.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().get());
        }

        public void write(FriendlyByteBuf arg, PerkTierIngredient arg2) {
            arg.m_272073_(CODEC.codec(), (Object)arg2);
        }
    }
}

