/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.datagen;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ConditionalRecipeOutput
implements Consumer<FinishedRecipe> {
    private final Consumer<FinishedRecipe> consumer;
    private final List<ICondition> conditions;

    public ConditionalRecipeOutput(Consumer<FinishedRecipe> consumer) {
        this.consumer = consumer;
        this.conditions = new ArrayList<ICondition>();
    }

    public ConditionalRecipeOutput(Consumer<FinishedRecipe> consumer, List<ICondition> conditions) {
        this.consumer = consumer;
        this.conditions = conditions;
    }

    public ConditionalRecipeOutput withCondition(ICondition condition) {
        ArrayList<ICondition> conditions = new ArrayList<ICondition>(this.conditions);
        conditions.add(condition);
        return new ConditionalRecipeOutput(this.consumer, conditions);
    }

    @Override
    public void accept(FinishedRecipe finishedRecipe) {
        if (!this.conditions.isEmpty()) {
            ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
            for (ICondition condition : this.conditions) {
                builder = builder.addCondition(condition);
            }
            builder.addRecipe(finishedRecipe).generateAdvancement().build(this.consumer, finishedRecipe.m_6445_());
        } else {
            this.consumer.accept(finishedRecipe);
        }
    }
}

