/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.setup.config;

import com.github.jarva.allthearcanistgear.AllTheArcanistGear;
import com.github.jarva.allthearcanistgear.common.armor.AddonArmorItem;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeConfigSpec;

public record ArmorSetConfig(String name, ForgeConfigSpec.IntValue head, ForgeConfigSpec.IntValue chest, ForgeConfigSpec.IntValue legs, ForgeConfigSpec.IntValue boots, ForgeConfigSpec.IntValue toughness, ForgeConfigSpec.DoubleValue knockback, ForgeConfigSpec.IntValue maxMana, ForgeConfigSpec.DoubleValue manaRegen, ForgeConfigSpec.DoubleValue spellPower, ForgeConfigSpec.BooleanValue preventDrowning, ForgeConfigSpec.BooleanValue preventKinetic, ForgeConfigSpec.BooleanValue preventFire, ForgeConfigSpec.BooleanValue preventDragonsBreath, ForgeConfigSpec.BooleanValue preventWither, ForgeConfigSpec.BooleanValue preventLevitation, ForgeConfigSpec.BooleanValue preventFallDamage) {
    private static final HashMap<EquipmentSlot, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = (HashMap)Util.m_137469_(new HashMap(), map -> {
        map.put(EquipmentSlot.FEET, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        map.put(EquipmentSlot.LEGS, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        map.put(EquipmentSlot.CHEST, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        map.put(EquipmentSlot.HEAD, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });

    public int getDefenseBySlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> (Integer)this.head().get();
            case EquipmentSlot.CHEST -> (Integer)this.chest().get();
            case EquipmentSlot.LEGS -> (Integer)this.legs().get();
            case EquipmentSlot.FEET -> (Integer)this.boots().get();
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(slot));
        };
    }

    public Multimap<Attribute, AttributeModifier> buildAttributeMap(AddonArmorItem item) {
        EquipmentSlot slot = item.m_40402_();
        int defense = this.getDefenseBySlot(slot);
        int toughness = (Integer)this.toughness().get();
        double knockback = (Double)this.knockback().get();
        double maxMana = ((Integer)this.maxMana().get()).intValue();
        double manaRegen = (Double)this.manaRegen().get();
        double spellPower = (Double)this.spellPower().get();
        ResourceLocation modifier = AllTheArcanistGear.prefix("armor." + this.name() + "." + slot.m_20751_());
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        UUID uuid = ARMOR_MODIFIER_UUID_PER_TYPE.get(item.m_40402_());
        if (defense != 0) {
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, modifier.toString(), (double)defense, AttributeModifier.Operation.ADDITION));
        }
        if (toughness != 0) {
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, modifier.toString(), (double)toughness, AttributeModifier.Operation.ADDITION));
        }
        if (knockback != 0.0) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, modifier.toString(), knockback, AttributeModifier.Operation.ADDITION));
        }
        if (maxMana != 0.0) {
            builder.put((Object)((Attribute)PerkAttributes.MAX_MANA.get()), (Object)new AttributeModifier(uuid, modifier.toString(), maxMana, AttributeModifier.Operation.ADDITION));
        }
        if (manaRegen != 0.0) {
            builder.put((Object)((Attribute)PerkAttributes.MANA_REGEN_BONUS.get()), (Object)new AttributeModifier(uuid, modifier.toString(), manaRegen, AttributeModifier.Operation.ADDITION));
        }
        if (spellPower != 0.0) {
            builder.put((Object)((Attribute)PerkAttributes.SPELL_DAMAGE_BONUS.get()), (Object)new AttributeModifier(uuid, modifier.toString(), spellPower, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public static ArmorSetConfig build(ForgeConfigSpec.Builder builder, String name, DefenseValues values, ArcanistStats stats, Capabilities capabilities) {
        String localizedName = name.substring(0, 1).toUpperCase() + name.substring(1);
        builder.push(name);
        builder.define("_comment", (Object)("Config for " + localizedName + " armor"));
        builder.push("armor_values");
        ForgeConfigSpec.IntValue head = builder.worldRestart().comment("Hat").defineInRange("hat", values.head(), 0, Integer.MAX_VALUE);
        ForgeConfigSpec.IntValue chest = builder.worldRestart().comment("Robes").defineInRange("robes", values.chest(), 0, Integer.MAX_VALUE);
        ForgeConfigSpec.IntValue legs = builder.worldRestart().comment("Leggings").defineInRange("leggings", values.legs(), 0, Integer.MAX_VALUE);
        ForgeConfigSpec.IntValue boots = builder.worldRestart().comment("Boots").defineInRange("boots", values.boots(), 0, Integer.MAX_VALUE);
        ForgeConfigSpec.IntValue toughness = builder.worldRestart().comment("Toughness").defineInRange("toughness", values.toughness(), 0, Integer.MAX_VALUE);
        ForgeConfigSpec.DoubleValue knockback = builder.worldRestart().comment("Knockback Resistance").defineInRange("knockback_resistance", values.knockbackResistance(), 0.0, 2.147483647E9);
        builder.pop();
        builder.push("arcanist_stats");
        ForgeConfigSpec.IntValue manaBoost = builder.worldRestart().comment("Max Mana Bonus").defineInRange("mana_boost", stats.manaBoost(), 0, Integer.MAX_VALUE);
        ForgeConfigSpec.DoubleValue manaRegen = builder.worldRestart().comment("Mana Regen Bonus").defineInRange("mana_regen", stats.manaRegen(), 0.0, 2.147483647E9);
        ForgeConfigSpec.DoubleValue spellPower = builder.worldRestart().comment("Spell Power Bonus").defineInRange("spell_power", stats.spellPower(), 0.0, 2.147483647E9);
        builder.pop();
        builder.push("capabilities");
        ForgeConfigSpec.BooleanValue preventDrowning = builder.worldRestart().comment("Should Helmet Prevent Drowning?").define("prevent_drowning", capabilities.preventDrowning());
        ForgeConfigSpec.BooleanValue preventKinetic = builder.worldRestart().comment("Should Helmet Prevent Kinetic Damage?").define("prevent_kinetic", capabilities.preventKinetic());
        ForgeConfigSpec.BooleanValue preventFire = builder.worldRestart().comment("Should Chestplate Prevent Fire Damage?").define("prevent_fire", capabilities.preventFire());
        ForgeConfigSpec.BooleanValue preventDragonsBreath = builder.worldRestart().comment("Should Chestplate Prevent Dragon's Breath Damage?").define("prevent_dragons_breath", capabilities.preventDragonsBreath());
        ForgeConfigSpec.BooleanValue preventWither = builder.worldRestart().comment("Should Leggings Prevent Wither?").define("prevent_wither", capabilities.preventWither());
        ForgeConfigSpec.BooleanValue preventLevitation = builder.worldRestart().comment("Should Leggings Prevent Levitation?").define("prevent_levitation", capabilities.preventLevitation());
        ForgeConfigSpec.BooleanValue preventFallDamage = builder.worldRestart().comment("Should Boots Prevent Fall Damage?").define("prevent_fall_damage", capabilities.preventFallDamage());
        builder.pop();
        ArmorSetConfig config = new ArmorSetConfig(name, head, chest, legs, boots, toughness, knockback, manaBoost, manaRegen, spellPower, preventDrowning, preventKinetic, preventFire, preventDragonsBreath, preventWither, preventLevitation, preventFallDamage);
        builder.pop();
        return config;
    }

    public record DefenseValues(int head, int chest, int legs, int boots, int toughness, double knockbackResistance) {
    }

    public record ArcanistStats(int manaBoost, double manaRegen, double spellPower) {
    }

    public record Capabilities(boolean preventDrowning, boolean preventKinetic, boolean preventFire, boolean preventDragonsBreath, boolean preventWither, boolean preventLevitation, boolean preventFallDamage) {
    }
}

