/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.common.network.packet.client;

import cofh.core.util.ProxyUtils;
import cofh.lib.common.network.packet.IPacketClient;
import cofh.lib.common.network.packet.PacketBase;
import cofh.redstonearsenal.RedstoneArsenal;
import cofh.redstonearsenal.util.FluxShieldingHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class FluxShieldingPacket
extends PacketBase
implements IPacketClient {
    protected int currCharges;
    protected int maxCharges;

    public FluxShieldingPacket() {
        super(1, RedstoneArsenal.PACKET_HANDLER);
    }

    public void handleClient() {
        if (ProxyUtils.isClient()) {
            FluxShieldingHelper.updateHUD(this.currCharges, this.maxCharges);
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.currCharges);
        buf.writeByte(this.maxCharges);
    }

    public void read(FriendlyByteBuf buf) {
        this.currCharges = buf.readByte();
        this.maxCharges = buf.readByte();
    }

    public static void sendToClient(int currCharges, int maxCharges, ServerPlayer player) {
        FluxShieldingPacket packet = new FluxShieldingPacket();
        packet.currCharges = currCharges;
        packet.maxCharges = maxCharges;
        packet.sendToPlayer(player);
    }

    public static void sendToClient(int[] charges, ServerPlayer player) {
        FluxShieldingPacket.sendToClient(charges[0], charges[1], player);
    }
}

