/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util.tools;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Hashtable;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.command.argument.DungeonModelArgument;
import xiroc.dungeoncrawl.command.argument.ModelBlockDefinitionArgument;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;
import xiroc.dungeoncrawl.dungeon.model.ModelHandler;
import xiroc.dungeoncrawl.util.tools.ModelEditContext;

public class Tools {
    private static final Hashtable<UUID, ModelEditContext> CONTEXT_TABLE = new Hashtable();

    @SubscribeEvent
    public void onServerStart(ServerStartingEvent event) {
        DungeonCrawl.LOGGER.debug("Registering Commands...");
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"savemodel").requires(a -> {
            try {
                return a.m_81375_().m_7500_();
            }
            catch (CommandSyntaxException e) {
                a.m_81352_((Component)Component.m_237113_((String)"You must be a player!"));
                return false;
            }
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(command -> {
            UUID uuid = ((CommandSourceStack)command.getSource()).m_81375_().m_20148_();
            if (!CONTEXT_TABLE.containsKey(uuid)) {
                ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237113_((String)(ChatFormatting.RED + "Please select two positions.")), true);
                return 1;
            }
            ModelEditContext context = CONTEXT_TABLE.get(uuid);
            if (context.arePositionsSet()) {
                String name = StringArgumentType.getString((CommandContext)command, (String)"name");
                BlockPos pos1 = new BlockPos(Math.min(context.pos1.m_123341_(), context.pos2.m_123341_()), Math.min(context.pos1.m_123342_(), context.pos2.m_123342_()), Math.min(context.pos1.m_123343_(), context.pos2.m_123343_()));
                BlockPos pos2 = new BlockPos(Math.max(context.pos1.m_123341_(), context.pos2.m_123341_()), Math.max(context.pos1.m_123342_(), context.pos2.m_123342_()), Math.max(context.pos1.m_123343_(), context.pos2.m_123343_()));
                ModelHandler.readAndSaveModelToFile(name, ModelBlockDefinition.getDefaultDefinition(), ((CommandSourceStack)command.getSource()).m_81375_().m_9236_(), pos1, pos2.m_123341_() - pos1.m_123341_() + 1, pos2.m_123342_() - pos1.m_123342_() + 1, pos2.m_123343_() - pos1.m_123343_() + 1);
                ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237113_((String)("Saved as " + ChatFormatting.GREEN + name + ".nbt")), true);
                return 0;
            }
            ((CommandSourceStack)command.getSource()).m_81352_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Please select two positions.")));
            return 1;
        })).then(Commands.m_82129_((String)"block definition", (ArgumentType)ModelBlockDefinitionArgument.modelBlockDefinitionArgument()).executes(command -> {
            ModelBlockDefinition blockDefinition = ModelBlockDefinitionArgument.getDefinition((CommandContext<CommandSourceStack>)command, "block definition");
            UUID uuid = ((CommandSourceStack)command.getSource()).m_81375_().m_20148_();
            if (!CONTEXT_TABLE.containsKey(uuid)) {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Please select two positions.")));
                return 1;
            }
            ModelEditContext context = CONTEXT_TABLE.get(uuid);
            if (context.arePositionsSet()) {
                BlockPos pos1 = new BlockPos(Math.min(context.pos1.m_123341_(), context.pos2.m_123341_()), Math.min(context.pos1.m_123342_(), context.pos2.m_123342_()), Math.min(context.pos1.m_123343_(), context.pos2.m_123343_()));
                BlockPos pos2 = new BlockPos(Math.max(context.pos1.m_123341_(), context.pos2.m_123341_()), Math.max(context.pos1.m_123342_(), context.pos2.m_123342_()), Math.max(context.pos1.m_123343_(), context.pos2.m_123343_()));
                String name = StringArgumentType.getString((CommandContext)command, (String)"name");
                ModelHandler.readAndSaveModelToFile(name, blockDefinition, ((CommandSourceStack)command.getSource()).m_81375_().m_9236_(), pos1, pos2.m_123341_() - pos1.m_123341_() + 1, pos2.m_123342_() - pos1.m_123342_() + 1, pos2.m_123343_() - pos1.m_123343_() + 1);
                ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237113_((String)("Saved as " + ChatFormatting.GREEN + name + ".nbt")), true);
                return 0;
            }
            ((CommandSourceStack)command.getSource()).m_81352_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Please select two positions.")));
            return 1;
        }))));
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"buildmodel").requires(a -> a.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"model", (ArgumentType)DungeonModelArgument.modelArgument()).executes(command -> {
            DungeonModel model = DungeonModelArgument.getModel((CommandContext<CommandSourceStack>)command, "model");
            BlockPos pos = ((CommandSourceStack)command.getSource()).m_81375_().m_20183_();
            Tools.buildModel(model, (LevelAccessor)((CommandSourceStack)command.getSource()).m_81375_().m_9236_(), pos, ModelBlockDefinition.getDefaultDefinition());
            Tools.setOrigin((CommandSourceStack)command.getSource(), pos);
            return 0;
        })).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(command -> {
            DungeonModel model = DungeonModelArgument.getModel((CommandContext<CommandSourceStack>)command, "model");
            BlockPos pos = Vec3Argument.m_120849_((CommandContext)command, (String)"location").m_119568_((CommandSourceStack)command.getSource());
            Tools.buildModel(model, (LevelAccessor)((CommandSourceStack)command.getSource()).m_81375_().m_9236_(), pos, ModelBlockDefinition.getDefaultDefinition());
            Tools.setOrigin((CommandSourceStack)command.getSource(), pos);
            return 0;
        }))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"block definition", (ArgumentType)ModelBlockDefinitionArgument.modelBlockDefinitionArgument()).executes(command -> {
            ModelBlockDefinition blockDefinition = ModelBlockDefinitionArgument.getDefinition((CommandContext<CommandSourceStack>)command, "block definition");
            DungeonModel model = DungeonModelArgument.getModel((CommandContext<CommandSourceStack>)command, "model");
            BlockPos pos = ((CommandSourceStack)command.getSource()).m_81375_().m_20183_();
            Tools.buildModel(model, (LevelAccessor)((CommandSourceStack)command.getSource()).m_81375_().m_9236_(), pos, blockDefinition);
            Tools.setOrigin((CommandSourceStack)command.getSource(), pos);
            return 0;
        })).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(command -> {
            ModelBlockDefinition blockDefinition = ModelBlockDefinitionArgument.getDefinition((CommandContext<CommandSourceStack>)command, "block definition");
            DungeonModel model = DungeonModelArgument.getModel((CommandContext<CommandSourceStack>)command, "model");
            BlockPos pos = Vec3Argument.m_120849_((CommandContext)command, (String)"location").m_119568_((CommandSourceStack)command.getSource());
            Tools.buildModel(model, (LevelAccessor)((CommandSourceStack)command.getSource()).m_81375_().m_9236_(), pos, blockDefinition);
            Tools.setOrigin((CommandSourceStack)command.getSource(), pos);
            return 0;
        })))));
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"origin").requires(source -> source.m_6761_(2))).executes(command -> {
            UUID uuid = ((CommandSourceStack)command.getSource()).m_81375_().m_20148_();
            if (!CONTEXT_TABLE.containsKey(uuid)) {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Please set your origin with " + ChatFormatting.BOLD + "/origin ~ ~ ~" + ChatFormatting.RED + " first.")));
                return 1;
            }
            ModelEditContext context = CONTEXT_TABLE.get(uuid);
            BlockPos pos = ((CommandSourceStack)command.getSource()).m_81375_().m_20183_();
            ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237113_((String)("The origin is (x: " + context.origin.m_123341_() + " y: " + context.origin.m_123342_() + " z: " + context.origin.m_123343_() + ").")), true);
            ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237113_((String)("Your coordinates relative to the origin are (x: " + (pos.m_123341_() - context.origin.m_123341_()) + " y: " + (pos.m_123342_() - context.origin.m_123342_()) + " z: " + (pos.m_123343_() - context.origin.m_123343_()) + ").")), true);
            return 0;
        })).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(command -> {
            BlockPos location = Vec3Argument.m_120849_((CommandContext)command, (String)"location").m_119568_((CommandSourceStack)command.getSource());
            Tools.setOrigin((CommandSourceStack)command.getSource(), location);
            return 0;
        }))).then(Commands.m_82127_((String)"reset").executes(command -> {
            UUID uuid = ((CommandSourceStack)command.getSource()).m_81375_().m_20148_();
            if (CONTEXT_TABLE.containsKey(uuid)) {
                Tools.CONTEXT_TABLE.get((Object)uuid).origin = null;
                ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237113_((String)"Origin reset."), true);
            } else {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)Component.m_237113_((String)"Nothing to reset."));
            }
            return 0;
        })));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getLevel().m_5776_() && event.getPlayer().m_7500_()) {
            Item item = event.getPlayer().m_6844_(EquipmentSlot.MAINHAND).m_41720_();
            if (item == Items.f_42391_) {
                event.setCanceled(true);
                BlockPos pos = event.getPos();
                UUID uuid = event.getPlayer().m_36316_().getId();
                Tools.CONTEXT_TABLE.computeIfAbsent((UUID)uuid, (Function<UUID, ModelEditContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onBlockBreak$18(java.util.UUID ), (Ljava/util/UUID;)Lxiroc/dungeoncrawl/util/tools/ModelEditContext;)()).pos1 = pos;
                event.getPlayer().m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Position 1 set to (" + pos.m_123341_() + " | " + pos.m_123342_() + " | " + pos.m_123343_() + ") ")));
            } else if (item == Items.f_42433_) {
                event.setCanceled(true);
                Tools.CONTEXT_TABLE.computeIfAbsent((UUID)event.getPlayer().m_20148_(), (Function<UUID, ModelEditContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onBlockBreak$19(java.util.UUID ), (Ljava/util/UUID;)Lxiroc/dungeoncrawl/util/tools/ModelEditContext;)()).origin = event.getPos();
                event.getPlayer().m_213846_((Component)Component.m_237113_((String)("Origin set to (x: " + event.getPos().m_123341_() + " y: " + event.getPos().m_123342_() + " z: " + event.getPos().m_123343_() + ").")));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntity().m_9236_().m_5776_() && event.getEntity().m_7500_()) {
            if (event.getItemStack().m_41720_() == Items.f_42391_) {
                event.setCanceled(true);
                BlockPos pos = event.getPos();
                UUID uuid = event.getEntity().m_36316_().getId();
                Tools.CONTEXT_TABLE.computeIfAbsent((UUID)uuid, (Function<UUID, ModelEditContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onItemUse$20(java.util.UUID ), (Ljava/util/UUID;)Lxiroc/dungeoncrawl/util/tools/ModelEditContext;)()).pos2 = pos;
                event.getEntity().m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Position 2 set to (" + pos.m_123341_() + " | " + pos.m_123342_() + " | " + pos.m_123343_() + ") ")));
            } else if (event.getItemStack().m_41720_() == Items.f_42433_ && CONTEXT_TABLE.containsKey(event.getEntity().m_20148_())) {
                event.setCanceled(true);
                ModelEditContext context = CONTEXT_TABLE.get(event.getEntity().m_20148_());
                if (context.origin != null) {
                    event.getEntity().m_213846_((Component)Component.m_237113_((String)("The coordinates of the block you clicked relative to the origin are (x: " + (event.getPos().m_123341_() - context.origin.m_123341_()) + " y: " + (event.getPos().m_123342_() - context.origin.m_123342_()) + " z: " + (event.getPos().m_123343_() - context.origin.m_123343_()) + ").")));
                }
            }
        }
    }

    private static void setOrigin(CommandSourceStack source, BlockPos pos) throws CommandSyntaxException {
        ModelEditContext context = CONTEXT_TABLE.computeIfAbsent(source.m_81375_().m_20148_(), id -> new ModelEditContext());
        context.origin = pos;
        source.m_288197_(() -> Component.m_237113_((String)("Origin set to (x: " + context.origin.m_123341_() + " y: " + context.origin.m_123342_() + " z: " + context.origin.m_123343_() + ").")), true);
    }

    public static void buildModel(DungeonModel model, LevelAccessor world, BlockPos pos, ModelBlockDefinition definition) {
        for (int y = 0; y < model.height; ++y) {
            for (int x = 0; x < model.width; ++x) {
                for (int z = 0; z < model.length; ++z) {
                    world.m_7731_(new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z), Blocks.f_50375_.m_49966_(), 2);
                }
            }
        }
        model.blocks.forEach(modelBlock -> {
            BlockPos placePos = pos.m_121955_(modelBlock.position);
            Block block = definition.getBlock((DungeonModelBlock)modelBlock);
            if (block == null) {
                block = Blocks.f_50016_;
            }
            world.m_7731_(placePos, modelBlock.create(block.m_49966_(), world, placePos, Rotation.NONE), 3);
        });
    }

    private static /* synthetic */ ModelEditContext lambda$onItemUse$20(UUID id) {
        return new ModelEditContext();
    }

    private static /* synthetic */ ModelEditContext lambda$onBlockBreak$19(UUID key) {
        return new ModelEditContext();
    }

    private static /* synthetic */ ModelEditContext lambda$onBlockBreak$18(UUID id) {
        return new ModelEditContext();
    }
}

