/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HoarderBee
extends ProductiveBee {
    protected static final EntityDataAccessor<Byte> PEEK_TICK = SynchedEntityData.m_135353_(HoarderBee.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private float prevPeekAmount;
    private float peekAmount = 1.0f;
    public BlockPos targetItemPos = null;
    private final SimpleContainer inventory = new SimpleContainer(this.getBeeName().equals("hoarder") ? 3 : 1);
    private int outOfHiveCounter = 0;

    public HoarderBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    public int getInventorySize() {
        return this.inventory.m_6643_();
    }

    @Override
    protected void m_8099_() {
        this.registerBaseGoals();
        this.f_21345_.m_25363_((Goal)this.breedGoal);
        this.f_21345_.m_25352_(3, (Goal)new PickupItemGoal());
        this.f_21345_.m_25352_(3, (Goal)new LocateItemGoal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PEEK_TICK, (Object)100);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        float f1 = (float)this.getPeekTick() * 0.01f;
        this.prevPeekAmount = this.peekAmount;
        if (this.peekAmount > f1) {
            this.peekAmount = Mth.m_14036_((float)(this.peekAmount - 0.05f), (float)f1, (float)1.0f);
        } else if (this.peekAmount < f1) {
            this.peekAmount = Mth.m_14036_((float)(this.peekAmount + 0.05f), (float)0.0f, (float)f1);
        }
    }

    @Override
    public int getTimeInHive(boolean hasNectar) {
        return 100;
    }

    public int getPeekTick() {
        return ((Byte)this.f_19804_.m_135370_(PEEK_TICK)).byteValue();
    }

    public float getClientPeekAmount(float p_184688_1_) {
        return Mth.m_14179_((float)p_184688_1_, (float)this.prevPeekAmount, (float)this.peekAmount);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(PEEK_TICK, (Object)tag.m_128445_("Peek"));
        if (tag.m_128441_("targetItemPos")) {
            this.targetItemPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("targetItemPos"));
        }
        if (tag.m_128441_("inventory")) {
            ListTag listnbt = tag.m_128437_("inventory", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)listnbt.m_128728_(i));
                if (itemstack.m_41619_()) continue;
                this.inventory.m_19173_(itemstack);
            }
            tag.m_128473_("inventory");
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("Peek", ((Byte)this.f_19804_.m_135370_(PEEK_TICK)).byteValue());
        if (this.targetItemPos != null) {
            tag.m_128365_("targetItemPos", (Tag)NbtUtils.m_129224_((BlockPos)this.targetItemPos));
        }
        if (!this.inventory.m_7983_()) {
            ListTag listnbt = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                listnbt.add((Object)itemstack.m_41739_(new CompoundTag()));
            }
            tag.m_128365_("inventory", (Tag)listnbt);
        }
    }

    public void m_27853_() {
        super.m_27853_();
        this.outOfHiveCounter = 0;
    }

    protected void m_5907_() {
        super.m_5907_();
        this.m_19998_((ItemLike)Items.f_42748_);
    }

    public void openAbdomen() {
        this.f_19804_.m_135381_(PEEK_TICK, (Object)0);
    }

    public void closeAbdomen() {
        this.f_19804_.m_135381_(PEEK_TICK, (Object)100);
    }

    public boolean holdsItem() {
        return !this.inventory.m_7983_();
    }

    public void emptyIntoInventory(InventoryHandlerHelper.BlockEntityItemStackHandler inv) {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (inv.addOutput(itemstack.m_41777_()).m_41613_() != 0) continue;
            this.inventory.m_8016_(i);
        }
        this.inventory.m_6596_();
    }

    @Override
    public boolean m_27866_() {
        return this.outOfHiveCounter > 600 || !this.inventoryHasSpace() || super.m_27866_();
    }

    public void m_6667_(@Nonnull DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (!this.isInventoryEmpty()) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this.inventory);
        }
    }

    public List<ItemEntity> getItemsNearby(double distance) {
        return this.getItemsNearby(this.m_20183_(), distance);
    }

    public List<ItemEntity> getItemsNearby(BlockPos pos, double distance) {
        return this.m_9236_().m_45976_(ItemEntity.class, new AABB(pos).m_82377_(distance, distance, distance));
    }

    public boolean isInventoryEmpty() {
        return this.inventory.m_7983_();
    }

    private boolean inventoryHasSpace() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (!itemstack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    public void pickupItem(ItemEntity item) {
        ItemStack itemstack = item.m_32055_().m_41777_();
        ItemStack remaining = this.inventory.m_19173_(itemstack);
        if (remaining.m_41619_()) {
            item.m_146870_();
        } else {
            item.m_32045_(remaining);
        }
    }

    public class PickupItemGoal
    extends Goal {
        private int ticks = 0;

        public boolean m_8036_() {
            if (HoarderBee.this.targetItemPos != null && !this.positionHasItemEntity(HoarderBee.this.targetItemPos)) {
                HoarderBee.this.targetItemPos = null;
            }
            return HoarderBee.this.targetItemPos != null && HoarderBee.this.inventoryHasSpace() && !HoarderBee.this.m_21660_() && !HoarderBee.this.m_27816_(HoarderBee.this.targetItemPos, 2);
        }

        public void m_8056_() {
            this.ticks = 0;
            super.m_8056_();
        }

        public void m_8037_() {
            ++HoarderBee.this.outOfHiveCounter;
            if (HoarderBee.this.targetItemPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    HoarderBee.this.targetItemPos = null;
                } else if (!HoarderBee.this.f_21344_.m_26577_()) {
                    BlockPos itemPos = HoarderBee.this.targetItemPos;
                    HoarderBee.this.f_21344_.m_26519_((double)itemPos.m_123341_(), (double)itemPos.m_123342_(), (double)itemPos.m_123343_(), 1.0);
                }
            }
        }

        private boolean positionHasItemEntity(BlockPos pos) {
            return !HoarderBee.this.getItemsNearby(pos, 1.0).isEmpty();
        }
    }

    public class LocateItemGoal
    extends Goal {
        private int ticks = 0;

        public boolean m_8036_() {
            boolean canStart;
            boolean bl = canStart = HoarderBee.this.inventoryHasSpace() && !HoarderBee.this.m_21660_();
            if (canStart && HoarderBee.this.f_27698_ != null) {
                List<Object> items = new ArrayList();
                BlockEntity hive = HoarderBee.this.m_9236_().m_7702_(HoarderBee.this.f_27698_);
                if (hive instanceof AdvancedBeehiveBlockEntity) {
                    AdvancedBeehiveBlockEntity beehiveBlockEntity = (AdvancedBeehiveBlockEntity)hive;
                    int radius = 5 + beehiveBlockEntity.getUpgradeCount((Item)ModItems.UPGRADE_RANGE.get());
                    items = HoarderBee.this.getItemsNearby(HoarderBee.this.f_27698_, radius);
                }
                if (!items.isEmpty()) {
                    BlockPos nearestItemLocation = null;
                    double nearestItemDistance = -1.0;
                    BlockPos beeLocation = HoarderBee.this.m_20183_();
                    int i = 0;
                    for (ItemEntity item : items) {
                        BlockPos itemLocation = new BlockPos((int)item.m_20185_(), (int)item.m_20186_(), (int)item.m_20189_());
                        double distance = itemLocation.m_123331_((Vec3i)beeLocation);
                        if (nearestItemDistance == -1.0 || distance < nearestItemDistance) {
                            nearestItemDistance = distance;
                            nearestItemLocation = itemLocation;
                        }
                        if (++i <= 10) continue;
                        break;
                    }
                    HoarderBee.this.targetItemPos = nearestItemLocation;
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            return HoarderBee.this.targetItemPos != null && HoarderBee.this.inventoryHasSpace() && !HoarderBee.this.m_21660_();
        }

        public void m_8056_() {
            this.ticks = 0;
        }

        public void m_8041_() {
            this.ticks = 0;
            HoarderBee.this.closeAbdomen();
        }

        public void m_8037_() {
            ++HoarderBee.this.outOfHiveCounter;
            ++this.ticks;
            if (HoarderBee.this.targetItemPos != null) {
                if (this.ticks > 600) {
                    HoarderBee.this.targetItemPos = null;
                } else {
                    Vec3 vec3d = Vec3.m_82512_((Vec3i)HoarderBee.this.targetItemPos).m_82520_(0.0, (double)0.6f, 0.0);
                    double distanceToTarget = vec3d.m_82554_(HoarderBee.this.m_20182_());
                    if (distanceToTarget < 2.0 && distanceToTarget > 0.2) {
                        HoarderBee.this.openAbdomen();
                    }
                    if (distanceToTarget > 1.2) {
                        this.moveToNextTarget(vec3d);
                    } else if (distanceToTarget > 0.5 && this.ticks > 600) {
                        HoarderBee.this.targetItemPos = null;
                    } else {
                        List<ItemEntity> items = HoarderBee.this.getItemsNearby(1.0);
                        if (!items.isEmpty()) {
                            ItemEntity item = items.iterator().next();
                            HoarderBee.this.pickupItem(item);
                            HoarderBee.this.closeAbdomen();
                            HoarderBee.this.m_5496_(SoundEvents.f_11693_, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void moveToNextTarget(Vec3 nextTarget) {
            HoarderBee.this.m_21566_().m_6849_(nextTarget.f_82479_, nextTarget.f_82480_, nextTarget.f_82481_, 1.0);
        }
    }
}

