/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.item.BeeBomb;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BeeBombBeeCageRecipe
implements CraftingRecipe {
    public final ResourceLocation id;
    public final ItemStack beeBomb;

    public BeeBombBeeCageRecipe(ResourceLocation id, ItemStack beeBomb) {
        this.id = id;
        this.beeBomb = beeBomb;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack beeBombStack = null;
        int beeCount = 0;
        int bombBeeCount = 0;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (beeBombStack == null && (itemstack.m_41720_().equals(ModItems.BEE_BOMB.get()) || itemstack.m_41720_().equals(ModItems.BEE_BOMB_ANGRY.get()))) {
                beeBombStack = itemstack;
                ListTag bees = BeeBomb.getBees(beeBombStack);
                beeCount += bees.size();
                bombBeeCount = bees.size();
                continue;
            }
            if (itemstack.m_41720_().equals(ModItems.BEE_CAGE.get()) && BeeCage.isFilled(itemstack)) {
                ++beeCount;
                continue;
            }
            return false;
        }
        if (beeBombStack == null) {
            return false;
        }
        if (bombBeeCount == beeCount) {
            return false;
        }
        return beeCount > 0 && beeCount <= (Integer)ProductiveBeesConfig.GENERAL.numberOfBeesPerBomb.get();
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack bomb = null;
        ArrayList<ItemStack> beeCages = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41720_().equals(ModItems.BEE_BOMB.get()) || itemstack.m_41720_().equals(ModItems.BEE_BOMB_ANGRY.get())) {
                bomb = itemstack;
                continue;
            }
            if (!itemstack.m_41720_().equals(ModItems.BEE_CAGE.get())) continue;
            beeCages.add(itemstack);
        }
        if (bomb != null) {
            ItemStack beeBomb = bomb.m_41777_();
            beeCages.forEach(beeCage -> BeeBomb.addBee(beeBomb, beeCage));
            beeBomb.m_41764_(1);
            return beeBomb;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.beeBomb;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.beeBomb.m_41777_()}));
        ItemStack cage = new ItemStack((ItemLike)ModItems.BEE_CAGE.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("entity", EntityType.m_20613_((EntityType)EntityType.f_20550_).toString());
        cage.m_41751_(nbt);
        list.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{cage}));
        return list;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.BEE_CAGE_BOMB.get();
    }

    public static class Serializer<T extends BeeBombBeeCageRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            return this.factory.create(id, new ItemStack((ItemLike)ModItems.BEE_BOMB.get()));
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                return this.factory.create(id, buffer.m_130267_());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee bomb cage recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                buffer.m_130055_(((BeeBombBeeCageRecipe)recipe).beeBomb);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee bomb cage recipe to packet. " + ((BeeBombBeeCageRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeBombBeeCageRecipe> {
            public T create(ResourceLocation var1, ItemStack var2);
        }
    }
}

