/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeConversionRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final Lazy<BeeIngredient> source;
    public final Lazy<BeeIngredient> result;
    public final Ingredient item;
    public final int chance;

    public BeeConversionRecipe(ResourceLocation id, Lazy<BeeIngredient> ingredients, Lazy<BeeIngredient> result, Ingredient item, int chance) {
        this.id = id;
        this.source = ingredients;
        this.result = result;
        this.item = item;
        this.chance = chance;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (inv instanceof BeeHelper.IdentifierInventory && this.source.get() != null) {
            String beeName = ((BeeHelper.IdentifierInventory)inv).getIdentifier(0);
            String itemName = ((BeeHelper.IdentifierInventory)inv).getIdentifier(1);
            String parentName = ((BeeIngredient)this.source.get()).getBeeType().toString();
            boolean matchesItem = false;
            for (ItemStack stack : this.item.m_43908_()) {
                if (!ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString().equals(itemName)) continue;
                matchesItem = true;
            }
            return parentName.equals(beeName) && matchesItem;
        }
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.BEE_CONVERSION.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.BEE_CONVERSION_TYPE.get();
    }

    public static class Serializer<T extends BeeConversionRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            String source = GsonHelper.m_13906_((JsonObject)json, (String)"source");
            String result = GsonHelper.m_13906_((JsonObject)json, (String)"result");
            Lazy sourceBee = Lazy.of(BeeIngredientFactory.getIngredient(source));
            Lazy resultBee = Lazy.of(BeeIngredientFactory.getIngredient(result));
            Ingredient item = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"item")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"item"));
            int chance = GsonHelper.m_13824_((JsonObject)json, (String)"chance", (int)100);
            return this.factory.create(id, (Lazy<BeeIngredient>)sourceBee, (Lazy<BeeIngredient>)resultBee, item, chance);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                BeeIngredient source = BeeIngredient.fromNetwork(buffer);
                BeeIngredient result = BeeIngredient.fromNetwork(buffer);
                return this.factory.create(id, (Lazy<BeeIngredient>)Lazy.of(() -> source), (Lazy<BeeIngredient>)Lazy.of(() -> result), Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee conversion recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                ((BeeIngredient)((BeeConversionRecipe)recipe).source.get()).toNetwork(buffer);
                ((BeeIngredient)((BeeConversionRecipe)recipe).result.get()).toNetwork(buffer);
                ((BeeConversionRecipe)recipe).item.m_43923_(buffer);
                buffer.writeInt(((BeeConversionRecipe)recipe).chance);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee conversion recipe to packet. " + ((BeeConversionRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeConversionRecipe> {
            public T create(ResourceLocation var1, Lazy<BeeIngredient> var2, Lazy<BeeIngredient> var3, Ingredient var4, int var5);
        }
    }
}

