/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.util;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT}, modid="hostilenetworks")
public class ClientEntityCache {
    private static final Map<Level, Map<EntityType<?>, LivingEntity>> CACHE = new IdentityHashMap();

    public static <T extends LivingEntity> T computeIfAbsent(EntityType<T> type, Level level, CompoundTag displayNbt) {
        Map map = CACHE.computeIfAbsent(level, l -> new IdentityHashMap());
        return (T)map.computeIfAbsent(type, k -> {
            LivingEntity t = (LivingEntity)type.m_20615_(level);
            t.m_20258_(displayNbt);
            return t;
        });
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            CACHE.values().stream().map(Map::values).flatMap(Collection::stream).forEach(e -> ++e.f_19797_);
        }
    }

    @SubscribeEvent
    public static void unload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            CACHE.remove(event.getLevel());
        }
    }
}

