/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.capability.energy.InfinityEnergyStorage;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class CreativeChargingStationBlockEntity
extends BlockEntity {
    public static final int CHARGE_RADIUS = 8;
    private LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(InfinityEnergyStorage::new);

    public CreativeChargingStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CREATIVE_CHARGING_STATION.get(), pos, state);
    }

    public static void serverTick(CreativeChargingStationBlockEntity blockEntity) {
        if (blockEntity.f_58857_ == null) {
            return;
        }
        blockEntity.energyHandler.ifPresent(handler -> {
            blockEntity.chargeEntity();
            blockEntity.chargeBlock();
        });
    }

    private void chargeEntity() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_46467_() % 20L != 0L) {
            return;
        }
        List entities = this.f_58857_.m_45976_(Entity.class, new AABB(this.m_58899_()).m_82400_(8.0));
        entities.forEach(entity -> entity.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> {
            if (cap.canReceive()) {
                cap.receiveEnergy(Integer.MAX_VALUE, false);
            }
        }));
    }

    private void chargeBlock() {
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
            if (blockEntity == null || !blockEntity.getCapability(ForgeCapabilities.ENERGY).isPresent() || blockEntity instanceof CreativeChargingStationBlockEntity) continue;
            blockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> {
                if (energy.canReceive() && energy.getEnergyStored() < energy.getMaxEnergyStored()) {
                    energy.receiveEnergy(Integer.MAX_VALUE, false);
                    blockEntity.m_6596_();
                }
            });
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        return ForgeCapabilities.ENERGY.orEmpty(cap, this.energyHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.energyHandler = LazyOptional.of(InfinityEnergyStorage::new);
    }
}

