/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.block.ContainerBlock;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SmallContainerBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    @Nullable
    public ResourceLocation lootTable;
    public long lootTableSeed;
    public int tick = 0;
    @Nullable
    private Player player;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SmallContainerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SMALL_CONTAINER.get(), pos, state);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, SmallContainerBlockEntity blockEntity) {
        if (!((Boolean)pState.m_61143_((Property)ContainerBlock.OPENED)).booleanValue()) {
            return;
        }
        if (blockEntity.tick < 20) {
            ++blockEntity.tick;
            blockEntity.m_6596_();
            if (blockEntity.tick == 18) {
                ParticleTool.sendParticle((ServerLevel)pLevel, ParticleTypes.f_123813_, pPos.m_123341_(), pPos.m_123342_() + 1, pPos.m_123343_(), 40, 1.5, 1.5, 1.5, 1.0, false);
                pLevel.m_5594_(null, pPos, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (pLevel.f_46441_.m_188501_() - pLevel.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            }
        } else {
            List<ItemStack> items = blockEntity.unpackLootTable(blockEntity.player);
            if (!items.isEmpty()) {
                for (ItemStack item : items) {
                    ItemEntity entity = new ItemEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.85, (double)pPos.m_123343_() + 0.5, item);
                    entity.m_20256_(new Vec3(pLevel.f_46441_.m_188500_() * 0.1, 0.1, pLevel.f_46441_.m_188500_() * 0.1));
                    pLevel.m_7967_((Entity)entity);
                }
            }
            pLevel.m_46597_(pPos, Blocks.f_50016_.m_49966_());
        }
    }

    private PlayState predicate(AnimationState<SmallContainerBlockEntity> event) {
        if (((Boolean)this.m_58900_().m_61143_((Property)ContainerBlock.OPENED)).booleanValue()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.container.open"));
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("LootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.m_128461_("LootTable"));
            this.lootTableSeed = compound.m_128454_("LootTableSeed");
        }
        this.tick = compound.m_128451_("Tick");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.lootTable != null) {
            compound.m_128359_("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.m_128356_("LootTableSeed", this.lootTableSeed);
            }
        }
        compound.m_128405_("Tick", this.tick);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void m_187476_(ItemStack pStack) {
        CompoundTag tag = new CompoundTag();
        if (this.lootTable != null) {
            tag.m_128359_("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                tag.m_128356_("LootTableSeed", this.lootTableSeed);
            }
        }
        BlockItem.m_186338_((ItemStack)pStack, (BlockEntityType)this.m_58903_(), (CompoundTag)tag);
    }

    public void setLootTable(ResourceLocation pLootTable, long pLootTableSeed) {
        this.lootTable = pLootTable;
        this.lootTableSeed = pLootTableSeed;
    }

    public List<ItemStack> unpackLootTable(@Nullable Player pPlayer) {
        if (this.lootTable != null && this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            LootTable loottable = this.f_58857_.m_7654_().m_278653_().m_278676_(this.lootTable);
            if (pPlayer instanceof ServerPlayer) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)pPlayer, this.lootTable);
            }
            this.lootTable = null;
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_));
            if (pPlayer != null) {
                builder.m_287239_(pPlayer.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)pPlayer);
            }
            return loottable.m_287214_(builder.m_287235_(LootContextParamSets.f_81411_), this.lootTableSeed).stream().toList();
        }
        return Collections.emptyList();
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(@Nullable Player player) {
        this.player = player;
    }
}

