/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.capability;

import com.atsuishio.superbwarfare.entity.projectile.AbstractLaserEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class LaserHandler {
    public boolean isUsing;
    public final LivingEntity entity;
    public final AbstractLaserEntity laserEntity;
    private int tick;

    public LaserHandler(LivingEntity entity, AbstractLaserEntity laserEntity) {
        this.entity = entity;
        this.laserEntity = laserEntity;
    }

    public void start() {
        this.tick = 0;
        this.isUsing = true;
        Level level = this.entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_7967_((Entity)this.laserEntity);
        }
    }

    public void tick() {
        if (this.isUsing) {
            ++this.tick;
            if (this.tick > this.laserEntity.getDuration()) {
                this.stop();
            }
        }
    }

    public void stop() {
        if (!this.isUsing) {
            return;
        }
        this.isUsing = false;
        this.tick = 0;
        if (this.laserEntity != null) {
            this.laserEntity.setDuration(3);
        }
    }

    public void end() {
        if (!this.isUsing) {
            return;
        }
        this.isUsing = false;
        this.tick = 0;
        if (this.laserEntity != null) {
            this.laserEntity.m_146870_();
        }
    }

    public int getTick() {
        return this.tick;
    }

    public CompoundTag writeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        if (this.isUsing) {
            compoundTag.m_128405_("Tick", this.tick);
        }
        return compoundTag;
    }

    public void readNBT(Tag nbt) {
        CompoundTag compoundTag = (CompoundTag)nbt;
        this.isUsing = compoundTag.m_128441_("Tick");
        if (this.isUsing) {
            this.tick = compoundTag.m_128451_("Tick");
        }
    }

    public boolean isUsable() {
        return !this.isUsing;
    }
}

