/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.init.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class ArmorPlateOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_armor_plate";
    private static final ResourceLocation ICON = Mod.loc("textures/screens/armor_plate_icon.png");
    private static final ResourceLocation LEVEL1 = Mod.loc("textures/screens/armor_plate_level1.png");
    private static final ResourceLocation LEVEL2 = Mod.loc("textures/screens/armor_plate_level2.png");
    private static final ResourceLocation LEVEL3 = Mod.loc("textures/screens/armor_plate_level3.png");
    private static final ResourceLocation LEVEL1_FRAME = Mod.loc("textures/screens/armor_plate_level1_frame.png");
    private static final ResourceLocation LEVEL2_FRAME = Mod.loc("textures/screens/armor_plate_level2_frame.png");
    private static final ResourceLocation LEVEL3_FRAME = Mod.loc("textures/screens/armor_plate_level3_frame.png");

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (!((Boolean)DisplayConfig.ARMOR_PLATE_HUD.get()).booleanValue()) {
            return;
        }
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        if (stack == ItemStack.f_41583_) {
            return;
        }
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("ArmorPlate")) {
            return;
        }
        int armorLevel = (Integer)MiscConfig.DEFAULT_ARMOR_LEVEL.get();
        if (stack.m_204117_(ModTags.Items.MILITARY_ARMOR)) {
            armorLevel = (Integer)MiscConfig.MILITARY_ARMOR_LEVEL.get();
        } else if (stack.m_204117_(ModTags.Items.MILITARY_ARMOR_HEAVY)) {
            armorLevel = (Integer)MiscConfig.HEAVY_MILITARY_ARMOR_LEVEL.get();
        }
        int max = armorLevel * (Integer)MiscConfig.ARMOR_PONT_PER_LEVEL.get();
        double amount = 60.0 * (stack.m_41783_().m_128459_("ArmorPlate") / (double)max);
        ResourceLocation texture = switch (armorLevel) {
            case 2 -> LEVEL2;
            case 3 -> LEVEL3;
            default -> LEVEL1;
        };
        ResourceLocation frame = switch (armorLevel) {
            case 2 -> LEVEL2_FRAME;
            case 3 -> LEVEL3_FRAME;
            default -> LEVEL1_FRAME;
        };
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280163_(ICON, 10, screenHeight - 13, 0.0f, 0.0f, 8, 8, 8, 8);
        guiGraphics.m_280163_(frame, 20, screenHeight - 12, 0.0f, 0.0f, 60, 6, 60, 6);
        guiGraphics.m_280163_(texture, 20, screenHeight - 12, 0.0f, 0.0f, (int)amount, 6, 60, 6);
        guiGraphics.m_280168_().m_85849_();
    }
}

