/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.CrossHairOverlay;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.entity.vehicle.SpeedboatEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AircraftEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.LaserWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallRocketWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SwarmDroneWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.atsuishio.superbwarfare.tools.animation.AnimationCurves;
import com.atsuishio.superbwarfare.tools.animation.AnimationTimer;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Math;
import top.theillusivec4.curios.api.CuriosApi;

@OnlyIn(value=Dist.CLIENT)
public class VehicleHudOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_vehicle_hud";
    private static float scopeScale = 1.0f;
    private static final ResourceLocation FRAME = Mod.loc("textures/screens/land/tv_frame.png");
    private static final ResourceLocation ARMOR = Mod.loc("textures/screens/armor.png");
    private static final ResourceLocation ENERGY = Mod.loc("textures/screens/energy.png");
    private static final ResourceLocation HEALTH = Mod.loc("textures/screens/armor_value.png");
    private static final ResourceLocation HEALTH_FRAME = Mod.loc("textures/screens/armor_value_frame.png");
    private static final ResourceLocation DRIVER = Mod.loc("textures/screens/driver.png");
    private static final ResourceLocation PASSENGER = Mod.loc("textures/screens/passenger.png");
    private static final ResourceLocation SELECTED = Mod.loc("textures/screens/vehicle_weapon/selected.png");
    private static final ResourceLocation NUMBER = Mod.loc("textures/screens/vehicle_weapon/number.png");
    private static final ResourceLocation GEAR = Mod.loc("textures/screens/aircraft/gear.png");
    public static final int ANIMATION_TIME = 300;
    private static final AnimationTimer[] weaponSlotsTimer = AnimationTimer.createTimers(9, 300L, AnimationCurves.EASE_OUT_CIRC);
    private static boolean wasRenderingWeapons = false;
    private static int oldWeaponIndex = 0;
    private static int oldRenderWeaponIndex = 0;
    private static final AnimationTimer weaponIndexUpdateTimer = new AnimationTimer(300L).animation(AnimationCurves.EASE_OUT_CIRC);

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        VehicleEntity vehicleEntity;
        LocalPlayer player = gui.getMinecraft().f_91074_;
        if (!VehicleHudOverlay.shouldRenderHud((Player)player)) {
            wasRenderingWeapons = false;
            return;
        }
        Entity vehicle = player.m_20202_();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        VehicleHudOverlay.renderLandArmorHud(gui, guiGraphics, partialTick, screenWidth, screenHeight);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int compatHeight = VehicleHudOverlay.getArmorPlateCompatHeight((Player)player);
        if (vehicle instanceof VehicleEntity && (vehicleEntity = (VehicleEntity)vehicle).hasEnergyStorage()) {
            float energy = vehicleEntity.getEnergy();
            float maxEnergy = vehicleEntity.getMaxEnergy();
            RenderHelper.preciseBlit(guiGraphics, ENERGY, 10.0f, screenHeight - 22 - compatHeight, 100.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
            RenderHelper.preciseBlit(guiGraphics, HEALTH_FRAME, 20.0f, screenHeight - 21 - compatHeight, 100.0f, 0.0f, 0.0f, 60.0f, 6.0f, 60.0f, 6.0f);
            RenderHelper.preciseBlit(guiGraphics, HEALTH, 20.0f, screenHeight - 21 - compatHeight, 100.0f, 0.0f, 0.0f, (int)(60.0f * energy / maxEnergy), 6.0f, 60.0f, 6.0f);
        }
        if (vehicle instanceof VehicleEntity) {
            VehicleEntity pVehicle = (VehicleEntity)vehicle;
            float health = pVehicle.getHealth();
            float maxHealth = pVehicle.getMaxHealth();
            RenderHelper.preciseBlit(guiGraphics, ARMOR, 10.0f, screenHeight - 13 - compatHeight, 100.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
            RenderHelper.preciseBlit(guiGraphics, HEALTH_FRAME, 20.0f, screenHeight - 12 - compatHeight, 100.0f, 0.0f, 0.0f, 60.0f, 6.0f, 60.0f, 6.0f);
            RenderHelper.preciseBlit(guiGraphics, HEALTH, 20.0f, screenHeight - 12 - compatHeight, 100.0f, 0.0f, 0.0f, (int)(60.0f * health / maxHealth), 6.0f, 60.0f, 6.0f);
            VehicleHudOverlay.renderWeaponInfo(guiGraphics, pVehicle, screenWidth, screenHeight);
            VehicleHudOverlay.renderPassengerInfo(guiGraphics, pVehicle, screenWidth, screenHeight);
        }
        if (vehicle instanceof AircraftEntity) {
            AircraftEntity aircraftEntity = (AircraftEntity)vehicle;
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float angle = aircraftEntity.gearRot(partialTick).floatValue();
            poseStack.m_85836_();
            poseStack.m_272245_(Axis.f_252403_.m_252977_(-90.0f + angle), 102.0f, (float)(screenHeight - 20), 0.0f);
            RenderHelper.preciseBlit(guiGraphics, GEAR, 86.0f, screenHeight - 36, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private static boolean shouldRenderHud(Player player) {
        if (player == null) {
            return false;
        }
        return !player.m_5833_() && player.m_20202_() != null && player.m_20202_() instanceof VehicleEntity;
    }

    private static int getArmorPlateCompatHeight(Player player) {
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        if (stack == ItemStack.f_41583_) {
            return 0;
        }
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("ArmorPlate")) {
            return 0;
        }
        if (!((Boolean)DisplayConfig.ARMOR_PLATE_HUD.get()).booleanValue()) {
            return 0;
        }
        return 9;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void renderLandArmorHud(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        LandArmorEntity iLand;
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        PoseStack poseStack = guiGraphics.m_280168_();
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        Vec3 viewVec = new Vec3(camera.m_253058_());
        assert (player != null);
        Entity entity = player.m_20202_();
        if (entity instanceof LandArmorEntity && (iLand = (LandArmorEntity)entity).isDriver((Player)player) && iLand instanceof WeaponVehicleEntity && iLand instanceof MobileVehicleEntity) {
            MobileVehicleEntity mobileVehicle = (MobileVehicleEntity)((Object)iLand);
            if (!(player.m_20202_() instanceof SpeedboatEntity)) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0 - 0.3 * ClientEventHandler.shakeTime + (double)(3.0f * ClientEventHandler.cameraRoll), 0.0);
                poseStack.m_272245_(Axis.f_252403_.m_252977_(-0.3f * ClientEventHandler.cameraRoll), (float)screenWidth / 2.0f, (float)screenHeight / 2.0f, 0.0f);
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float scale = scopeScale = Mth.m_14179_((float)partialTick, (float)scopeScale, (float)1.0f);
                if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON || ClientEventHandler.zoomVehicle) {
                    int addW = screenWidth / screenHeight * 48;
                    int addH = screenWidth / screenHeight * 27;
                    RenderHelper.preciseBlit(guiGraphics, FRAME, (float)(-addW) / 2.0f, (float)(-addH) / 2.0f, 10.0f, 0.0f, 0.0f, screenWidth + addW, screenHeight + addH, screenWidth + addW, screenHeight + addH);
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/land/line.png"), (float)screenWidth / 2.0f - 64.0f, screenHeight - 56, 0.0f, 0.0f, 128.0f, 1.0f, 128.0f, 1.0f);
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/compass.png"), (float)screenWidth / 2.0f - 128.0f, 10.0f, 128.0f + 1.4222223f * player.m_146908_(), 0.0f, 256.0f, 16.0f, 512.0f, 16.0f);
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/roll_ind.png"), (float)screenWidth / 2.0f - 8.0f, 30.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
                    poseStack.m_85836_();
                    ResourceLocation body = (double)mobileVehicle.getHealth() > 0.4 * (double)mobileVehicle.getMaxHealth() ? Mod.loc("textures/screens/land/body.png") : ((double)mobileVehicle.getHealth() > 0.1 * (double)mobileVehicle.getMaxHealth() ? Mod.loc("textures/screens/land/body_warning.png") : Mod.loc("textures/screens/land/body_damaged.png"));
                    ResourceLocation left_wheel = (Boolean)mobileVehicle.m_20088_().m_135370_(VehicleEntity.L_WHEEL_DAMAGED) != false ? Mod.loc("textures/screens/land/left_wheel_damaged.png") : Mod.loc("textures/screens/land/left_wheel.png");
                    ResourceLocation right_wheel = (Boolean)mobileVehicle.m_20088_().m_135370_(VehicleEntity.R_WHEEL_DAMAGED) != false ? Mod.loc("textures/screens/land/right_wheel_damaged.png") : Mod.loc("textures/screens/land/right_wheel.png");
                    ResourceLocation engine = (Boolean)mobileVehicle.m_20088_().m_135370_(VehicleEntity.ENGINE1_DAMAGED) != false ? Mod.loc("textures/screens/land/engine_damaged.png") : Mod.loc("textures/screens/land/engine.png");
                    poseStack.m_272245_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)partialTick, (float)iLand.turretYRotO(), (float)iLand.turretYRot())), (float)screenWidth / 2.0f + 112.0f, (float)(screenHeight - 56), 0.0f);
                    RenderHelper.preciseBlit(guiGraphics, body, (float)screenWidth / 2.0f + 96.0f, screenHeight - 72, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f);
                    RenderHelper.preciseBlit(guiGraphics, left_wheel, (float)screenWidth / 2.0f + 96.0f, screenHeight - 72, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f);
                    RenderHelper.preciseBlit(guiGraphics, right_wheel, (float)screenWidth / 2.0f + 96.0f, screenHeight - 72, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f);
                    RenderHelper.preciseBlit(guiGraphics, engine, (float)screenWidth / 2.0f + 96.0f, screenHeight - 72, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f);
                    poseStack.m_85849_();
                    ResourceLocation barrel = (Boolean)mobileVehicle.m_20088_().m_135370_(VehicleEntity.TURRET_DAMAGED) != false ? Mod.loc("textures/screens/land/line_damaged.png") : Mod.loc("textures/screens/land/line.png");
                    RenderHelper.preciseBlit(guiGraphics, barrel, (float)screenWidth / 2.0f + 112.0f, screenHeight - 71, 0.0f, 0.0f, 1.0f, 16.0f, 1.0f, 16.0f);
                    guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(mobileVehicle.m_20184_().m_82526_(mobileVehicle.m_20252_(partialTick)) * 72.0, " km/h")), screenWidth / 2 + 160, screenHeight / 2 - 48, 0x66FF00, false);
                    if (mobileVehicle.hasEnergyStorage()) {
                        if ((double)mobileVehicle.getEnergy() < 0.02 * (double)mobileVehicle.getMaxEnergy()) {
                            guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)"NO POWER!"), screenWidth / 2 - 144, screenHeight / 2 + 14, -65536, false);
                        } else if ((double)mobileVehicle.getEnergy() < 0.2 * (double)mobileVehicle.getMaxEnergy()) {
                            guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)"LOW POWER"), screenWidth / 2 - 144, screenHeight / 2 + 14, 16739072, false);
                        }
                    }
                    boolean lookAtEntity = false;
                    BlockHitResult result = player.m_9236_().m_45547_(new ClipContext(player.m_146892_(), player.m_146892_().m_82549_(player.m_20252_(1.0f).m_82490_(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                    Vec3 hitPos = result.m_82450_();
                    double blockRange = player.m_20299_(1.0f).m_82554_(hitPos);
                    double entityRange = 0.0;
                    Entity lookingEntity = TraceTool.camerafFindLookingEntity((Player)player, cameraPos, viewVec, 512.0);
                    if (lookingEntity != null) {
                        lookAtEntity = true;
                        entityRange = player.m_20270_(lookingEntity);
                    }
                    if (lookAtEntity) {
                        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)FormatTool.format1D(entityRange, "m")), screenWidth / 2 - 6, screenHeight - 53, 0x66FF00, false);
                    } else if (blockRange > 500.0) {
                        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)"---m"), screenWidth / 2 - 6, screenHeight - 53, 0x66FF00, false);
                    } else {
                        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)FormatTool.format1D(blockRange, "m")), screenWidth / 2 - 6, screenHeight - 53, 0x66FF00, false);
                    }
                    mobileVehicle.renderFirstPersonOverlay(guiGraphics, mc.f_91062_, (Player)player, screenWidth, screenHeight, scale);
                    double heal = mobileVehicle.getHealth() / mobileVehicle.getMaxHealth();
                    guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(100.0 * heal)), screenWidth / 2 - 165, screenHeight / 2 - 46, Mth.m_14169_((float)((float)heal / 3.7453184f), (float)1.0f, (float)1.0f), false);
                    guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)("SMOKE " + mobileVehicle.m_20088_().m_135370_(MobileVehicleEntity.DECOY_COUNT))), screenWidth / 2 - 165, screenHeight / 2 - 36, 0x66FF00, false);
                    VehicleHudOverlay.renderKillIndicator(guiGraphics, screenWidth, screenHeight);
                } else if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK && !ClientEventHandler.zoomVehicle) {
                    Vec3 pos = cameraPos.m_82549_(iLand.getBarrelVec(partialTick).m_82490_(192.0));
                    Vec3 p = VectorUtil.worldToScreen(pos);
                    if (VectorUtil.canSee(pos)) {
                        float x = (float)p.f_82479_;
                        float y = (float)p.f_82480_;
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/drone.png"), x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                        VehicleHudOverlay.renderKillIndicator3P(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                        poseStack.m_85836_();
                        poseStack.m_252880_(x, y, 0.0f);
                        poseStack.m_85841_(0.75f, 0.75f, 1.0f);
                        mobileVehicle.renderThirdPersonOverlay(guiGraphics, mc.f_91062_, (Player)player, screenWidth, screenHeight, scale);
                        double health = 1.0f - mobileVehicle.getHealth() / mobileVehicle.getMaxHealth();
                        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)("HP " + FormatTool.format0D(100.0f * mobileVehicle.getHealth() / mobileVehicle.getMaxHealth()))), 30, 1, Mth.m_14169_((float)0.0f, (float)((float)health), (float)1.0f), false);
                        if (mobileVehicle.hasDecoy()) {
                            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)("SMOKE " + mobileVehicle.m_20088_().m_135370_(MobileVehicleEntity.DECOY_COUNT))), 30, 11, -1, false);
                        }
                        poseStack.m_85849_();
                    }
                }
                poseStack.m_85849_();
                return;
            }
        }
        scopeScale = 0.7f;
    }

    public static void renderKillIndicator(GuiGraphics guiGraphics, float w, float h) {
        float posX = w / 2.0f - 7.5f + (float)(2.0 * (Math.random() - 0.5));
        float posY = h / 2.0f - 7.5f + (float)(2.0 * (Math.random() - 0.5));
        float rate = (float)(40 - CrossHairOverlay.KILL_INDICATOR * 5) / 5.5f;
        if (CrossHairOverlay.HIT_INDICATOR > 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/hit_marker.png"), posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.VEHICLE_INDICATOR > 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/hit_marker_vehicle.png"), posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.HEAD_INDICATOR > 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/headshot_mark.png"), posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.KILL_INDICATOR > 0) {
            float posX1 = w / 2.0f - 7.5f - 2.0f + rate;
            float posY1 = h / 2.0f - 7.5f - 2.0f + rate;
            float posX2 = w / 2.0f - 7.5f + 2.0f - rate;
            float posY2 = h / 2.0f - 7.5f + 2.0f - rate;
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark1.png"), posX1, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark2.png"), posX2, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark3.png"), posX1, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark4.png"), posX2, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
    }

    public static void renderKillIndicator3P(GuiGraphics guiGraphics, float posX, float posY) {
        float rate = (float)(40 - CrossHairOverlay.KILL_INDICATOR * 5) / 5.5f;
        if (CrossHairOverlay.HIT_INDICATOR > 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/hit_marker.png"), posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.VEHICLE_INDICATOR > 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/hit_marker_vehicle.png"), posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.HEAD_INDICATOR > 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/headshot_mark.png"), posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.KILL_INDICATOR > 0) {
            float posX1 = posX - 2.0f + rate;
            float posY1 = posY - 2.0f + rate;
            float posX2 = posX + 2.0f - rate;
            float posY2 = posY + 2.0f - rate;
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark1.png"), posX1, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark2.png"), posX2, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark3.png"), posX1, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark4.png"), posX2, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
    }

    private static void renderPassengerInfo(GuiGraphics guiGraphics, VehicleEntity vehicle, int w, int h) {
        List<Entity> passengers = vehicle.getOrderedPassengers();
        int index = 0;
        for (int i = passengers.size() - 1; i >= 0; --i) {
            Entity passenger = passengers.get(i);
            int y = h - 35 - index * 12;
            AtomicReference<String> name = new AtomicReference<String>("---");
            if (passenger != null) {
                name.set(passenger.m_7755_().getString());
            }
            if (passenger instanceof Player) {
                Player player = (Player)passenger;
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(c -> c.findFirstCurio((Item)ModItems.DOG_TAG.get()).ifPresent(s -> {
                    if (s.stack().m_41788_()) {
                        name.set(s.stack().m_41786_().getString());
                    }
                }));
            }
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, name.get(), 42, y, 0x66FF00, true);
            String num = "[" + (i + 1) + "]";
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, num, 25 - Minecraft.m_91087_().f_91062_.m_92895_(num), y, 0x66FF00, true);
            RenderHelper.preciseBlit(guiGraphics, index == passengers.size() - 1 ? DRIVER : PASSENGER, 30.0f, y, 100.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
            ++index;
        }
    }

    private static void renderWeaponInfo(GuiGraphics guiGraphics, VehicleEntity vehicle, int w, int h) {
        WeaponVehicleEntity weaponVehicle;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!(vehicle instanceof WeaponVehicleEntity) || !(weaponVehicle = (WeaponVehicleEntity)((Object)vehicle)).banHand((Player)player)) {
            return;
        }
        boolean temp = wasRenderingWeapons;
        wasRenderingWeapons = false;
        assert (player != null);
        int index = vehicle.getSeatIndex((Entity)player);
        if (index == -1) {
            return;
        }
        List<VehicleWeapon> weapons = weaponVehicle.getAvailableWeapons(index);
        if (weapons.isEmpty()) {
            return;
        }
        int weaponIndex = weaponVehicle.getWeaponIndex(index);
        if (weaponIndex == -1) {
            return;
        }
        wasRenderingWeapons = temp;
        long currentTime = System.currentTimeMillis();
        if (!wasRenderingWeapons) {
            weaponSlotsTimer[weaponIndex].beginForward(currentTime);
            if (oldWeaponIndex != weaponIndex) {
                weaponSlotsTimer[oldWeaponIndex].endBackward(currentTime);
                oldWeaponIndex = weaponIndex;
                oldRenderWeaponIndex = weaponIndex;
            }
            weaponIndexUpdateTimer.beginForward(currentTime);
        }
        if (weaponIndex != oldWeaponIndex) {
            weaponSlotsTimer[weaponIndex].forward(currentTime);
            weaponSlotsTimer[oldWeaponIndex].backward(currentTime);
            oldRenderWeaponIndex = oldWeaponIndex;
            oldWeaponIndex = weaponIndex;
            weaponIndexUpdateTimer.beginForward(currentTime);
        }
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int frameIndex = 0;
        for (int i = weapons.size() - 1; i >= 0 && i < 9; --i) {
            VehicleWeapon weapon = weapons.get(i);
            ResourceLocation frame = Mod.loc("textures/screens/vehicle_weapon/frame_" + (i + 1) + ".png");
            pose.m_85836_();
            int maxXOffset = 35;
            AnimationTimer currentSlotTimer = weaponSlotsTimer[i];
            float progress = currentSlotTimer.getProgress(currentTime);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Mth.m_14179_((float)progress, (float)0.2f, (float)1.0f));
            float xOffset = Mth.m_14179_((float)progress, (float)maxXOffset, (float)0.0f);
            if (weaponIndex == i) {
                float startY = Mth.m_14179_((float)progress, (float)(h - (weapons.size() - 1 - oldRenderWeaponIndex) * 18 - 16), (float)(h - (weapons.size() - 1 - weaponIndex) * 18 - 16));
                RenderHelper.preciseBlit(guiGraphics, SELECTED, w - 95, startY, 100.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
                if (InventoryTool.hasCreativeAmmoBox((Entity)player) && !(weapon instanceof LaserWeapon) && !(weapon instanceof SmallRocketWeapon) && !(weapon instanceof SwarmDroneWeapon)) {
                    RenderHelper.preciseBlit(guiGraphics, NUMBER, (float)(w - 28) + xOffset, h - frameIndex * 18 - 15, 100.0f, 58.0f, 0.0f, 10.0f, 7.5f, 75.0f, 7.5f);
                } else {
                    VehicleHudOverlay.renderNumber(guiGraphics, weaponVehicle.getAmmoCount((Player)player), weapon instanceof LaserWeapon, (float)(w - 20) + xOffset, (float)(h - frameIndex * 18) - 15.5f, 0.25f);
                }
            }
            RenderHelper.preciseBlit(guiGraphics, frame, (float)(w - 85) + xOffset, h - frameIndex * 18 - 20, 100.0f, 0.0f, 0.0f, 75.0f, 16.0f, 75.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, weapon.icon, (float)(w - 85) + xOffset, h - frameIndex * 18 - 20, 100.0f, 0.0f, 0.0f, 75.0f, 16.0f, 75.0f, 16.0f);
            pose.m_85849_();
            ++frameIndex;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_85849_();
        if (oldWeaponIndex != oldRenderWeaponIndex && weaponIndexUpdateTimer.finished(currentTime)) {
            oldRenderWeaponIndex = oldWeaponIndex;
        }
        wasRenderingWeapons = true;
    }

    private static void renderNumber(GuiGraphics guiGraphics, int number, boolean percent, float x, float y, float scale) {
        float pX = x;
        if (percent) {
            RenderHelper.preciseBlit(guiGraphics, NUMBER, (pX -= 32.0f * scale) + 20.0f * scale, y, 100.0f, 200.0f * scale, 0.0f, 32.0f * scale, 30.0f * scale, 300.0f * scale, 30.0f * scale);
        }
        int index = 0;
        if (number == 0) {
            RenderHelper.preciseBlit(guiGraphics, NUMBER, pX, y, 100.0f, 0.0f, 0.0f, 20.0f * scale, 30.0f * scale, 300.0f * scale, 30.0f * scale);
        }
        while (number > 0) {
            int digit = number % 10;
            RenderHelper.preciseBlit(guiGraphics, NUMBER, pX - (float)(index * 20) * scale, y, 100.0f, (float)(digit * 20) * scale, 0.0f, 20.0f * scale, 30.0f * scale, 300.0f * scale, 30.0f * scale);
            number /= 10;
            ++index;
        }
    }
}

