/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.ClientEnergyImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.FormatTool;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public class ClientSentinelImageTooltip
extends ClientEnergyImageTooltip {
    public ClientSentinelImageTooltip(GunImageComponent tooltip) {
        super(tooltip);
    }

    @Override
    protected Component getDamageComponent() {
        int energy = this.stack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
        if (energy > 0) {
            double damage = this.data.get(GunProp.DAMAGE);
            double extraDamage = -1.0;
            for (Perk.Type type : Perk.Type.values()) {
                PerkInstance instance = this.getGunData().perk.getInstance(type);
                if (instance == null || !(instance.perk().getExtraDisplayDamage(damage, this.getGunData(), instance) >= 0.0)) continue;
                extraDamage = instance.perk().getExtraDisplayDamage(damage, this.getGunData(), instance);
            }
            return Component.m_237115_((String)"des.superbwarfare.guns.damage").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)(FormatTool.format1D(damage) + (String)(extraDamage >= 0.0 ? " + " + FormatTool.format1D(extraDamage) : ""))).m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.BOLD));
        }
        return super.getDamageComponent();
    }
}

