/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.IDBasedData;
import com.atsuishio.superbwarfare.data.ObjectToList;
import com.atsuishio.superbwarfare.data.StringToObject;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="superbwarfare")
public class DataLoader {
    private static final HashMap<String, GeneralData<?>> loadedData = new HashMap();
    public static final Gson GSON = DataLoader.createCommonBuilder().create();

    public static <T extends IDBasedData> DataMap<T> createData(String name, Class<T> clazz) {
        return DataLoader.createData(name, clazz, null);
    }

    public static <T extends IDBasedData> DataMap<T> createData(String name, Class<T> clazz, @Nullable Consumer<Map<String, Object>> onReload) {
        if (loadedData.containsKey(name)) {
            return DataLoader.loadedData.get((Object)name).proxyMap;
        }
        DataMap proxyMap = new DataMap(name);
        loadedData.put(name, new GeneralData(clazz, proxyMap, new HashMap<String, Object>(), onReload));
        return proxyMap;
    }

    public static GsonBuilder createCommonBuilder() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).setLenient().serializeSpecialFloatingPointValues().registerTypeAdapterFactory((TypeAdapterFactory)new ObjectToList.AdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new StringToObject.AdapterFactory());
    }

    private static void reloadAllData(ResourceManager manager) {
        loadedData.forEach((name, value) -> {
            HashMap<String, Object> map = value.data;
            map.clear();
            for (Map.Entry entry : manager.m_214159_(name, file -> file.m_135815_().endsWith(".json")).entrySet()) {
                Resource attribute = (Resource)entry.getValue();
                try {
                    Object id;
                    IDBasedData data = (IDBasedData)GSON.fromJson((Reader)new InputStreamReader(attribute.m_215507_()), value.type);
                    if (!data.getId().isEmpty()) {
                        id = data.getId();
                    } else {
                        String path = ((ResourceLocation)entry.getKey()).m_135815_();
                        id = "superbwarfare:" + path.substring(name.length() + 1, path.length() - name.length() - 1);
                        Mod.LOGGER.warn("{} ID for {} is empty, try using {} as id", name, id, (Object)path);
                    }
                    map.put((String)id, data);
                }
                catch (Exception e) {
                    Mod.LOGGER.error(e.getMessage());
                }
            }
            if (value.onReload != null) {
                value.onReload.accept(map);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void serverStarted(ServerStartedEvent event) {
        DataLoader.reloadAllData(event.getServer().m_177941_());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        DataLoader.reloadAllData(event.getPlayerList().m_7873_().m_177941_());
    }

    public static Object processValue(Object value) {
        if (value instanceof ObjectToList) {
            ObjectToList otl = (ObjectToList)value;
            return otl.list.stream().map(DataLoader::processValue).toList();
        }
        if (value instanceof StringToObject) {
            StringToObject sto = (StringToObject)value;
            return DataLoader.processValue(sto.value);
        }
        return value;
    }

    public static class DataMap<T extends IDBasedData>
    extends HashMap<String, T> {
        private final String name;

        private DataMap(String name) {
            this.name = name;
        }

        @Override
        public int size() {
            if (!loadedData.containsKey(this.name)) {
                return 0;
            }
            return DataLoader.loadedData.get((Object)this.name).data.size();
        }

        @Override
        public boolean isEmpty() {
            if (!loadedData.containsKey(this.name)) {
                return true;
            }
            return DataLoader.loadedData.get((Object)this.name).data.isEmpty();
        }

        @Override
        public T get(Object key) {
            if (!loadedData.containsKey(this.name)) {
                return null;
            }
            return (T)((IDBasedData)DataLoader.loadedData.get((Object)this.name).data.get(key));
        }

        @Override
        public T getOrDefault(Object key, T defaultValue) {
            Object value = this.get(key);
            return (T)(value == null ? defaultValue : value);
        }

        @Override
        public boolean containsKey(Object key) {
            if (!loadedData.containsKey(this.name)) {
                return false;
            }
            return DataLoader.loadedData.get((Object)this.name).data.containsKey(key);
        }

        @Override
        public T put(String key, T value) {
            return (T)((IDBasedData)DataLoader.loadedData.get((Object)this.name).data.put(key, value));
        }

        @Override
        public void putAll(Map<? extends String, ? extends T> m) {
            DataLoader.loadedData.get((Object)this.name).data.putAll(m);
        }

        @Override
        public T remove(Object key) {
            return (T)((IDBasedData)DataLoader.loadedData.get((Object)this.name).data.remove(key));
        }

        @Override
        public void clear() {
            DataLoader.loadedData.get((Object)this.name).data.clear();
        }

        @Override
        public boolean containsValue(Object value) {
            if (!loadedData.containsKey(this.name)) {
                return false;
            }
            return DataLoader.loadedData.get((Object)this.name).data.containsValue(value);
        }

        @Override
        @NotNull
        public Set<String> keySet() {
            if (!loadedData.containsKey(this.name)) {
                return Set.of();
            }
            return DataLoader.loadedData.get((Object)this.name).data.keySet();
        }

        @Override
        @NotNull
        public Collection<T> values() {
            if (!loadedData.containsKey(this.name)) {
                return Set.of();
            }
            return DataLoader.loadedData.get((Object)this.name).data.values().stream().map(v -> (IDBasedData)v).toList();
        }

        @Override
        @NotNull
        public Set<Map.Entry<String, T>> entrySet() {
            if (!loadedData.containsKey(this.name)) {
                return Set.of();
            }
            return DataLoader.loadedData.get((Object)this.name).data.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry<String, IDBasedData>((String)e.getKey(), (IDBasedData)e.getValue())).collect(Collectors.toCollection(HashSet::new));
        }
    }

    private record GeneralData<T extends IDBasedData>(Class<?> type, DataMap<T> proxyMap, HashMap<String, Object> data, @Nullable Consumer<Map<String, Object>> onReload) {
    }
}

