/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.GrapeshotEntity;
import com.atsuishio.superbwarfare.entity.projectile.GunGrenadeEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.ClientMotionSyncMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CannonShellEntity
extends FastThrowableProjectile
implements GeoEntity,
ExplosiveProjectile {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float damage = 0.0f;
    private float radius = 0.0f;
    private float explosionDamage = 0.0f;
    private float fireProbability = 0.0f;
    private int fireTime = 0;
    private float gravity = 0.1f;
    private Type type = Type.AP;
    private int sparedAmount = 50;
    private int sparedAngle = 15;
    private int sparedTime = 7;

    public CannonShellEntity(EntityType<? extends CannonShellEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public CannonShellEntity(LivingEntity entity, Level world, float damage, float radius, float explosionDamage, float fireProbability, int fireTime, float gravity, Type type, int sparedAmount, int sparedTime, int sparedAngle) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.CANNON_SHELL.get()), (Entity)entity, world);
        this.f_19811_ = true;
        this.damage = damage;
        this.radius = radius;
        this.explosionDamage = explosionDamage;
        this.fireProbability = fireProbability;
        this.fireTime = fireTime;
        this.gravity = gravity;
        this.type = type;
        this.sparedAmount = sparedAmount;
        this.sparedTime = sparedTime;
        this.sparedAngle = sparedAngle;
    }

    public CannonShellEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends CannonShellEntity>)((EntityType)ModEntities.CANNON_SHELL.get()), level);
    }

    public CannonShellEntity durability(int durability) {
        this.durability = durability;
        return this;
    }

    @ParametersAreNonnullByDefault
    public boolean m_20039_(BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("Damage", this.damage);
        pCompound.m_128350_("ExplosionDamage", this.explosionDamage);
        pCompound.m_128350_("Radius", this.radius);
        pCompound.m_128350_("FireProbability", this.fireProbability);
        pCompound.m_128405_("FireTime", this.fireTime);
        pCompound.m_128405_("Durability", this.durability);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Damage")) {
            this.damage = pCompound.m_128457_("Damage");
        }
        if (pCompound.m_128441_("ExplosionDamage")) {
            this.explosionDamage = pCompound.m_128457_("ExplosionDamage");
        }
        if (pCompound.m_128441_("Radius")) {
            this.radius = pCompound.m_128457_("Radius");
        }
        if (pCompound.m_128441_("FireProbability")) {
            this.fireProbability = pCompound.m_128457_("FireProbability");
        }
        if (pCompound.m_128441_("FireTime")) {
            this.fireTime = pCompound.m_128451_("FireTime");
        }
        if (pCompound.m_128441_("Durability")) {
            this.durability = pCompound.m_128451_("Durability");
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.HE_5_INCHES.get();
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            if (this.type != Type.AP) {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
                return;
            }
            BlockPos resultPos = blockHitResult.m_82425_();
            float hardness = this.m_9236_().m_8055_(resultPos).m_60734_().m_155943_();
            if (hardness != -1.0f) {
                if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                    if (this.firstHit) {
                        this.causeExplode(blockHitResult.m_82450_());
                        this.firstHit = false;
                        Mod.queueServerWork(3, () -> ((CannonShellEntity)this).m_146870_());
                    }
                    this.m_9236_().m_46961_(resultPos, true);
                }
            } else {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
            if (!((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
        }
    }

    @Override
    public void m_5790_(@NotNull EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            LivingEntity living;
            Entity entity;
            Entity entity2 = entityHitResult.m_82443_();
            if (this.m_19749_() != null && entity2 == this.m_19749_().m_20202_()) {
                return;
            }
            if (this.type == Type.GRAPE) {
                DamageHandler.doDamage(entity2, ModDamageTypes.causeGrapeShotHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), 0.5f * this.damage);
            } else {
                DamageHandler.doDamage(entity2, ModDamageTypes.causeProjectileHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.damage);
            }
            if (entity2 instanceof LivingEntity) {
                entity2.f_19802_ = 0;
            }
            if ((entity = this.m_19749_()) instanceof LivingEntity && !(living = (LivingEntity)entity).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            ParticleTool.cannonHitParticles(this.m_9236_(), this.m_20182_(), (Entity)this);
            this.causeExplode(entityHitResult.m_82450_());
            if (entity2 instanceof VehicleEntity) {
                this.m_146870_();
            }
        }
    }

    @Override
    public void m_8119_() {
        if (this.type == Type.GRAPE) {
            this.releaseGrapeShot((LivingEntity)this.m_19749_());
        }
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19797_ > 1) {
                double l = this.m_20184_().m_82553_();
                for (double i = 0.0; i < l; i += 1.0) {
                    Vec3 startPos = new Vec3(this.f_19854_, this.f_19855_, this.f_19856_);
                    Vec3 pos = startPos.m_82549_(this.m_20184_().m_82541_().m_82490_(-i));
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.001, true);
                }
            }
        }
        this.destroyBlock();
        if (this.f_19797_ > 600) {
            if (this.m_9236_() instanceof ServerLevel) {
                this.causeExplode(this.m_20182_());
            }
            this.m_146870_();
        }
        if (this.type == Type.CM && this.f_19797_ > 1) {
            Entity target;
            BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)this.sparedTime)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this));
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                this.releaseClusterMunitions((LivingEntity)this.m_19749_());
            }
            if ((target = TraceTool.findLookingEntity((Entity)this, this.m_20184_().m_82490_((double)this.sparedTime).m_82553_())) != null) {
                this.releaseClusterMunitions((LivingEntity)this.m_19749_());
            }
        }
    }

    public void releaseClusterMunitions(LivingEntity shooter) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.spawnMediumExplosionParticles((Level)serverLevel, this.m_20182_());
            for (int index0 = 0; index0 < this.sparedAmount; ++index0) {
                GunGrenadeEntity gunGrenadeEntity = new GunGrenadeEntity((Entity)shooter, (Level)serverLevel, 6.0f * this.damage / (float)this.sparedAmount, 5.0f * this.explosionDamage / (float)this.sparedAmount, this.radius / 2.0f);
                gunGrenadeEntity.m_6034_(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_);
                gunGrenadeEntity.m_6686_(this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_, (float)((double)(this.f_19796_.m_188501_() * 0.2f) + (double)0.4f * this.m_20184_().m_82553_()), this.sparedAngle);
                serverLevel.m_7967_((Entity)gunGrenadeEntity);
            }
            this.m_146870_();
        }
    }

    public void releaseGrapeShot(LivingEntity shooter) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int index0 = 0; index0 < this.sparedAmount; ++index0) {
                GrapeshotEntity grapeProjectileEntity = new GrapeshotEntity((Entity)shooter, (Level)serverLevel, this.damage / (float)this.sparedAmount);
                grapeProjectileEntity.m_6034_(this.f_19854_, this.f_19855_, this.f_19856_);
                grapeProjectileEntity.m_6686_(this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_, (float)((double)(this.f_19796_.m_188501_() * 0.2f) + (double)0.9f * this.m_20184_().m_82553_()), this.sparedAngle);
                serverLevel.m_7967_((Entity)grapeProjectileEntity);
            }
            this.m_146870_();
        }
    }

    @Override
    public void syncMotion() {
        if (!this.m_9236_().f_46443_) {
            Mod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new ClientMotionSyncMessage((Entity)this));
        }
    }

    @Override
    public void causeExplode(Vec3 vec3) {
        new CustomExplosion.Builder((Entity)this).attacker(this.m_19749_()).damage(this.explosionDamage).radius(this.radius).position(vec3).causeVanillaExplosion().withParticleType(this.radius > 9.0f ? ParticleTool.ParticleType.HUGE : ParticleTool.ParticleType.MEDIUM).explode();
        this.m_146870_();
    }

    private PlayState movementPredicate(AnimationState<CannonShellEntity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.cannon_shell.idle"));
    }

    public float m_7139_() {
        return this.gravity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.SHELL_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.07f;
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    @Override
    public void setExplosionDamage(float damage) {
        this.explosionDamage = damage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.radius = radius;
    }

    @Override
    public boolean forceLoadChunk() {
        return true;
    }

    @Override
    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public static enum Type {
        AP,
        HE,
        CM,
        GRAPE;

    }
}

