/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

public class MelonBombEntity
extends FastThrowableProjectile
implements ExplosiveProjectile {
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(MelonBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float explosionDamage = 500.0f;
    private float explosionRadius = 10.0f;
    private float gravity = 0.05f;
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier();

    public MelonBombEntity(EntityType<? extends MelonBombEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public MelonBombEntity(LivingEntity entity, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MELON_BOMB.get()), (Entity)entity, level);
        this.f_19811_ = true;
    }

    public MelonBombEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends MelonBombEntity>)((EntityType)ModEntities.MELON_BOMB.get()), level);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    protected Item m_7881_() {
        return Items.f_42028_;
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        amount = DAMAGE_MODIFIER.compute(source, amount);
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() - amount));
        return super.m_6469_(source, amount);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(10.0f));
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compound.m_128457_("Health")));
        }
        compound.m_128350_("ExplosionDamage", this.explosionDamage);
        compound.m_128350_("Radius", this.explosionRadius);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
        if (compound.m_128441_("ExplosionDamage")) {
            this.explosionDamage = compound.m_128457_("ExplosionDamage");
        }
        if (compound.m_128441_("Radius")) {
            this.explosionRadius = compound.m_128457_("Radius");
        }
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            AABB aabb = new AABB(blockHitResult.m_82450_(), blockHitResult.m_82450_()).m_82400_(5.0);
            BlockPos.m_121921_((AABB)aabb).forEach(pos -> {
                float hard = this.m_9236_().m_8055_(pos).m_60734_().m_155943_();
                if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && hard != -1.0f) {
                    Vec3 vec3 = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                    if (vec3.m_82554_(blockHitResult.m_82450_()) < 3.0) {
                        this.m_9236_().m_46961_(pos, true);
                    }
                }
            });
            ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.5f);
            this.m_146870_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 600 || ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_) {
                ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.5f);
            }
        }
    }

    @Override
    public void setDamage(float damage) {
    }

    @Override
    public void setExplosionDamage(float damage) {
        this.explosionDamage = damage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public float m_7139_() {
        return this.gravity;
    }

    @Override
    public void setGravity(float gravity) {
        this.gravity = gravity;
    }
}

