/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MortarShellEntity
extends FastThrowableProjectile
implements GeoEntity,
ExplosiveProjectile {
    private float damage = 50.0f;
    private float explosionDamage = ((Integer)ExplosionConfig.MORTAR_SHELL_EXPLOSION_DAMAGE.get()).intValue();
    private int life = 600;
    private float radius = ((Integer)ExplosionConfig.MORTAR_SHELL_EXPLOSION_RADIUS.get()).intValue();
    private float gravity = 0.13f;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private Potion potion = Potions.f_43598_;
    private final Set<MobEffectInstance> effects = Sets.newHashSet();

    public MortarShellEntity(EntityType<? extends MortarShellEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public MortarShellEntity(EntityType<? extends MortarShellEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.f_19811_ = true;
    }

    public MortarShellEntity(LivingEntity entity, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MORTAR_SHELL.get()), (Entity)entity, level);
        this.f_19811_ = true;
    }

    public MortarShellEntity(LivingEntity entity, Level world, float explosionDamage) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MORTAR_SHELL.get()), (Entity)entity, world);
        this.f_19811_ = true;
        this.explosionDamage = explosionDamage;
    }

    public MortarShellEntity(LivingEntity entity, Level world, float explosionDamage, float radius) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MORTAR_SHELL.get()), (Entity)entity, world);
        this.f_19811_ = true;
        this.explosionDamage = explosionDamage;
        this.radius = radius;
    }

    public MortarShellEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends MortarShellEntity>)((EntityType)ModEntities.MORTAR_SHELL.get()), level);
    }

    public void setEffectsFromItem(ItemStack pStack) {
        if (pStack.m_150930_((Item)ModItems.POTION_MORTAR_SHELL.get())) {
            this.potion = PotionUtils.m_43579_((ItemStack)pStack);
            List collection = PotionUtils.m_43571_((ItemStack)pStack);
            if (!collection.isEmpty()) {
                for (MobEffectInstance mobeffectinstance : collection) {
                    this.effects.add(new MobEffectInstance(mobeffectinstance));
                }
            }
        } else if (pStack.m_150930_((Item)ModItems.MORTAR_SHELL.get())) {
            this.potion = Potions.f_43598_;
            this.effects.clear();
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("Damage", this.damage);
        pCompound.m_128350_("ExplosionDamage", this.explosionDamage);
        pCompound.m_128405_("Life", this.life);
        pCompound.m_128350_("Radius", this.radius);
        if (this.potion != Potions.f_43598_) {
            pCompound.m_128359_("Potion", ((Comparable)((Object)Objects.requireNonNullElse(ForgeRegistries.POTIONS.getKey((Object)this.potion), "empty"))).toString());
        }
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            pCompound.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.damage = pCompound.m_128441_("Damage") ? pCompound.m_128457_("Damage") : 50.0f;
        this.explosionDamage = pCompound.m_128441_("ExplosionDamage") ? pCompound.m_128457_("ExplosionDamage") : (float)((Integer)ExplosionConfig.MORTAR_SHELL_EXPLOSION_DAMAGE.get()).intValue();
        this.life = pCompound.m_128441_("Life") ? pCompound.m_128451_("Life") : 600;
        this.radius = pCompound.m_128441_("Radius") ? pCompound.m_128457_("Radius") : (float)((Integer)ExplosionConfig.MORTAR_SHELL_EXPLOSION_RADIUS.get()).intValue();
        if (pCompound.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)pCompound);
        }
        this.effects.addAll(PotionUtils.m_43573_((CompoundTag)pCompound));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.MORTAR_SHELL.get();
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    @Override
    public void m_5790_(@NotNull EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (this.f_19797_ > 1) {
            Entity entity = entityHitResult.m_82443_();
            DamageHandler.doDamage(entity, ModDamageTypes.causeProjectileHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.damage);
            if (this.m_9236_() instanceof ServerLevel) {
                this.causeExplode(entityHitResult.m_82450_());
                this.createAreaCloud(this.m_9236_(), entityHitResult.m_82450_());
            }
            this.m_146870_();
        }
    }

    @Override
    public void m_8060_(BlockHitResult blockHitResult) {
        Block block;
        float hardness;
        super.m_8060_(blockHitResult);
        BlockPos resultPos = blockHitResult.m_82425_();
        BlockState state = this.m_9236_().m_8055_(resultPos);
        if (this.m_9236_() instanceof ServerLevel && (hardness = this.m_9236_().m_8055_(resultPos).m_60734_().m_155943_()) != -1.0f && ((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
            this.m_9236_().m_46961_(resultPos, true);
        }
        if ((block = state.m_60734_()) instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            bell.m_49712_(this.m_9236_(), resultPos, blockHitResult.m_82434_());
        }
        if (!this.m_9236_().m_5776_() && this.m_9236_() instanceof ServerLevel && this.f_19797_ > 1) {
            this.causeExplode(blockHitResult.m_82450_());
            this.createAreaCloud(this.m_9236_(), blockHitResult.m_82450_());
        }
        this.m_146870_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19797_ > 1) {
                double l = this.m_20184_().m_82553_();
                for (double i = 0.0; i < l; i += 1.0) {
                    Vec3 startPos = new Vec3(this.f_19854_, this.f_19855_, this.f_19856_);
                    Vec3 pos = startPos.m_82549_(this.m_20184_().m_82541_().m_82490_(i));
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.001, true);
                }
            }
        }
        if (this.f_19797_ > this.life || this.m_20069_()) {
            if (this.m_9236_() instanceof ServerLevel) {
                this.causeExplode(this.m_20182_());
                this.createAreaCloud(this.m_9236_(), this.m_20182_());
            }
            this.m_146870_();
        }
    }

    @Override
    public void causeExplode(Vec3 vec3) {
        new CustomExplosion.Builder((Entity)this).attacker(this.m_19749_()).damage(this.explosionDamage).radius(this.radius).position(vec3).causeVanillaExplosion().withParticleType(ParticleTool.ParticleType.MEDIUM).damageMultiplier(1.25f).explode();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private void createAreaCloud(Level level, Vec3 pos) {
        if (this.potion == Potions.f_43598_) {
            return;
        }
        AreaEffectCloud cloud = new AreaEffectCloud(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        cloud.m_19722_(this.potion);
        cloud.m_19734_((int)this.explosionDamage);
        cloud.m_19712_(this.radius);
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            cloud.m_19718_(living);
        }
        level.m_7967_((Entity)cloud);
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.SHELL_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.06f;
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    @Override
    public void setExplosionDamage(float explosionDamage) {
        this.explosionDamage = explosionDamage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.radius = radius;
    }

    public float m_7139_() {
        return this.gravity;
    }

    @Override
    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    @Override
    public boolean forceLoadChunk() {
        return true;
    }
}

