/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.WgMissileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.WgMissileWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import java.io.Serializable;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Bmp2Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity,
OBBEntity {
    public static final EntityDataAccessor<Integer> CANNON_FIRE_TIME = SynchedEntityData.m_135353_(Bmp2Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_MISSILE = SynchedEntityData.m_135353_(Bmp2Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MISSILE_COUNT = SynchedEntityData.m_135353_(Bmp2Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int reloadCoolDown;
    public OBB obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.1875f, 0.875f, 3.90625f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.1875f, 0.5f, 0.65625f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.375f, 0.78125f, 3.46875f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
    public OBB obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.375f, 0.78125f, 3.46875f), new Quaternionf(), OBB.Part.WHEEL_RIGHT);
    public OBB obb5 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.15625f, 0.375f, 1.125f), new Quaternionf(), OBB.Part.ENGINE1);
    public OBB obbTurret = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.5f, 0.34375f, 1.5f), new Quaternionf(), OBB.Part.TURRET);

    public Bmp2Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Bmp2Entity>)((EntityType)ModEntities.BMP_2.get()), world);
    }

    public Bmp2Entity(EntityType<Bmp2Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new SmallCannonShellWeapon().damage(((Integer)VehicleConfig.BMP_2_CANNON_DAMAGE.get()).intValue()).explosionDamage(((Integer)VehicleConfig.BMP_2_CANNON_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.BMP_2_CANNON_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).icon(Mod.loc("textures/screens/vehicle_weapon/cannon_30mm.png")).sound1p((SoundEvent)ModSounds.BMP_CANNON_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.BMP_CANNON_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.LAV_CANNON_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.LAV_CANNON_VERYFAR.get()), new ProjectileWeapon().damage(9.5f).headShot(2.0f).zoom(false).sound((SoundEvent)ModSounds.INTO_CANNON.get()).icon(Mod.loc("textures/screens/vehicle_weapon/gun_7_62mm.png")).sound1p((SoundEvent)ModSounds.COAX_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.M_60_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.M_60_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M_60_VERYFAR.get()), new WgMissileWeapon().damage(((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_DAMAGE.get()).intValue()).explosionDamage(((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_RADIUS.get()).intValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).sound1p((SoundEvent)ModSounds.BMP_MISSILE_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.BMP_MISSILE_FIRE_3P.get())}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(3.0 + ClientMouseHandler.custom3pDistanceLerp, 1.0, 0.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CANNON_FIRE_TIME, (Object)0);
        this.f_19804_.m_135372_(LOADED_MISSILE, (Object)0);
        this.f_19804_.m_135372_(MISSILE_COUNT, (Object)0);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("LoadedMissile", ((Integer)this.f_19804_.m_135370_(LOADED_MISSILE)).intValue());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LOADED_MISSILE, (Object)compound.m_128451_("LoadedMissile"));
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.4f) * damage.floatValue()));
    }

    @ParametersAreNonnullByDefault
    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.15), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        this.updateOBB();
        if (this.getLeftTrack() < 0.0f) {
            this.setLeftTrack(100.0f);
        }
        if (this.getLeftTrack() > 100.0f) {
            this.setLeftTrack(0.0f);
        }
        if (this.getRightTrack() < 0.0f) {
            this.setRightTrack(100.0f);
        }
        if (this.getRightTrack() > 100.0f) {
            this.setRightTrack(0.0f);
        }
        if (this.m_9236_() instanceof ServerLevel) {
            if (this.reloadCoolDown > 0) {
                --this.reloadCoolDown;
            }
            this.handleAmmo();
        }
        this.turretAngle(10.0f, 12.5f);
        this.terrainCompact(4.0f, 5.0f);
        this.inertiaRotate(1.0f);
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
        this.lowHealthWarning();
        this.m_6210_();
    }

    @Override
    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.07 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.12;
    }

    private void handleAmmo() {
        Entity entity = this.m_146895_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int ammoCount = this.m_213659_().stream().filter(stack -> {
            if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                return Ammo.RIFLE.get((ItemStack)stack) > 0;
            }
            return false;
        }).mapToInt(Ammo.RIFLE::get).sum() + this.m_18947_((Item)ModItems.RIFLE_AMMO.get());
        if ((this.hasItem((Item)ModItems.WIRE_GUIDE_MISSILE.get()) || InventoryTool.hasCreativeAmmoBox((Entity)player)) && this.reloadCoolDown <= 0 && (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) < 1) {
            this.f_19804_.m_135381_(LOADED_MISSILE, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) + 1));
            this.reloadCoolDown = 160;
            if (!InventoryTool.hasCreativeAmmoBox((Entity)player)) {
                this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.WIRE_GUIDE_MISSILE.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.BMP_MISSILE_RELOAD.get(), this.m_5720_(), 1.0f, 1.0f);
        }
        if (this.getWeaponIndex(0) == 0) {
            this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_((Item)ModItems.SMALL_SHELL.get()));
        } else if (this.getWeaponIndex(0) == 1) {
            this.f_19804_.m_135381_(AMMO, (Object)ammoCount);
        } else {
            this.f_19804_.m_135381_(AMMO, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE)));
        }
        this.f_19804_.m_135381_(MISSILE_COUNT, (Object)this.m_18947_((Item)ModItems.WIRE_GUIDE_MISSILE.get()));
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
            hasCreativeAmmo = true;
        }
        Matrix4f transform = this.getBarrelTransform(1.0f);
        if (this.getWeaponIndex(0) == 0) {
            if (this.cannotFire) {
                return;
            }
            float x = -0.45f;
            float y = 0.4f;
            float z = 4.2f;
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            SmallCannonShellEntity smallCannonShell = ((SmallCannonShellWeapon)this.getWeapon(0)).create((LivingEntity)player);
            smallCannonShell.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
            smallCannonShell.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.005f, this.getBarrelVector((float)1.0f).f_82481_, 35.0f, 0.25f);
            this.m_9236_().m_7967_((Entity)smallCannonShell);
            ParticleTool.sendParticle((ServerLevel)this.m_9236_(), ParticleTypes.f_123755_, (double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_, 1, 0.02, 0.02, 0.02, 0.0, false);
            if (!player.m_9236_().f_46443_) {
                this.playShootSound3p(player, 0, 4, 12, 24);
            }
            ShakeClientMessage.sendToNearbyPlayers(this, 5.0, 6.0, 5.0, 9.0);
            this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)40);
            this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.getTurretYRot()));
            this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 7));
            this.f_19804_.m_135381_(FIRE_ANIM, (Object)3);
            if (hasCreativeAmmo) {
                return;
            }
            this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
        } else if (this.getWeaponIndex(0) == 1) {
            if (this.cannotFireCoax) {
                return;
            }
            float x = -0.2f;
            float y = 0.3f;
            float z = 1.2f;
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            if ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || hasCreativeAmmo) {
                ProjectileEntity projectileRight = ((ProjectileWeapon)this.getWeapon(0)).create((LivingEntity)player).setGunItemId(this.m_6095_().m_20675_());
                projectileRight.bypassArmorRate(0.2f);
                projectileRight.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
                projectileRight.shoot(player, this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.002f, this.getBarrelVector((float)1.0f).f_82481_, 36.0f, 0.25f);
                this.m_9236_().m_7967_((Entity)projectileRight);
                if (!hasCreativeAmmo) {
                    ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                        if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                            return Ammo.RIFLE.get((ItemStack)stack) > 0;
                        }
                        return false;
                    }).findFirst().orElse(ItemStack.f_41583_);
                    if (!ammoBox.m_41619_()) {
                        Ammo.RIFLE.add(ammoBox, -1);
                    } else {
                        this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.RIFLE_AMMO.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
                    }
                }
            }
            this.f_19804_.m_135381_(COAX_HEAT, (Object)((Integer)this.f_19804_.m_135370_(COAX_HEAT) + 3));
            this.f_19804_.m_135381_(FIRE_ANIM, (Object)2);
            if (!player.m_9236_().f_46443_) {
                this.playShootSound3p(player, 0, 3, 6, 12);
            }
        } else if (this.getWeaponIndex(0) == 2 && (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) > 0) {
            Matrix4f transformT = this.getBarrelTransform(1.0f);
            Vector4f worldPosition = this.transformPosition(transformT, 0.0f, 1.0f, 0.0f);
            WgMissileEntity wgMissileEntity = ((WgMissileWeapon)this.getWeapon(0)).create((LivingEntity)player);
            wgMissileEntity.m_6034_(worldPosition.x, worldPosition.y, worldPosition.z);
            wgMissileEntity.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, 2.0f, 0.0f);
            player.m_9236_().m_7967_((Entity)wgMissileEntity);
            if (!player.m_9236_().f_46443_) {
                this.playShootSound3p(player, 0, 6, 0, 0);
            }
            this.f_19804_.m_135381_(LOADED_MISSILE, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) - 1));
            this.reloadCoolDown = 160;
        }
    }

    @Override
    public void travel() {
        this.trackEngine(true, 0.052, (Integer)VehicleConfig.BMP_2_ENERGY_COST.get(), 1.25, 0.5, 1.9, 0.8, 0.21f, -0.16f, 0.0024f, 0.0024f, 0.1f);
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.BMP_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return Math.max((float)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()), (float)Mth.m_14154_((float)(0.1f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        Matrix4f transformV = this.getVehicleTransform(1.0f);
        int i = this.getSeatIndex(passenger);
        Vector4f worldPosition = i == 0 ? this.transformPosition(transform, 0.36f, -0.25f, 0.56f) : this.transformPosition(transformV, 0.0f, 1.0f, 0.0f);
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
    }

    @Override
    public int getMaxPassengers() {
        return 7;
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getTurretTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.75f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 getNewEyePos(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.65f, 0.75f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.3625f, 0.293125f, 1.18095f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    @Override
    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.25f, -0.703125f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    @Override
    public float rotateYOffset() {
        return 2.7f;
    }

    protected void clampRotation(Entity entity) {
        float a = this.getTurretYaw(1.0f);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float min = -74.0f - r * this.m_146909_() - r2 * this.getRoll();
        float max = 7.5f - r * this.m_146909_() - r2 * this.getRoll();
        float f = Mth.m_14177_((float)entity.m_146909_());
        float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
        entity.f_19860_ += f1 - f;
        entity.m_146926_(entity.m_146909_() + f1 - f);
        entity.m_5618_(this.getBarrelYRot(1.0f));
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState firePredicate(AnimationState<Bmp2Entity> event) {
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 1 && this.getWeaponIndex(0) == 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.lav.fire"));
        }
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 0 && this.getWeaponIndex(0) == 1) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.lav.fire2"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.lav.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::firePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int mainGunRpm(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return 250;
        }
        if (this.getWeaponIndex(0) == 1) {
            return 750;
        }
        return 250;
    }

    @Override
    public boolean canShoot(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)player)) && !this.cannotFire;
        }
        if (this.getWeaponIndex(0) == 1) {
            return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)player)) && !this.cannotFireCoax;
        }
        if (this.getWeaponIndex(0) == 2) {
            return (Integer)this.f_19804_.m_135370_(LOADED_MISSILE) > 0;
        }
        return false;
    }

    @Override
    public int getAmmoCount(Player player) {
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    @Override
    public boolean banHand(Player player) {
        return true;
    }

    @Override
    public boolean hidePassenger(int index) {
        return true;
    }

    @Override
    public int zoomFov() {
        return 3;
    }

    @Override
    public int getWeaponHeat(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return (Integer)this.f_19804_.m_135370_(HEAT);
        }
        if (this.getWeaponIndex(0) == 1) {
            return (Integer)this.f_19804_.m_135370_(COAX_HEAT);
        }
        return 0;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/bmp2_icon.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        super.renderFirstPersonOverlay(guiGraphics, font, player, screenWidth, screenHeight, scale);
        if (this.getWeaponIndex(0) == 0) {
            double heat = 1.0f - (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" 30MM 2A42 " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.m_14169_((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 1) {
            double heat = 1.0f - (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" 7.62MM \u041f\u041a\u0422 " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.m_14169_((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        } else {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("    9M113  " + this.m_20088_().m_135370_(LOADED_MISSILE) + " " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(MISSILE_COUNT)))), screenWidth / 2 - 33, screenHeight - 65, 0x66FF00, false);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        if (this.getWeaponIndex(0) == 0) {
            double heat = (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("30MM 2A42 " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat), (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 1) {
            double heat2 = (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("7.62MM \u041f\u041a\u0422 " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat2), (float)1.0f), false);
        } else {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("9M113 " + this.m_20088_().m_135370_(LOADED_MISSILE) + " " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(MISSILE_COUNT)))), 30, -9, -1, false);
        }
    }

    @Override
    public boolean hasTracks() {
        return true;
    }

    @Override
    public boolean hasDecoy() {
        return true;
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.22 : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? 0.27 : 0.36);
    }

    @Override
    public boolean isEnclosed(int index) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                return new Vec2((float)(-Bmp2Entity.getYRotFromVector(this.getBarrelVec(partialTicks))), (float)(-Bmp2Entity.getXRotFromVector(this.getBarrelVec(partialTicks))));
            }
            return new Vec2(Mth.m_14179_((float)partialTicks, (float)player.f_20886_, (float)player.m_6080_()), Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                if (zoom) {
                    return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), this.driverZoomPos((float)partialTicks).f_82481_);
                }
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
            return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - 6.0 * player.m_20252_((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_() + 1.0), (double)(player.m_20188_() + 1.0)) - 6.0 * player.m_20252_((float)partialTicks).f_82480_, Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - 6.0 * player.m_20252_((float)partialTicks).f_82481_);
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/land.png");
    }

    @Override
    public List<OBB> getOBBs() {
        return List.of(this.obb, this.obb2, this.obb3, this.obb4, this.obb5, this.obbTurret);
    }

    @Override
    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.5f, -0.28125f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 1.5625f, 4.28125f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition3 = this.transformPosition(transform, 1.9375f, 0.84375f, 0.15625f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition4 = this.transformPosition(transform, -1.9375f, 0.84375f, 0.15625f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition5 = this.transformPosition(transform, -1.09375f, 2.0625f, 1.75f);
        this.obb5.center().set((Vector3fc)new Vector3f(worldPosition5.x, worldPosition5.y, worldPosition5.z));
        this.obb5.setRotation(VectorTool.combineRotations(1.0f, this));
        Matrix4f transformT = this.getTurretTransform(1.0f);
        Vector4f worldPositionT = this.transformPosition(transformT, 0.0f, 0.46875f, 0.0f);
        this.obbTurret.center().set((Vector3fc)new Vector3f(worldPositionT.x, worldPositionT.y, worldPositionT.z));
        this.obbTurret.setRotation(VectorTool.combineRotationsTurret(1.0f, this));
    }
}

