/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.CannonShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArtilleryEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.CannonEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.RemoteControllableTurret;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.CannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.ArtilleryIndicator;
import com.atsuishio.superbwarfare.item.common.ammo.CannonShellItem;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Mk42Entity
extends VehicleEntity
implements GeoEntity,
CannonEntity,
RemoteControllableTurret,
ArtilleryEntity {
    public static final EntityDataAccessor<Integer> COOL_DOWN = SynchedEntityData.m_135353_(Mk42Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(Mk42Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(Mk42Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> DEPRESSED = SynchedEntityData.m_135353_(Mk42Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Vector3f> TARGET_POS = SynchedEntityData.m_135353_(Mk42Entity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.m_135353_(Mk42Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> AMMO_COUNT = SynchedEntityData.m_135353_(Mk42Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Mk42Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Mk42Entity>)((EntityType)ModEntities.MK_42.get()), world);
    }

    public Mk42Entity(EntityType<Mk42Entity> type, Level world) {
        super(type, world);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.m_146908_()));
        this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(this.m_146909_()));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COOL_DOWN, (Object)0);
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DEPRESSED, (Object)false);
        this.f_19804_.m_135372_(TARGET_POS, (Object)new Vector3f());
        this.f_19804_.m_135372_(RADIUS, (Object)0);
        this.f_19804_.m_135372_(AMMO_COUNT, (Object)0);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new CannonShellWeapon().hitDamage(((Integer)VehicleConfig.MK42_AP_DAMAGE.get()).intValue()).explosionDamage(((Integer)VehicleConfig.MK42_AP_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Integer)VehicleConfig.MK42_AP_EXPLOSION_RADIUS.get()).floatValue()).durability(60).gravity(this.projectileGravity()).sound((SoundEvent)ModSounds.CANNON_RELOAD.get()).icon(Mod.loc("textures/screens/vehicle_weapon/ap_shell.png")), new CannonShellWeapon().hitDamage(((Integer)VehicleConfig.MK42_HE_DAMAGE.get()).intValue()).explosionDamage(((Integer)VehicleConfig.MK42_HE_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Integer)VehicleConfig.MK42_HE_EXPLOSION_RADIUS.get()).floatValue()).durability(1).fireProbability(0.18f).fireTime(2).gravity(this.projectileGravity()).sound((SoundEvent)ModSounds.CANNON_RELOAD.get()).icon(Mod.loc("textures/screens/vehicle_weapon/he_shell.png")), new CannonShellWeapon().hitDamage(((Integer)VehicleConfig.MK42_HE_DAMAGE.get()).intValue()).explosionDamage(((Integer)VehicleConfig.MK42_HE_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Integer)VehicleConfig.MK42_HE_EXPLOSION_RADIUS.get()).floatValue()).durability(1).gravity(this.projectileGravity()).type(CannonShellEntity.Type.CM).spreadAmount(30).spreadTime(7).spreadAngle(15).sound((SoundEvent)ModSounds.CANNON_RELOAD.get()).icon(Mod.loc("textures/screens/vehicle_weapon/cm_shell.png")), new CannonShellWeapon().hitDamage(700.0f).explosionDamage(((Integer)VehicleConfig.MK42_AP_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Integer)VehicleConfig.MK42_AP_EXPLOSION_RADIUS.get()).floatValue()).velocity(30.0f).type(CannonShellEntity.Type.GRAPE).spreadAmount(30).spreadAngle(3).sound((SoundEvent)ModSounds.INTO_CANNON.get()).ammo((Item)ModItems.GS_5_INCHES.get()).icon(Mod.loc("textures/screens/vehicle_weapon/grape_shell.png"))}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(8.0 + ClientMouseHandler.custom3pDistanceLerp, 1.0, 0.0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("CoolDown", ((Integer)this.f_19804_.m_135370_(COOL_DOWN)).intValue());
        compound.m_128350_("Pitch", ((Float)this.f_19804_.m_135370_(PITCH)).floatValue());
        compound.m_128350_("Yaw", ((Float)this.f_19804_.m_135370_(YAW)).floatValue());
        compound.m_128379_("Depressed", ((Boolean)this.f_19804_.m_135370_(DEPRESSED)).booleanValue());
        compound.m_128405_("Radius", ((Integer)this.f_19804_.m_135370_(RADIUS)).intValue());
        compound.m_128350_("TargetX", ((Vector3f)this.f_19804_.m_135370_(Mk42Entity.TARGET_POS)).x);
        compound.m_128350_("TargetY", ((Vector3f)this.f_19804_.m_135370_(Mk42Entity.TARGET_POS)).y);
        compound.m_128350_("TargetZ", ((Vector3f)this.f_19804_.m_135370_(Mk42Entity.TARGET_POS)).z);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(COOL_DOWN, (Object)compound.m_128451_("CoolDown"));
        this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(compound.m_128457_("Pitch")));
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(compound.m_128457_("Yaw")));
        if (compound.m_128441_("Depressed")) {
            this.f_19804_.m_135381_(DEPRESSED, (Object)compound.m_128471_("Depressed"));
        }
        if (compound.m_128441_("Radius")) {
            this.f_19804_.m_135381_(RADIUS, (Object)compound.m_128451_("Radius"));
        }
        if (compound.m_128441_("TargetX") && compound.m_128441_("TargetY") && compound.m_128441_("TargetZ")) {
            this.f_19804_.m_135381_(TARGET_POS, (Object)new Vector3f(compound.m_128457_("TargetX"), compound.m_128457_("TargetX"), compound.m_128457_("TargetZ")));
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof ArtilleryIndicator) {
            ArtilleryIndicator indicator = (ArtilleryIndicator)item;
            return indicator.bind(stack, player, this);
        }
        if (stack.m_204117_(ModTags.Items.CROWBAR) && !player.m_6144_()) {
            if (((ItemStack)this.items.get(0)).m_41720_() instanceof CannonShellItem) {
                ItemStack item2 = this.m_8020_(0);
                int type = 0;
                if (item2.m_150930_((Item)ModItems.HE_5_INCHES.get())) {
                    type = 1;
                } else if (item2.m_150930_((Item)ModItems.CM_5_INCHES.get())) {
                    type = 2;
                } else if (item2.m_150930_((Item)ModItems.GS_5_INCHES.get())) {
                    type = 3;
                }
                this.setWeaponIndex(0, type);
                this.vehicleShoot(player, 0);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() instanceof CannonShellItem) {
            if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) == 0 && ((ItemStack)this.items.get(0)).m_41619_()) {
                this.m_6836_(0, stack.m_255036_(1));
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.CANNON_RELOAD.get(), 2.0f, 1.0f);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_21205_().m_41720_() == ModItems.FIRING_PARAMETERS.get()) {
            this.setTarget(player.m_21205_(), (Entity)player);
        }
        if (player.m_21206_().m_41720_() == ModItems.FIRING_PARAMETERS.get()) {
            this.setTarget(player.m_21205_(), (Entity)player);
        }
        return super.m_6096_(player, hand);
    }

    @Override
    public void setTarget(ItemStack stack, Entity entity) {
        double targetX = stack.m_41784_().m_128459_("TargetX");
        double targetY = stack.m_41784_().m_128459_("TargetY");
        double targetZ = stack.m_41784_().m_128459_("TargetZ");
        boolean canAim = true;
        this.f_19804_.m_135381_(TARGET_POS, (Object)new Vector3f((float)targetX, (float)targetY, (float)targetZ));
        this.f_19804_.m_135381_(DEPRESSED, (Object)stack.m_41784_().m_128471_("IsDepressed"));
        this.f_19804_.m_135381_(RADIUS, (Object)stack.m_41784_().m_128451_("Radius"));
        Vec3 randomPos = VectorTool.randomPos(new Vec3((Vector3f)this.f_19804_.m_135370_(TARGET_POS)), (Integer)this.f_19804_.m_135370_(RADIUS));
        Vec3 launchVector = RangeTool.calculateLaunchVector(this.m_146892_(), randomPos, this.shootVelocity(), this.projectileGravity(), (Boolean)this.f_19804_.m_135370_(DEPRESSED));
        MutableComponent component = Component.m_237113_((String)"");
        MutableComponent location = Component.m_237110_((String)"tips.superbwarfare.mortar.position", (Object[])new Object[]{this.m_5446_()}).m_7220_((Component)Component.m_237113_((String)(" X:" + FormatTool.format0D(this.m_20185_()) + " Y:" + FormatTool.format0D(this.m_20186_()) + " Z:" + FormatTool.format0D(this.m_20189_()) + " ")));
        float angle = this.m_146909_();
        if (launchVector == null) {
            canAim = false;
            component = Component.m_237115_((String)"tips.superbwarfare.mortar.out_of_range");
        } else {
            angle = (float)(-Mk42Entity.getXRotFromVector(launchVector));
            if ((double)angle < -this.maxPitch() || (double)angle > -this.minPitch()) {
                canAim = false;
                component = Component.m_237110_((String)"tips.superbwarfare.mortar.warn", (Object[])new Object[]{this.m_5446_()});
                if ((double)angle < -this.maxPitch()) {
                    component = Component.m_237115_((String)"tips.superbwarfare.ballistics.warn");
                }
            }
        }
        if (canAim) {
            this.look(randomPos);
            this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(angle));
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)location.m_6881_().m_7220_((Component)component).m_130940_(ChatFormatting.RED), false);
        }
    }

    @Override
    public void resetTarget() {
        Vec3 randomPos = VectorTool.randomPos(new Vec3((Vector3f)this.f_19804_.m_135370_(TARGET_POS)), (Integer)this.f_19804_.m_135370_(RADIUS));
        Vec3 launchVector = RangeTool.calculateLaunchVector(this.m_146892_(), randomPos, 15.0, this.projectileGravity(), (Boolean)this.f_19804_.m_135370_(DEPRESSED));
        this.look(randomPos);
        if (launchVector == null) {
            return;
        }
        float angle = (float)(-Mk42Entity.getXRotFromVector(launchVector));
        if ((double)angle > -this.maxPitch() && (double)angle < -this.minPitch()) {
            this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(angle));
        }
    }

    @Override
    public double minPitch() {
        return -14.9;
    }

    @Override
    public double maxPitch() {
        return 85.0;
    }

    @Override
    public double shootVelocity() {
        return 15.0;
    }

    @Override
    public float projectileGravity() {
        return 0.1f;
    }

    @Override
    public void look(Vec3 pTarget) {
        Matrix4f transform = this.getVehicleFlatTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.16f, 0.5175f);
        Vec3 shootPos = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        double d0 = pTarget.f_82479_ - shootPos.f_82479_;
        double d2 = pTarget.f_82481_ - shootPos.f_82481_;
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f))));
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 1.0f) * damage.floatValue()));
    }

    @NotNull
    public Vec3 m_20184_() {
        return new Vec3(0.0, Math.min((double)super.m_20184_().f_82480_, (double)0.0), 0.0);
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 0) {
            this.f_19804_.m_135381_(COOL_DOWN, (Object)((Integer)this.f_19804_.m_135370_(COOL_DOWN) - 1));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_()) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.countAmmo();
        this.lowHealthWarning();
    }

    public void countAmmo() {
        if (this.m_9236_() instanceof ServerLevel) {
            int ammoCount = switch (this.getWeaponIndex(0)) {
                case 1 -> this.m_18947_((Item)ModItems.HE_5_INCHES.get());
                case 2 -> this.m_18947_((Item)ModItems.CM_5_INCHES.get());
                case 3 -> this.m_18947_((Item)ModItems.GS_5_INCHES.get());
                default -> this.m_18947_((Item)ModItems.AP_5_INCHES.get());
            };
            this.f_19804_.m_135381_(AMMO_COUNT, (Object)ammoCount);
        }
    }

    @Override
    public void handleClientSync() {
        if (this.m_6109_()) {
            this.interpolationSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedYaw = Mth.m_14175_((double)(this.serverYRot - (double)this.m_146908_()));
        this.m_146922_(this.m_146908_() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.m_146926_(this.m_146909_() + (float)(this.serverXRot - (double)this.m_146909_()) / (float)this.interpolationSteps);
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }

    @Override
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleFlatTransform(1.0f);
        float x = 0.0f;
        float y = 2.3f;
        float z = 0.0f;
        Vector4f worldPosition = this.transformPosition(transform, x, y, z);
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getVehicleFlatTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 3.56f, 0.5175f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public boolean canRemoteFire() {
        return this.m_8020_(0).m_41720_() instanceof CannonShellItem && (Integer)this.f_19804_.m_135370_(COOL_DOWN) == 0;
    }

    @Override
    public void remoteFire(@Nullable Player player) {
        ItemStack stack = this.m_8020_(0);
        int type = 0;
        if (stack.m_150930_((Item)ModItems.HE_5_INCHES.get())) {
            type = 1;
        } else if (stack.m_150930_((Item)ModItems.CM_5_INCHES.get())) {
            type = 2;
        } else if (stack.m_150930_((Item)ModItems.GS_5_INCHES.get())) {
            type = 3;
        }
        this.setWeaponIndex(0, type);
        this.shoot(player, 0, true);
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        this.shoot(player, type, false);
    }

    public void shoot(Player player, int type, boolean reset) {
        if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 0) {
            return;
        }
        if (this.m_146895_() != null && this.m_146895_() != player) {
            return;
        }
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!InventoryTool.hasCreativeAmmoBox((Entity)player) && player == this.m_146895_()) {
                if ((Integer)this.f_19804_.m_135370_(AMMO_COUNT) > 0) {
                    ((ItemStack)this.items.get(0)).m_41774_(1);
                } else {
                    Item ammo = switch (this.getWeaponIndex(0)) {
                        case 1 -> (Item)ModItems.HE_5_INCHES.get();
                        case 2 -> (Item)ModItems.CM_5_INCHES.get();
                        case 3 -> (Item)ModItems.GS_5_INCHES.get();
                        default -> (Item)ModItems.AP_5_INCHES.get();
                    };
                    int ammoCount = InventoryTool.countItem((NonNullList<ItemStack>)player.m_150109_().f_35974_, ammo);
                    if (ammoCount <= 0) {
                        return;
                    }
                    InventoryTool.consumeItem((NonNullList<ItemStack>)player.m_150109_().f_35974_, ammo, 1);
                }
            }
            if (this.m_146895_() != player) {
                this.m_6211_();
            }
            CannonShellEntity entityToSpawn = ((CannonShellWeapon)this.getWeapon(0)).create(player);
            Matrix4f transform = this.getVehicleFlatTransform(1.0f);
            Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.16f, 0.5175f);
            entityToSpawn.m_6034_(worldPosition.x, worldPosition.y, worldPosition.z);
            entityToSpawn.m_6686_(this.m_20154_().f_82479_, this.m_20154_().f_82480_, this.m_20154_().f_82481_, 15.0f, 0.05f);
            level.m_7967_((Entity)entityToSpawn);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (player == this.m_146895_()) {
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.MK_42_FIRE_1P.get(), 2.0f, 1.0f);
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.CANNON_RELOAD.get(), 2.0f, 1.0f);
                }
            }
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.MK_42_FIRE_3P.get(), SoundSource.PLAYERS, 24.0f, 1.0f);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.MK_42_FAR.get(), SoundSource.PLAYERS, 48.0f, 1.0f);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.MK_42_VERYFAR.get(), SoundSource.PLAYERS, 96.0f, 1.0f);
            }
            this.f_19804_.m_135381_(COOL_DOWN, (Object)30);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + 5.0 * this.m_20154_().f_82479_, this.m_20186_(), this.m_20189_() + 5.0 * this.m_20154_().f_82481_, 100, 7.0, 0.02, 7.0, 0.005);
            double x = (double)worldPosition.x + 9.0 * this.m_20154_().f_82479_;
            double y = (double)worldPosition.y + 9.0 * this.m_20154_().f_82480_;
            double z = (double)worldPosition.z + 9.0 * this.m_20154_().f_82481_;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, 10, 0.4, 0.4, 0.4, 0.0075);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 10, 0.4, 0.4, 0.4, 0.0075);
            int count = 6;
            for (float i = 9.5f; i < 16.0f; i += 0.5f) {
                server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + (double)i * this.m_20154_().f_82479_, this.m_20188_() + (double)i * this.m_20154_().f_82480_, this.m_20189_() + (double)i * this.m_20154_().f_82481_, Mth.m_14045_((int)count--, (int)1, (int)5), 0.15, 0.15, 0.15, 0.0025);
            }
            ShakeClientMessage.sendToNearbyPlayers(this, 20.0, 15.0, 15.0, 45.0);
            if (reset) {
                this.resetTarget();
            }
        }
    }

    @Override
    public void travel() {
        Entity passenger = this.m_146895_();
        if (passenger != null) {
            this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(passenger.m_6080_()));
            this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(passenger.m_146909_() - 2.0f));
        }
        float diffY = Mth.m_14177_((float)(((Float)this.f_19804_.m_135370_(YAW)).floatValue() - this.m_146908_()));
        float diffX = Mth.m_14177_((float)(((Float)this.f_19804_.m_135370_(PITCH)).floatValue() - this.m_146909_()));
        this.turretTurnSound(diffX, diffY, 0.95f);
        this.m_146922_(this.m_146908_() + Mth.m_14036_((float)(0.5f * diffY), (float)-1.75f, (float)1.75f));
        this.m_146926_(Mth.m_14036_((float)(this.m_146909_() + Mth.m_14036_((float)(0.5f * diffX), (float)-3.0f, (float)3.0f)), (float)-85.0f, (float)15.0f));
    }

    protected void clampRotation(Entity entity) {
        float f = Mth.m_14177_((float)entity.m_146909_());
        float f1 = Mth.m_14036_((float)f, (float)-85.0f, (float)17.0f);
        entity.f_19860_ += f1 - f;
        entity.m_146926_(entity.m_146909_() + f1 - f);
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState movementPredicate(AnimationState<Mk42Entity> event) {
        if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mk42.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mk42.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int mainGunRpm(Player player) {
        return 0;
    }

    @Override
    public boolean canShoot(Player player) {
        return true;
    }

    @Override
    public int getAmmoCount(Player player) {
        int playerAmmo = 0;
        if (player == this.m_146895_()) {
            Item ammo = switch (this.getWeaponIndex(0)) {
                case 1 -> (Item)ModItems.HE_5_INCHES.get();
                case 2 -> (Item)ModItems.CM_5_INCHES.get();
                case 3 -> (Item)ModItems.GS_5_INCHES.get();
                default -> (Item)ModItems.AP_5_INCHES.get();
            };
            playerAmmo = InventoryTool.countItem((NonNullList<ItemStack>)player.m_150109_().f_35974_, ammo);
        }
        return playerAmmo + (Integer)this.f_19804_.m_135370_(AMMO_COUNT);
    }

    @Override
    public boolean hidePassenger(int index) {
        return true;
    }

    @Override
    public int zoomFov() {
        return 5;
    }

    @Override
    public int getWeaponHeat(Player player) {
        return 0;
    }

    @Override
    public Vec3 getBarrelVector(float pPartialTicks) {
        if (this.m_146895_() != null) {
            return this.m_146895_().m_20252_(pPartialTicks);
        }
        return super.getBarrelVector(pPartialTicks);
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/sherman_icon.png");
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.15 : 0.3;
    }

    @Override
    public boolean isEnclosed(int index) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            return new Vec2(Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()), Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (zoom) {
                return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, this.driverZoomPos((float)partialTicks).f_82480_, this.driverZoomPos((float)partialTicks).f_82481_);
            }
            return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return true;
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/defense.png");
    }

    @Override
    public int m_6643_() {
        return 1;
    }

    public int m_6893_() {
        return 1;
    }

    @Override
    public void m_6596_() {
    }

    @Override
    public boolean m_6542_(@NotNull Player player) {
        return false;
    }

    @Override
    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        return super.m_7013_(slot, stack) && (Integer)this.f_19804_.m_135370_(COOL_DOWN) == 0 && stack.m_41720_() instanceof CannonShellItem;
    }
}

