/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.menu.VehicleMenu;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public abstract class ContainerMobileVehicleEntity
extends MobileVehicleEntity
implements HasCustomInventoryScreen,
ContainerEntity {
    public static final int DEFAULT_CONTAINER_SIZE = 102;

    @Override
    public int m_6643_() {
        return 102;
    }

    public ContainerMobileVehicleEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.m_213659_());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        ContainerHelper.m_18980_((CompoundTag)compound, this.m_213659_());
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        if (player.m_20202_() == this) {
            return InteractionResult.PASS;
        }
        if (this.hasMenu() && player.m_6144_() && !player.m_21205_().m_204117_(ModTags.Items.CROWBAR)) {
            player.m_5893_((MenuProvider)this);
            return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
        }
        return super.m_6096_(player, hand);
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        if (!this.m_9236_().f_46443_ && pReason != Entity.RemovalReason.DISCARDED) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(pReason);
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (this.hasEnergyStorage() && this.f_19797_ % 20 == 0) {
            for (ItemStack stack : this.m_213659_()) {
                IEnergyStorage energyStorage;
                int stored;
                int neededEnergy = this.getMaxEnergy() - this.getEnergy();
                if (neededEnergy <= 0) break;
                Optional energyCap = stack.getCapability(ForgeCapabilities.ENERGY).resolve();
                if (energyCap.isEmpty() || (stored = (energyStorage = (IEnergyStorage)energyCap.get()).getEnergyStored()) <= 0) continue;
                int energyToExtract = Math.min((int)stored, (int)neededEnergy);
                energyStorage.extractEnergy(energyToExtract, false);
                this.setEnergy(this.getEnergy() + energyToExtract);
            }
        }
        this.m_6210_();
    }

    public void m_213583_(Player pPlayer) {
        pPlayer.m_5893_((MenuProvider)this);
        if (!pPlayer.m_9236_().f_46443_) {
            this.m_146852_(GameEvent.f_157803_, (Entity)pPlayer);
        }
    }

    @Nullable
    public ResourceLocation m_214142_() {
        return null;
    }

    public void m_214199_(@Nullable ResourceLocation pLootTable) {
    }

    public long m_213803_() {
        return 0L;
    }

    public void m_214065_(long pLootTableSeed) {
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pPlayerInventory, Player pPlayer) {
        if (!pPlayer.m_5833_() && this.hasMenu()) {
            return new VehicleMenu(pContainerId, pPlayerInventory, this);
        }
        return null;
    }

    public void m_5785_(@NotNull Player pPlayer) {
        this.m_9236_().m_214171_(GameEvent.f_157802_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)pPlayer));
    }

    @NotNull
    public NonNullList<ItemStack> m_213659_() {
        return this.items;
    }

    public void m_213775_() {
        this.items.clear();
    }
}

