/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.launcher;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.capability.energy.ItemEnergyProvider;
import com.atsuishio.superbwarfare.client.GunRendererBuilder;
import com.atsuishio.superbwarfare.client.TooltipTool;
import com.atsuishio.superbwarfare.client.model.item.SecondaryCataclysmModel;
import com.atsuishio.superbwarfare.client.tooltip.component.SecondaryCataclysmImageComponent;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.RarityTool;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class SecondaryCataclysm
extends GunItem {
    private final Supplier<Integer> energyCapacity = () -> 24000;

    public SecondaryCataclysm() {
        super(new Item.Properties().m_41486_().m_41497_(RarityTool.LEGENDARY));
    }

    public boolean m_142522_(@NotNull ItemStack pStack) {
        if (!pStack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            return false;
        }
        AtomicInteger energy = new AtomicInteger(0);
        pStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(e -> energy.set(e.getEnergyStored()));
        return energy.get() != 0;
    }

    public int m_142158_(@NotNull ItemStack pStack) {
        AtomicInteger energy = new AtomicInteger(0);
        pStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(e -> energy.set(e.getEnergyStored()));
        return Math.round((float)energy.get() * 13.0f / 24000.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemEnergyProvider(stack, this.energyCapacity.get());
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237119_());
        list.add((Component)Component.m_237115_((String)"des.superbwarfare.secondary_cataclysm_1").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        TooltipTool.addHideText(list, (Component)Component.m_237119_());
        TooltipTool.addHideText(list, (Component)Component.m_237115_((String)"des.superbwarfare.trachelium_3").m_130940_(ChatFormatting.WHITE));
        TooltipTool.addHideText(list, (Component)Component.m_237115_((String)"des.superbwarfare.secondary_cataclysm_2").m_130948_(Style.f_131099_.m_178520_(6863350)));
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        return 9824767;
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return GunRendererBuilder.simple(SecondaryCataclysmModel::new, 0.0, 0.0, 1.0375, 0.6);
    }

    private PlayState reloadAnimPredicate(AnimationState<SecondaryCataclysm> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.secondary_cataclysm.idle"));
        }
        GunData data = GunData.from(stack);
        if (data.reload.stage() == 1 && data.reload.prepareLoadTimer.get() > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.secondary_cataclysm.prepare"));
        }
        if (data.loadIndex.get() == 0 && data.reload.stage() == 2) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.secondary_cataclysm.iterativeload"));
        }
        if (data.loadIndex.get() == 1 && data.reload.stage() == 2) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.secondary_cataclysm.iterativeload2"));
        }
        if (data.reload.stage() == 3) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.secondary_cataclysm.finish"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.secondary_cataclysm.idle"));
    }

    private PlayState meleePredicate(AnimationState<SecondaryCataclysm> event) {
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.secondary_cataclysm.idle"));
        }
        if (ClientEventHandler.gunMelee > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.secondary_cataclysm.hit"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.secondary_cataclysm.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController reloadAnimController = new AnimationController((GeoAnimatable)this, "reloadAnimController", 1, this::reloadAnimPredicate);
        data.add(new AnimationController[]{reloadAnimController});
        AnimationController meleeController = new AnimationController((GeoAnimatable)this, "meleeController", 0, this::meleePredicate);
        data.add(new AnimationController[]{meleeController});
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack cell : player.m_150109_().f_35974_) {
                if (!cell.m_150930_((Item)ModItems.CELL.get())) continue;
                assert (stack.getCapability(ForgeCapabilities.ENERGY).resolve().isPresent());
                IEnergyStorage stackStorage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).resolve().get();
                int stackMaxEnergy = stackStorage.getMaxEnergyStored();
                int stackEnergy = stackStorage.getEnergyStored();
                assert (cell.getCapability(ForgeCapabilities.ENERGY).resolve().isPresent());
                IEnergyStorage cellStorage = (IEnergyStorage)cell.getCapability(ForgeCapabilities.ENERGY).resolve().get();
                int cellEnergy = cellStorage.getEnergyStored();
                int stackEnergyNeed = Math.min(cellEnergy, stackMaxEnergy - stackEnergy);
                if (cellEnergy > 0) {
                    stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> iEnergyStorage.receiveEnergy(stackEnergyNeed, false));
                }
                cell.getCapability(ForgeCapabilities.ENERGY).ifPresent(cEnergy -> cEnergy.extractEnergy(stackEnergyNeed, false));
            }
        }
    }

    @Override
    public ResourceLocation getGunIcon(ItemStack stack) {
        return Mod.loc("textures/gun_icon/secondary_cataclysm_icon.png");
    }

    @Override
    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack pStack) {
        return Optional.of(new SecondaryCataclysmImageComponent(pStack));
    }

    @Override
    public boolean shootBullet(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
        boolean isChargedFire;
        ItemStack stack = data.stack;
        Boolean hasEnoughEnergy = stack.getCapability(ForgeCapabilities.ENERGY).map(storage -> storage.getEnergyStored() >= 3000).orElse(false);
        boolean bl = isChargedFire = zoom && hasEnoughEnergy != false;
        if (isChargedFire) {
            data.setTempProperty(GunProp.DAMAGE, (d, v) -> v * 1.25);
            data.setTempProperty(GunProp.VELOCITY, (d, v) -> v * 4.0);
        }
        if (!super.shootBullet(shooter, level, shootPosition, shootDirection, data, spread, zoom, uuid)) {
            return false;
        }
        ParticleTool.sendParticle(level, ParticleTypes.f_123796_, shootPosition.f_82479_ + 1.8 * shootDirection.f_82479_, shootPosition.f_82480_ - 0.35 + 1.8 * shootDirection.f_82480_, shootPosition.f_82481_ + 1.8 * shootDirection.f_82481_, 4, 0.1, 0.1, 0.1, 0.002, true);
        if (isChargedFire) {
            stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> energy.extractEnergy(3000, false));
        }
        return true;
    }

    @Override
    public void playFireSounds(GunData data, Entity shooter, boolean zoom) {
        data.stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> {
            if (cap.getEnergyStored() > 3000 && zoom) {
                float soundRadius = data.get(GunProp.SOUND_RADIUS).floatValue();
                shooter.m_5496_((SoundEvent)ModSounds.SECONDARY_CATACLYSM_FIRE_3P_CHARGE.get(), soundRadius * 0.4f, 1.0f);
                shooter.m_5496_((SoundEvent)ModSounds.SECONDARY_CATACLYSM_FAR_CHARGE.get(), soundRadius * 0.7f, 1.0f);
                shooter.m_5496_((SoundEvent)ModSounds.SECONDARY_CATACLYSM_VERYFAR_CHARGE.get(), soundRadius, 1.0f);
            } else {
                super.playFireSounds(data, shooter, zoom);
            }
        });
    }
}

