/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.machinegun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.GunRendererBuilder;
import com.atsuishio.superbwarfare.client.model.item.M2HBItemModel;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class M2HBItem
extends GunItem {
    public M2HBItem() {
        super(new Item.Properties().m_41497_(Rarity.RARE));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return GunRendererBuilder.simple(M2HBItemModel::new, 0.0, 0.1, 2.95, 1.2);
    }

    private PlayState fireAnimPredicate(AnimationState<M2HBItem> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_2_hb.idle"));
        }
        if (ClientEventHandler.firePosTimer > 0.0 && ClientEventHandler.firePosTimer < 0.45) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_2_hb.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_2_hb.idle"));
    }

    private PlayState idlePredicate(AnimationState<M2HBItem> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_2_hb.idle"));
        }
        if (GunData.from((ItemStack)stack).reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_2_hb.reload_empty"));
        }
        if (GunData.from((ItemStack)stack).reload.normal()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_2_hb.reload_normal"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_2_hb.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController fireAnimController = new AnimationController((GeoAnimatable)this, "fireAnimController", 0, this::fireAnimPredicate);
        data.add(new AnimationController[]{fireAnimController});
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 4, this::idlePredicate);
        data.add(new AnimationController[]{idleController});
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.M_2_HB_RELOAD_EMPTY.get(), (SoundEvent)ModSounds.M_2_HB_RELOAD_NORMAL.get());
    }

    @Override
    public ResourceLocation getGunIcon(ItemStack stack) {
        return Mod.loc("textures/gun_icon/m_2_hb_icon.png");
    }

    @Override
    public boolean isOpenBolt(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canEjectShell(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasBulletInBarrel(ItemStack stack) {
        return true;
    }

    @Override
    public void beforeShoot(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom) {
        super.beforeShoot(shooter, level, shootPosition, shootDirection, data, spread, zoom);
        if (data.currentAvailableShots(shooter) <= 5) {
            data.hideBulletChain.set(true);
        }
    }

    @Override
    public void addReloadTimeBehavior(Map<Integer, Consumer<GunData>> behaviors) {
        super.addReloadTimeBehavior(behaviors);
        behaviors.put(70, data -> data.hideBulletChain.reset());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IClientItemExtensions getClientExtensions() {
        return new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer;
            private static final HumanoidModel.ArmPose POSE = HumanoidModel.ArmPose.create((String)"M2HB", (boolean)false, (model, entity, arm) -> {
                if (arm != HumanoidArm.LEFT) {
                    model.f_102811_.f_104203_ = 0.7853982f + model.f_102808_.f_104203_;
                    model.f_102811_.f_104204_ = model.f_102808_.f_104204_;
                    model.f_102812_.f_104203_ = Mth.m_14036_((float)(-0.7853982f + model.f_102808_.f_104203_), (float)-1.1780972f, (float)0.0f);
                    model.f_102812_.f_104204_ = Mth.m_14036_((float)(0.7853982f + model.f_102808_.f_104204_), (float)0.7853982f, (float)1.3962634f);
                }
            });
            {
                this.renderer = (BlockEntityWithoutLevelRenderer)M2HBItem.this.getRenderer().get();
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack stack) {
                if (!stack.m_41619_() && entityLiving.m_7655_() == hand) {
                    return POSE;
                }
                return HumanoidModel.ArmPose.EMPTY;
            }
        };
    }
}

