/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.menu;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.VehicleAssemblingTableVehicleEntity;
import com.atsuishio.superbwarfare.init.ModMenuTypes;
import com.atsuishio.superbwarfare.network.message.receive.FinishAssemblingVehicleMessage;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingIngredient;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingRecipe;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleAssemblingMenu
extends AbstractContainerMenu {
    private final boolean isVehicleMenu;

    public VehicleAssemblingMenu(int pContainerId, Inventory inventory) {
        super((MenuType)ModMenuTypes.VEHICLE_ASSEMBLING_MENU.get(), pContainerId);
        this.isVehicleMenu = false;
    }

    public VehicleAssemblingMenu(int pContainerId, Inventory inventory, boolean isVehicleMenu) {
        super((MenuType)ModMenuTypes.VEHICLE_ASSEMBLING_MENU.get(), pContainerId);
        this.isVehicleMenu = isVehicleMenu;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player pPlayer) {
        return pPlayer.m_6084_() && !this.isVehicleMenu || this.isVehicleMenu && pPlayer.m_20202_() instanceof VehicleAssemblingTableVehicleEntity;
    }

    public void assembleVehicle(ResourceLocation id, ServerPlayer player) {
        VehicleAssemblingRecipe recipe = this.getRecipeById(id, player.m_9236_().m_7465_());
        if (recipe == null) {
            return;
        }
        player.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            if (!player.m_7500_()) {
                Int2IntArrayMap recordCount = new Int2IntArrayMap();
                List<VehicleAssemblingIngredient> ingredients = recipe.getInputs();
                for (VehicleAssemblingIngredient ingredient : ingredients) {
                    int count = 0;
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack stack = handler.getStackInSlot(i);
                        int stackCount = stack.m_41613_();
                        if (stack.m_41619_() || !ingredient.getIngredient().test(stack)) continue;
                        if ((count += stackCount) > ingredient.getCount()) {
                            int remaining = count - ingredient.getCount();
                            recordCount.put(i, stackCount - remaining);
                            break;
                        }
                        recordCount.put(i, stackCount);
                    }
                    if (count >= ingredient.getCount()) continue;
                    return;
                }
                IntIterator intIterator = recordCount.keySet().iterator();
                while (intIterator.hasNext()) {
                    int slotIndex = (Integer)intIterator.next();
                    handler.extractItem(slotIndex, recordCount.get(slotIndex), false);
                }
            }
            Level level = player.m_9236_();
            if (!level.f_46443_) {
                ItemEntity itemEntity = new ItemEntity(level, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), recipe.m_8043_(player.m_9236_().m_9598_()).m_41777_());
                itemEntity.m_32010_(0);
                level.m_7967_((Entity)itemEntity);
            }
            player.f_36095_.m_182423_();
            Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new FinishAssemblingVehicleMessage(this.f_38840_));
        });
    }

    @Nullable
    public VehicleAssemblingRecipe getRecipeById(ResourceLocation id, RecipeManager recipeManager) {
        Recipe recipe = recipeManager.m_44043_(id).orElse(null);
        if (recipe instanceof VehicleAssemblingRecipe) {
            VehicleAssemblingRecipe assemblingRecipe = (VehicleAssemblingRecipe)recipe;
            return assemblingRecipe;
        }
        return null;
    }
}

