/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mixins;

import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.mixin.OBBHitter;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProjectileUtil.class})
public class ProjectileUtilMixin {
    @Inject(method={"getEntityHitResult(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;F)Lnet/minecraft/world/phys/EntityHitResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getEntityHitResult(Level pLevel, Entity pProjectile, Vec3 pStartVec, Vec3 pEndVec, AABB pBoundingBox, Predicate<Entity> pFilter, float pInflationAmount, CallbackInfoReturnable<EntityHitResult> cir) {
        for (Entity entity : pLevel.m_6249_(pProjectile, pBoundingBox.m_82400_(2.0), pFilter)) {
            Projectile projectile;
            if (!(entity instanceof OBBEntity)) continue;
            OBBEntity obbEntity = (OBBEntity)entity;
            if (pProjectile instanceof Projectile && ((projectile = (Projectile)pProjectile).m_19749_() == entity || entity.m_20197_().contains(projectile.m_19749_()))) continue;
            List<OBB> obbList = obbEntity.getOBBs();
            for (OBB obb : obbList) {
                double d1;
                Optional<Vector3f> optional = obb.clip(pStartVec.m_252839_(), pEndVec.m_252839_());
                if (!optional.isPresent() || !((d1 = pStartVec.m_82557_(new Vec3(optional.get()))) < Double.MAX_VALUE)) continue;
                EntityHitResult hitResult = new EntityHitResult(entity, new Vec3(optional.get()));
                OBBHitter acc = OBBHitter.getInstance(pProjectile);
                acc.sbw$setCurrentHitPart(obb.part());
                cir.setReturnValue((Object)hitResult);
                if (!(pLevel instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)pLevel;
                if (!(pProjectile.m_20184_().m_82556_() > 0.01) || !(pProjectile instanceof Projectile)) continue;
                Vec3 hitPos = hitResult.m_82450_();
                pLevel.m_5594_(null, BlockPos.m_274446_((Position)hitPos), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 2, 0.0, 0.0, 0.0, 0.2, false);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123762_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 2, 0.0, 0.0, 0.0, 0.01, false);
            }
        }
    }

    @Inject(method={"getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getEntityHitResult(Entity pShooter, Vec3 pStartVec, Vec3 pEndVec, AABB pBoundingBox, Predicate<Entity> pFilter, double pDistance, CallbackInfoReturnable<EntityHitResult> cir) {
        Level level = pShooter.m_9236_();
        for (Entity entity : level.m_6249_(pShooter, pBoundingBox.m_82400_(2.0), pFilter)) {
            if (!(entity instanceof OBBEntity)) continue;
            OBBEntity obbEntity = (OBBEntity)entity;
            if (entity.m_20197_().contains(pShooter)) continue;
            List<OBB> obbList = obbEntity.getOBBs();
            for (OBB obb : obbList) {
                Vec3 vec;
                double d1;
                obb = obb.inflate(entity.m_6143_() * 2.0f);
                Optional<Vector3f> optional = obb.clip(pStartVec.m_252839_(), pEndVec.m_252839_());
                if (obb.contains(pStartVec)) {
                    if (!(pDistance >= 0.0)) continue;
                    cir.setReturnValue((Object)new EntityHitResult(entity, new Vec3(optional.orElse(pStartVec.m_252839_()))));
                    return;
                }
                if (!optional.isPresent() || !((d1 = pStartVec.m_82557_(vec = new Vec3(optional.get()))) < pDistance) && pDistance != 0.0) continue;
                if (entity.m_20201_() == pShooter.m_20201_() && !entity.canRiderInteract()) {
                    if (pDistance != 0.0) continue;
                    cir.setReturnValue((Object)new EntityHitResult(entity, vec));
                    return;
                }
                cir.setReturnValue((Object)new EntityHitResult(entity, vec));
                return;
            }
        }
    }
}

